/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.mihini.tm.core.softwarepackage;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.koneki.mihini.tm.core.AbstractRESTService;

public class SoftwarePackageUpdater
extends AbstractRESTService {
    private static final String PATH_INSTALL = "/update/";
    private static final String QUERY_INSTALL = "sync=1";

    public SoftwarePackageUpdater(String host, int port) {
        super(host, port);
    }

    public void applyPackage(InputStream packageStream, IProgressMonitor monitor) throws CoreException {
        try {
            HttpPost request = new HttpPost(this.getURI(PATH_INSTALL, QUERY_INSTALL).toASCIIString());
            request.setEntity((HttpEntity)new InputStreamEntity(packageStream, -1L));
            HttpResponse response = this.getHttpClient().execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                SoftwarePackageUpdater.throwException(MessageFormat.format("Unable to install package. Status : {0} ", this.getErrorMessage(response)), null, 4);
            }
        }
        catch (IOException e) {
            SoftwarePackageUpdater.throwException("Unable to install package.", e, 4);
        }
        catch (URISyntaxException e) {
            SoftwarePackageUpdater.throwException("Unable to install package.", e, 4);
        }
    }

    private static void throwException(String message, Throwable t, int severity) throws CoreException {
        throw new CoreException((IStatus)new Status(severity, "org.eclipse.koneki.mihini.tm.core", message, t));
    }
}

