/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.mihini.tm.ui.adapters;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.koneki.mihini.tm.ui.Activator;
import org.eclipse.koneki.mihini.tm.ui.subsystem.software.SoftwareResource;
import org.eclipse.rse.internal.ui.SystemPropertyResources;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SoftwareAdapter
extends AbstractSystemViewAdapter
implements ISystemRemoteElementAdapter {
    private static final String STATUS_PREFIX = "__software__status__";
    private static final String ATTRIBUTES_PREFIX = "__software__attributes__";
    private SoftwareResource software;

    public SoftwareAdapter(SoftwareResource ressource) {
        this.software = ressource;
    }

    public String getText(Object element) {
        return this.software.getName();
    }

    public String getAbsoluteName(Object object) {
        if (object instanceof SoftwareResource) {
            return ((SoftwareResource)((Object)object)).getName();
        }
        return this.software.getName();
    }

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell parent, String menuGroup) {
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        SoftwareResource soft = element instanceof SoftwareResource ? (SoftwareResource)((Object)element) : this.software;
        if (soft.isRunnable()) {
            if (soft.isRunning()) {
                return Activator.getDefault().getImageRegistry().getDescriptor("icons/etool16/app_running.png");
            }
            return Activator.getDefault().getImageRegistry().getDescriptor("icons/etool16/app_icon.png");
        }
        return Activator.getDefault().getImageRegistry().getDescriptor("icons/etool16/lib_icon.png");
    }

    public String getType(Object element) {
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof SoftwareResource) {
            return ((SoftwareResource)((Object)element)).getSubSystem();
        }
        return this.software.getSubSystem();
    }

    public boolean hasChildren(IAdaptable element) {
        return false;
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        return null;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        return null;
    }

    protected Object internalGetPropertyValue(Object key) {
        if (key instanceof String) {
            String skey = (String)key;
            if (skey.startsWith(STATUS_PREFIX)) {
                return this.software.getStatus().get(skey.replaceFirst("^__software__status__", ""));
            }
            if (skey.startsWith(ATTRIBUTES_PREFIX)) {
                return this.software.getAttributes().get(skey.replaceFirst("^__software__attributes__", ""));
            }
        }
        return null;
    }

    public String getRemoteSubType(Object element) {
        return null;
    }

    public String getRemoteType(Object element) {
        return null;
    }

    public String getRemoteTypeCategory(Object element) {
        return null;
    }

    public String getSubSystemConfigurationId(Object element) {
        return null;
    }

    public String getAbsoluteParentName(Object element) {
        if (element instanceof SoftwareResource) {
            return ((SoftwareResource)((Object)element)).getSubSystem().getName();
        }
        return null;
    }

    public boolean refreshRemoteObject(Object oldElement, Object newElement) {
        return false;
    }

    public Object getRemoteParent(Object element, IProgressMonitor monitor) throws Exception {
        return null;
    }

    public String[] getRemoteParentNamesInUse(Object element, IProgressMonitor monitor) throws Exception {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        PropertyDescriptor namePropertyDescriptor = SoftwareAdapter.createSimplePropertyDescriptor((String)"org.eclipse.jface.text", (String)SystemPropertyResources.RESID_PROPERTY_NAME_LABEL, (String)SystemPropertyResources.RESID_PROPERTY_NAME_TOOLTIP);
        result.add(namePropertyDescriptor);
        Map<?, ?> attributes = this.software.getAttributes();
        for (Map.Entry<?, ?> entry : attributes.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            String attributeKey = (String)entry.getKey();
            PropertyDescriptor propertyDescriptor = SoftwareAdapter.createSimplePropertyDescriptor((String)(ATTRIBUTES_PREFIX + attributeKey), (String)StringUtils.capitalize((String)attributeKey), (String)StringUtils.capitalize((String)attributeKey));
            result.add(propertyDescriptor);
        }
        Map<?, ?> status = this.software.getStatus();
        for (Map.Entry<?, ?> entry : status.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            String statusKey = (String)entry.getKey();
            PropertyDescriptor propertyDescriptor = SoftwareAdapter.createSimplePropertyDescriptor((String)(STATUS_PREFIX + statusKey), (String)StringUtils.capitalize((String)statusKey), (String)StringUtils.capitalize((String)statusKey));
            result.add(propertyDescriptor);
        }
        return result.toArray(new IPropertyDescriptor[result.size()]);
    }
}

