/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.mihini.tm.ui.handlers;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.koneki.mihini.tm.core.softwarepackage.ApplicationContainer;
import org.eclipse.koneki.mihini.tm.ui.Activator;
import org.eclipse.koneki.mihini.tm.ui.handlers.AbstractSoftwareHandler;
import org.eclipse.koneki.mihini.tm.ui.handlers.Messages;
import org.eclipse.koneki.mihini.tm.ui.subsystem.software.SoftwareResource;
import org.eclipse.koneki.mihini.tm.ui.subsystem.software.SoftwareSubSystem;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class AutoStartSoftwareHandler
extends AbstractSoftwareHandler
implements IElementUpdater {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final SoftwareResource software = this.getSoftwareRessource(event);
        if (software == null) {
            return null;
        }
        final SoftwareSubSystem subsystem = this.getSoftwareSubSystem(event);
        if (subsystem == null) {
            return null;
        }
        Command command = event.getCommand();
        final boolean actualAutoStart = HandlerUtil.toggleCommandState((Command)command);
        Job job = new Job(NLS.bind((String)Messages.AutoStartSoftwareHandlerJobname, (Object)actualAutoStart, (Object)software.getName())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ApplicationContainer appcon = new ApplicationContainer(subsystem.getHostName(), subsystem.getPort());
                    appcon.configure(software.getName(), Boolean.valueOf(!actualAutoStart));
                    ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                    registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)software, 85, null));
                }
                catch (CoreException e) {
                    String message = MessageFormat.format(Messages.AutoStartSoftwareHandlerError, software.getName());
                    Status status = new Status(4, "org.eclipse.koneki.mihini.tm.ui", message, (Throwable)e);
                    Activator.log((IStatus)status);
                    return status;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        SoftwareResource selectedApplication = this.getSoftwareRessource(selection);
        if (selectedApplication != null) {
            element.setChecked(selectedApplication.isAutostart());
        }
    }
}

