/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.mihini.tm.ui.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.koneki.mihini.tm.core.softwarepackage.DefaultSoftwarePackageGenerator;
import org.eclipse.koneki.mihini.tm.core.softwarepackage.ManifestMode;
import org.eclipse.koneki.mihini.tm.core.softwarepackage.SoftwarePackageUpdater;
import org.eclipse.koneki.mihini.tm.ui.Activator;
import org.eclipse.koneki.mihini.tm.ui.handlers.AbstractSoftwareHandler;
import org.eclipse.koneki.mihini.tm.ui.handlers.Messages;
import org.eclipse.koneki.mihini.tm.ui.subsystem.software.SoftwareResource;
import org.eclipse.koneki.mihini.tm.ui.subsystem.software.SoftwareSubSystem;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UninstallSoftwareHandler
extends AbstractSoftwareHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final SoftwareResource software = this.getSoftwareRessource(event);
        if (software == null) {
            return null;
        }
        final SoftwareSubSystem subsystem = this.getSoftwareSubSystem(event);
        if (subsystem == null) {
            return null;
        }
        String question = MessageFormat.format(Messages.SoftwareUninstallHandlerQuestion, software.getName());
        Shell shell = Display.getDefault().getActiveShell();
        if (!MessageDialog.openQuestion((Shell)shell, (String)Messages.SoftwareUninstallHandlerTitle, (String)question)) {
            return null;
        }
        Job job = new Job(NLS.bind((String)Messages.UninstallSoftwareHandlerJobname, (Object)software.getName())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PipedInputStream inputStream = new PipedInputStream();
                    PipedOutputStream outputStream = new PipedOutputStream(inputStream);
                    DefaultSoftwarePackageGenerator packageGenerator = new DefaultSoftwarePackageGenerator(software.getName(), null);
                    packageGenerator.startGenerationInStream((OutputStream)outputStream, null, ManifestMode.UNINSTALL, (IProgressMonitor)new NullProgressMonitor());
                    SoftwarePackageUpdater softwarePackageUpdater = new SoftwarePackageUpdater(subsystem.getHostName(), subsystem.getPort());
                    softwarePackageUpdater.applyPackage((InputStream)inputStream, (IProgressMonitor)new NullProgressMonitor());
                    ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                    registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)software, 85, (Object)subsystem));
                }
                catch (CoreException e) {
                    Activator.logError("Unable to uninstall package.", e);
                    Status status = new Status(4, "org.eclipse.koneki.mihini.tm.ui", "Unable to uninstall package.", (Throwable)e);
                    return status;
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.eclipse.koneki.mihini.tm.ui", "Unable to uninstall package.", (Throwable)e);
                    Activator.logError("Unable to uninstall package.", e);
                    return status;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return null;
    }
}

