/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.mihini.tm.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.koneki.mihini.tm.core.softwarepackage.AbstractSoftwarePackageGenerator;
import org.eclipse.koneki.mihini.tm.ui.RSEUtil;
import org.eclipse.koneki.mihini.tm.ui.SWTUtil;
import org.eclipse.koneki.mihini.tm.ui.wizards.Messages;
import org.eclipse.koneki.mihini.tm.ui.wizards.SoftwarePackageExportWizard;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.ui.widgets.SystemHostCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SoftwarePackageExportFirstPage
extends WizardPage {
    private TableViewer projectList;
    private Text directoryField;
    private Button browseDirectoryButton;
    private final String selectedProjectName;
    private Text versionField;
    private SystemHostCombo hostList;
    private Button hostRadioButton;
    private Button directoryRadioButton;
    private Text nameField;

    public SoftwarePackageExportFirstPage(IStructuredSelection selection) {
        super("ExportAleosSoftwarePackage");
        this.setTitle(Messages.SoftwarePackageExportFirstPageTitle);
        this.setDescription(Messages.SoftwarePackageExportFirstPageDescription);
        this.selectedProjectName = this.getProjectNameFromSelection(selection);
    }

    private IProject[] getProjects() {
        return ((SoftwarePackageExportWizard)this.getWizard()).getProjects();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.projectList = new TableViewer(composite, 2820);
        this.projectList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.projectList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.projectList.setInput((Object)this.getProjects());
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.projectList.getTable());
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.SoftwarePackageExportFirstPage_Name);
        this.nameField = new Text(composite, 2052);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.nameField);
        Label versionLabel = new Label(composite, 0);
        versionLabel.setText(Messages.SoftwarePackageExportFirstPageVersion);
        this.versionField = new Text(composite, 2052);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.versionField);
        Group destinationGroup = new Group(composite, 0);
        destinationGroup.setText(Messages.SoftwarePackageExportFirstPageDestinationGroup);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)destinationGroup);
        GridDataFactory.swtDefaults().grab(true, false).span(2, 1).align(4, 0x1000000).applyTo((Control)destinationGroup);
        this.hostRadioButton = new Button((Composite)destinationGroup, 16);
        this.hostRadioButton.setText(Messages.SoftwarePackageExportFirstPageExportHost);
        RSEUtil.waitForRSEInitialization();
        IHost selectFirstHost = null;
        this.hostList = new SystemHostCombo((Composite)destinationGroup, 4, selectFirstHost, true, "software", false);
        GridDataFactory.swtDefaults().grab(true, false).span(2, 1).align(4, 0x1000000).applyTo((Control)this.hostList);
        int buttonWidthHint = SWTUtil.getButtonWidthHint(this.hostList.getNewButton());
        this.hostList.setButtonWidthHint(buttonWidthHint);
        this.directoryRadioButton = new Button((Composite)destinationGroup, 16);
        this.directoryRadioButton.setText(Messages.SoftwarePackageExportFirstPageExportDirectory);
        this.directoryField = new Text((Composite)destinationGroup, 2052);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.directoryField);
        this.browseDirectoryButton = new Button((Composite)destinationGroup, 8);
        this.browseDirectoryButton.setText(Messages.SoftwarePackageExportFirstPageBrowse);
        int horizontalHint = SWTUtil.getButtonWidthHint(this.browseDirectoryButton);
        GridDataFactory.swtDefaults().align(0x1000008, 1).hint(horizontalHint, -1).applyTo((Control)this.browseDirectoryButton);
        this.addListeners();
        this.setPageComplete(this.validatePage());
        this.init();
        this.setControl((Control)composite);
    }

    private void addListeners() {
        this.directoryField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SoftwarePackageExportFirstPage.this.setPageComplete(SoftwarePackageExportFirstPage.this.validatePage());
            }
        });
        this.projectList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SoftwarePackageExportFirstPage.this.refreshNameField();
                SoftwarePackageExportFirstPage.this.setPageComplete(SoftwarePackageExportFirstPage.this.validatePage());
            }
        });
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SoftwarePackageExportFirstPage.this.setPageComplete(SoftwarePackageExportFirstPage.this.validatePage());
            }
        });
        this.versionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SoftwarePackageExportFirstPage.this.setPageComplete(SoftwarePackageExportFirstPage.this.validatePage());
            }
        });
        this.browseDirectoryButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dirDialog = new DirectoryDialog(SoftwarePackageExportFirstPage.this.getShell());
                String outputDirecory = dirDialog.open();
                if (outputDirecory == null || outputDirecory.isEmpty()) {
                    return;
                }
                if (SoftwarePackageExportFirstPage.this.directoryField != null) {
                    SoftwarePackageExportFirstPage.this.directoryField.setText(outputDirecory);
                }
                SoftwarePackageExportFirstPage.this.setPageComplete(SoftwarePackageExportFirstPage.this.validatePage());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.directoryRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SoftwarePackageExportFirstPage.this.toggleDestination();
                SoftwarePackageExportFirstPage.this.setPageComplete(SoftwarePackageExportFirstPage.this.validatePage());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.hostRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SoftwarePackageExportFirstPage.this.toggleDestination();
                SoftwarePackageExportFirstPage.this.setPageComplete(SoftwarePackageExportFirstPage.this.validatePage());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private boolean validatePage() {
        String error = null;
        switch (this.getDestinationType()) {
            case DIRECTORY: {
                error = AbstractSoftwarePackageGenerator.validateInstallPackageGeneration((IProject)this.getSelectedProject(), (String)this.getName(), (String)this.getVersion(), (IPath)this.getOutputDirectory());
                break;
            }
            case HOST: {
                error = AbstractSoftwarePackageGenerator.validateInstallPackageGeneration((IProject)this.getSelectedProject(), (String)this.getName(), (String)this.getVersion());
                if (error != null || this.getHost() != null) break;
                error = "No host provided.";
                break;
            }
            default: {
                error = "Unable to determine destination.";
            }
        }
        if (error != null) {
            this.setErrorMessage(error);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private String getProjectNameFromSelection(IStructuredSelection aSelection) {
        IProject project;
        if (aSelection == null) {
            return "";
        }
        Object firstElement = aSelection.getFirstElement();
        if (firstElement instanceof IProject) {
            return ((IProject)firstElement).getName();
        }
        if (firstElement != null && (project = (IProject)Platform.getAdapterManager().getAdapter(firstElement, IProject.class)) != null) {
            return project.getName();
        }
        return "";
    }

    private void init() {
        if (this.hostRadioButton != null) {
            this.hostRadioButton.setSelection(true);
        }
        this.toggleDestination();
        Object in = this.projectList.getInput();
        if (!(in instanceof IProject[])) {
            return;
        }
        IProject[] projectArray = (IProject[])in;
        boolean projectFound = false;
        int i = 0;
        while (i < projectArray.length && !projectFound) {
            IProject project = projectArray[i];
            if (project.getName().equals(this.selectedProjectName)) {
                this.projectList.setSelection((ISelection)new StructuredSelection((Object)project));
                projectFound = true;
            }
            ++i;
        }
        this.refreshNameField();
        this.setErrorMessage(null);
    }

    private void toggleDestination() {
        if (this.directoryRadioButton == null || this.hostList == null) {
            return;
        }
        if (this.hostRadioButton.getSelection()) {
            this.hostList.setEnabled(true);
            this.directoryField.setEnabled(false);
        } else {
            this.hostList.setEnabled(false);
            this.directoryField.setEnabled(true);
        }
    }

    public IPath getOutputDirectory() {
        if (this.directoryField != null) {
            return new Path(this.directoryField.getText());
        }
        return null;
    }

    public IProject getSelectedProject() {
        IStructuredSelection structured;
        Object firstElement;
        ISelection selection;
        if (this.projectList != null && (selection = this.projectList.getSelection()) instanceof IStructuredSelection && (firstElement = (structured = (IStructuredSelection)selection).getFirstElement()) instanceof IProject) {
            return (IProject)firstElement;
        }
        return null;
    }

    public String getName() {
        if (this.nameField != null) {
            return this.nameField.getText();
        }
        return "";
    }

    public String getVersion() {
        if (this.versionField != null) {
            return this.versionField.getText();
        }
        return "";
    }

    public IHost getHost() {
        if (this.hostList != null) {
            return this.hostList.getHost();
        }
        return null;
    }

    public DestinationType getDestinationType() {
        if (this.hostRadioButton != null && this.hostRadioButton.getSelection()) {
            return DestinationType.HOST;
        }
        if (this.directoryRadioButton != null && this.directoryRadioButton.getSelection()) {
            return DestinationType.DIRECTORY;
        }
        return DestinationType.NONE;
    }

    private void refreshNameField() {
        IProject selectedProject = this.getSelectedProject();
        if (selectedProject != null) {
            this.nameField.setText(selectedProject.getName());
        }
    }

    public static enum DestinationType {
        DIRECTORY,
        HOST,
        NONE;

    }
}

