/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.mihini.tm.ui.wizards;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.koneki.mihini.tm.core.softwarepackage.AbstractSoftwarePackageGenerator;
import org.eclipse.koneki.mihini.tm.core.softwarepackage.ManifestMode;
import org.eclipse.koneki.mihini.tm.core.softwarepackage.SoftwarePackageUpdater;
import org.eclipse.koneki.mihini.tm.ui.Activator;
import org.eclipse.koneki.mihini.tm.ui.RSEUtil;
import org.eclipse.koneki.mihini.tm.ui.subsystem.software.SoftwareSubSystem;
import org.eclipse.koneki.mihini.tm.ui.wizards.Messages;
import org.eclipse.koneki.mihini.tm.ui.wizards.SoftwarePackageExportFirstPage;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public abstract class SoftwarePackageExportWizard
extends Wizard
implements IExportWizard {
    private IStructuredSelection userSelection;
    private SoftwarePackageExportFirstPage exportPage = null;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.SoftwarePackageExportWizardWindowTitle);
        this.userSelection = selection;
        this.setDefaultPageImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor("icons/wizban/exp_package_wiz.png"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.exportPage = new SoftwarePackageExportFirstPage(this.userSelection);
        this.addPage((IWizardPage)this.exportPage);
    }

    public boolean performFinish() {
        PlatformUI.getWorkbench().saveAllEditors(true);
        final SoftwarePackageExportFirstPage.DestinationType destinationType = this.exportPage.getDestinationType();
        final IProject selectedProject = this.exportPage.getSelectedProject();
        final IPath outputDirectory = this.exportPage.getOutputDirectory();
        final String version = this.exportPage.getVersion();
        final String name = this.exportPage.getName();
        final IHost host = this.exportPage.getHost();
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        AbstractSoftwarePackageGenerator packageGenerator = SoftwarePackageExportWizard.this.createPackageGenerator(name, selectedProject);
                        switch (destinationType) {
                            case DIRECTORY: {
                                packageGenerator.generateInOutputDir(outputDirectory, version, ManifestMode.INSTALL, monitor);
                                break;
                            }
                            case HOST: {
                                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                                PipedInputStream inputStream = new PipedInputStream();
                                PipedOutputStream outputStream = new PipedOutputStream(inputStream);
                                packageGenerator.startGenerationInStream((OutputStream)outputStream, version, ManifestMode.INSTALL, (IProgressMonitor)subMonitor);
                                SoftwareSubSystem softwareSubsystem = RSEUtil.getSoftwareSubsystem(host);
                                new SoftwarePackageUpdater(softwareSubsystem.getHostName(), softwareSubsystem.getPort()).applyPackage((InputStream)inputStream, (IProgressMonitor)subMonitor.newChild(1));
                                ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                                registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)softwareSubsystem, 85, null));
                                break;
                            }
                            default: {
                                throw new CoreException((IStatus)new Status(1, "org.eclipse.koneki.mihini.tm.ui", "Unable to determine Software Package export destination."));
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.koneki.mihini.tm.ui", "Unable to run export.", e.getCause());
            ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)status);
            Activator.log((IStatus)status);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected abstract AbstractSoftwarePackageGenerator createPackageGenerator(String var1, IProject var2);

    public IProject[] getProjects() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && project.isOpen()) {
                projects.add(project);
            }
            ++n2;
        }
        return projects.toArray(new IProject[projects.size()]);
    }
}

