/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets.services;

import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.ui.widgets.services.PropertyElement;
import org.eclipse.swt.graphics.Image;

public abstract class ServiceElement {
    protected IHost _host;
    protected ServiceElement _parent;
    protected boolean _isSelected = false;
    protected boolean _childChanged = false;

    public ServiceElement(IHost host, ServiceElement parent) {
        this._host = host;
        this._parent = parent;
    }

    public Image getImage() {
        return null;
    }

    public IHost getHost() {
        ServiceElement[] elements;
        if (this._host == null && (elements = this.getChildren()) != null) {
            int i = 0;
            while (i < elements.length) {
                ServiceElement el = elements[i];
                if (el.isSelected()) {
                    return el.getHost();
                }
                ++i;
            }
        }
        return this._host;
    }

    public void childChanged(ServiceElement element) {
        this._childChanged = true;
        if (this._parent != null) {
            this._parent.childChanged(element);
        }
    }

    public void setParent(ServiceElement parent) {
        this._parent = parent;
    }

    public ServiceElement getParent() {
        return this._parent;
    }

    public void setSelected(boolean flag) {
        this._isSelected = flag;
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public String toString() {
        return this.getName();
    }

    public abstract boolean hasProperties();

    public abstract PropertyElement[] getProperties();

    public abstract String getName();

    public abstract String getDescription();

    public abstract boolean hasChildren();

    public abstract ServiceElement[] getChildren();

    public abstract void commit();

    public abstract void revert();
}

