/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.protocols.omadm.client.http.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.util.EntityUtils;
import org.eclipse.koneki.protocols.omadm.client.DMClientException;
import org.eclipse.koneki.protocols.omadm.client.basic.DMBasicClient;

public class DMHttpClient
extends DMBasicClient {
    private final HttpClient httpClient;

    public DMHttpClient() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(schemeRegistry));
    }

    protected void sendAndReceiveMessage(URI server, String encoding, final DMBasicClient.DMMessenger messenger) throws IOException, DMClientException {
        try {
            HttpPost post = new HttpPost(server);
            EntityTemplate entity = new EntityTemplate(new ContentProducer(){

                public void writeTo(OutputStream out) throws IOException {
                    try {
                        messenger.writeMessage(out);
                    }
                    catch (DMClientException e) {
                        throw new IOException(e);
                    }
                }
            });
            entity.setChunked(false);
            entity.setContentEncoding(encoding);
            entity.setContentType("application/vnd.syncml.dm+xml");
            post.setEntity((HttpEntity)entity);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() > 299) {
                throw new DMClientException(response.getStatusLine().toString());
            }
            messenger.readMessage(response.getEntity().getContent());
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            if (e.getCause() != null && e.getCause() instanceof DMClientException) {
                throw (DMClientException)e.getCause();
            }
            throw e;
        }
    }
}

