/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.protocols.omadm.client.basic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.eclipse.koneki.protocols.omadm.CommandHandler;
import org.eclipse.koneki.protocols.omadm.DMGenericAlert;
import org.eclipse.koneki.protocols.omadm.DMItem;
import org.eclipse.koneki.protocols.omadm.DMMeta;
import org.eclipse.koneki.protocols.omadm.DMNode;
import org.eclipse.koneki.protocols.omadm.ProtocolListener;
import org.eclipse.koneki.protocols.omadm.Status;
import org.eclipse.koneki.protocols.omadm.StatusCode;
import org.eclipse.koneki.protocols.omadm.client.DMClientException;
import org.eclipse.koneki.protocols.omadm.client.basic.DMBasicClient;
import org.eclipse.koneki.protocols.omadm.client.basic.DMIDGenerator;
import org.eclipse.koneki.protocols.omadm.client.basic.DMStatusManager;
import org.eclipse.koneki.protocols.omadm.client.internal.Activator;

final class DMBasicSession
implements Runnable {
    private static final String ENCODING = "UTF-8";
    private static final short UNKNOWN = 0;
    private static final short STATUS = 1;
    private static final short GET = 2;
    private static final short FINAL = 3;
    private static final short ADD = 4;
    private static final short DELETE = 5;
    private static final short REPLACE = 6;
    private static final short COPY = 7;
    private static final short SEQUENCE = 8;
    private static final short ATOMIC = 9;
    private static final short EXEC = 10;
    private static final short ALERT = 11;
    private final DMBasicClient dmClient;
    private URI server;
    private final URI client;
    private final String sessionId;
    private final DMNode[] devInfoNodes;
    private final CommandHandler commandHandler;
    private final ProtocolListener[] protocolLinsteners;
    private final DMGenericAlert[] genericAlerts;
    private final DMIDGenerator idGenerator;
    private final DMStatusManager statusManager;
    private final Map<String, Object[]> commandSends;
    private boolean isSessionContinue;
    private boolean isClientAuthenticated;
    private boolean isSetupPhaseFired;
    private boolean isManagementPhaseFired;
    private String currentServerMsgID;
    private final String userAuth;

    public DMBasicSession(DMBasicClient dmClient, URI server, String userAuth, URI client, String sessionId, DMNode[] devInfoNodes, CommandHandler commandHandler, ProtocolListener[] protocolLinsteners, DMGenericAlert[] genericAlerts) {
        this.userAuth = userAuth;
        this.dmClient = dmClient;
        this.server = server;
        this.client = client;
        this.sessionId = sessionId;
        this.devInfoNodes = devInfoNodes;
        this.commandHandler = commandHandler;
        this.protocolLinsteners = protocolLinsteners;
        this.genericAlerts = genericAlerts;
        this.idGenerator = new DMIDGenerator();
        this.statusManager = new DMStatusManager();
        this.commandSends = new HashMap<String, Object[]>();
    }

    @Override
    public void run() {
        this.fireSessionBegin(this.sessionId);
        try {
            this.isSessionContinue = false;
            this.isClientAuthenticated = false;
            this.isSetupPhaseFired = false;
            this.isManagementPhaseFired = false;
            do {
                this.sendPackageAndReceivePackage();
            } while (this.isSessionContinue);
            this.fireSessionEnd();
        }
        catch (IOException e) {
            this.fireSessionEnd(e);
        }
        catch (DMClientException e) {
            this.fireSessionEnd(e);
        }
        catch (RuntimeException e) {
            this.fireSessionEnd(e);
            throw e;
        }
    }

    void sendPackageAndReceivePackage() throws IOException, DMClientException {
        this.dmClient.sendAndReceiveMessage(this.server, ENCODING, new DMBasicClient.DMMessenger(){

            @Override
            public void writeMessage(OutputStream out) throws DMClientException {
                try {
                    if (!DMBasicSession.this.isSetupPhaseFired) {
                        DMBasicSession.this.fireSetupPhaseBegin();
                        DMBasicSession.this.isSetupPhaseFired = true;
                    }
                    if (!DMBasicSession.this.isManagementPhaseFired && DMBasicSession.this.isClientAuthenticated) {
                        DMBasicSession.this.fireManagementPhaseBegin();
                        DMBasicSession.this.isManagementPhaseFired = true;
                    }
                    if (DMBasicSession.this.protocolLinsteners.length != 0) {
                        ByteArrayOutputStream message = new ByteArrayOutputStream();
                        DMBasicSession.this.writeMessage((OutputStream)new TeeOutputStream(out, (OutputStream)message));
                        DMBasicSession.this.fireNewClientPackage(message.toString(DMBasicSession.ENCODING));
                    } else {
                        DMBasicSession.this.writeMessage(out);
                    }
                }
                catch (XMLStreamException e) {
                    throw new DMClientException(e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new DMClientException(e);
                }
            }

            @Override
            public void readMessage(InputStream in) throws DMClientException {
                try {
                    if (DMBasicSession.this.protocolLinsteners.length != 0) {
                        ByteArrayOutputStream message = new ByteArrayOutputStream();
                        DMBasicSession.this.readMessage((InputStream)new TeeInputStream(in, (OutputStream)message));
                        DMBasicSession.this.fireNewServerPackage(message.toString(DMBasicSession.ENCODING));
                    } else {
                        DMBasicSession.this.readMessage(in);
                    }
                    if (!DMBasicSession.this.isManagementPhaseFired && DMBasicSession.this.isClientAuthenticated) {
                        DMBasicSession.this.fireSetupPhaseEnd();
                    }
                    if (!DMBasicSession.this.isSessionContinue) {
                        DMBasicSession.this.fireManagementPhaseEnd();
                    }
                }
                catch (XMLStreamException e) {
                    throw new DMClientException(e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new DMClientException(e);
                }
            }
        });
    }

    private void writeMessage(OutputStream out) throws XMLStreamException {
        XMLStreamWriter writer = this.dmClient.createXMLStreamWriter(out, ENCODING);
        writer.writeStartDocument(ENCODING, "1.0");
        writer.writeStartElement("SyncML");
        writer.writeAttribute("xmlns", "SYNCML:SYNCML1.2");
        writer.writeStartElement("SyncHdr");
        writer.writeStartElement("VerDTD");
        writer.writeCharacters("1.2");
        writer.writeEndElement();
        writer.writeStartElement("VerProto");
        writer.writeCharacters("DM/1.2");
        writer.writeEndElement();
        writer.writeStartElement("SessionID");
        writer.writeCharacters(this.sessionId);
        writer.writeEndElement();
        writer.writeStartElement("MsgID");
        writer.writeCharacters(String.valueOf(this.idGenerator.nextMsgID()));
        writer.writeEndElement();
        writer.writeStartElement("Target");
        writer.writeStartElement("LocURI");
        writer.writeCharacters(this.server.toString());
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("Source");
        writer.writeStartElement("LocURI");
        writer.writeCharacters(this.client.toString());
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("Cred");
        writer.writeStartElement("Meta");
        writer.writeStartElement("Format");
        writer.writeAttribute("xmlns", "syncml:metinf");
        writer.writeCharacters("b64");
        writer.writeEndElement();
        writer.writeStartElement("Type");
        writer.writeAttribute("xmlns", "syncml:metinf");
        writer.writeCharacters("syncml:auth-basic");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("Data");
        writer.writeCharacters(this.userAuth);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("SyncBody");
        this.writeStatus(writer);
        if (!this.isClientAuthenticated) {
            this.writeAlert(writer, "1201");
            this.writeGenericAlert(writer, this.genericAlerts);
            this.writeReplace(writer, this.devInfoNodes);
        }
        writer.writeStartElement("Final");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        writer.close();
    }

    private void writeStatus(XMLStreamWriter writer) throws XMLStreamException {
        while (this.statusManager.isValidStatus()) {
            writer.writeStartElement("Status");
            writer.writeStartElement("CmdID");
            writer.writeCharacters(String.valueOf(this.idGenerator.nextCmdID()));
            writer.writeEndElement();
            writer.writeStartElement("MsgRef");
            writer.writeCharacters(this.statusManager.getMsgRef());
            writer.writeEndElement();
            writer.writeStartElement("CmdRef");
            writer.writeCharacters(this.statusManager.getCmdRef());
            writer.writeEndElement();
            writer.writeStartElement("Cmd");
            writer.writeCharacters(this.statusManager.getCmd());
            writer.writeEndElement();
            for (String targetRef : this.statusManager.getTargetRef()) {
                writer.writeStartElement("TargetRef");
                writer.writeCharacters(targetRef);
                writer.writeEndElement();
            }
            for (String sourceRef : this.statusManager.getSourceRef()) {
                writer.writeStartElement("SourceRef");
                writer.writeCharacters(sourceRef);
                writer.writeEndElement();
            }
            writer.writeStartElement("Data");
            writer.writeCharacters(this.statusManager.getStatusCode());
            writer.writeEndElement();
            writer.writeEndElement();
            if (!this.statusManager.getResults().isEmpty()) {
                writer.writeStartElement("Results");
                writer.writeStartElement("CmdID");
                writer.writeCharacters(String.valueOf(this.idGenerator.nextCmdID()));
                writer.writeEndElement();
                writer.writeStartElement("MsgRef");
                writer.writeCharacters(this.statusManager.getMsgRef());
                writer.writeEndElement();
                writer.writeStartElement("CmdRef");
                writer.writeCharacters(this.statusManager.getCmdRef());
                writer.writeEndElement();
                for (DMStatusManager.Results results : this.statusManager.getResults()) {
                    writer.writeStartElement("Item");
                    writer.writeStartElement("Source");
                    writer.writeStartElement("LocURI");
                    writer.writeCharacters(results.getSourceURI());
                    writer.writeEndElement();
                    writer.writeEndElement();
                    writer.writeStartElement("Meta");
                    writer.writeStartElement("Format");
                    writer.writeAttribute("xmlns", "syncml:metinf");
                    writer.writeCharacters(results.getFormat());
                    writer.writeEndElement();
                    writer.writeStartElement("Type");
                    writer.writeAttribute("xmlns", "syncml:metinf");
                    writer.writeCharacters(results.getType());
                    writer.writeEndElement();
                    writer.writeEndElement();
                    writer.writeStartElement("Data");
                    writer.writeCharacters(results.getData());
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            this.statusManager.nextStatus();
        }
    }

    private void writeAlert(XMLStreamWriter writer, String statusCode) throws XMLStreamException {
        writer.writeStartElement("Alert");
        writer.writeStartElement("CmdID");
        writer.writeCharacters(String.valueOf(this.idGenerator.nextCmdID()));
        writer.writeEndElement();
        writer.writeStartElement("Data");
        writer.writeCharacters(statusCode);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void writeGenericAlert(XMLStreamWriter writer, DMGenericAlert[] genAlerts) throws XMLStreamException {
        DMGenericAlert[] dMGenericAlertArray = genAlerts;
        int n = genAlerts.length;
        int n2 = 0;
        while (n2 < n) {
            DMGenericAlert genericAlert = dMGenericAlertArray[n2];
            String cmdID = String.valueOf(this.idGenerator.nextCmdID());
            DMMeta meta = new DMMeta();
            meta.put((Object)2, (Object)genericAlert.getType());
            meta.put((Object)1, (Object)genericAlert.getFormat());
            meta.put((Object)3, (Object)genericAlert.getMark());
            this.commandSends.put(cmdID, new Object[]{"1226", genericAlert.getCorrelator(), new DMItem[]{new DMItem(null, genericAlert.getSource(), meta, genericAlert.getData())}});
            writer.writeStartElement("Alert");
            writer.writeStartElement("CmdID");
            writer.writeCharacters(cmdID);
            writer.writeEndElement();
            writer.writeStartElement("Data");
            writer.writeCharacters("1226");
            writer.writeEndElement();
            if (genericAlert.getCorrelator() != null) {
                writer.writeStartElement("Correlator");
                writer.writeCharacters(genericAlert.getCorrelator());
                writer.writeEndElement();
            }
            writer.writeStartElement("Item");
            if (genericAlert.getSource() != null) {
                writer.writeStartElement("Source");
                writer.writeStartElement("LocURI");
                writer.writeCharacters(genericAlert.getSource());
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeStartElement("Meta");
            writer.writeStartElement("Type");
            writer.writeAttribute("xmlns", "syncml:metinf");
            writer.writeCharacters(genericAlert.getType());
            writer.writeEndElement();
            writer.writeStartElement("Format");
            writer.writeAttribute("xmlns", "syncml:metinf");
            writer.writeCharacters(genericAlert.getFormat());
            writer.writeEndElement();
            writer.writeStartElement("Mark");
            writer.writeAttribute("xmlns", "syncml:metinf");
            writer.writeCharacters(genericAlert.getMark());
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("Data");
            writer.writeCharacters(genericAlert.getData());
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            ++n2;
        }
    }

    private void writeReplace(XMLStreamWriter writer, DMNode[] nodes) throws XMLStreamException {
        if (this.devInfoNodes.length >= 1) {
            boolean sameFormat = true;
            boolean sameType = true;
            if (this.devInfoNodes.length >= 2) {
                int i = 1;
                while (i < this.devInfoNodes.length) {
                    if (sameFormat && !this.devInfoNodes[i].getFormat().equals(this.devInfoNodes[0].getFormat())) {
                        sameFormat = false;
                    }
                    if (sameType && !this.devInfoNodes[i].getType().equals(this.devInfoNodes[0].getType())) {
                        sameType = false;
                    }
                    ++i;
                }
            }
            writer.writeStartElement("Replace");
            writer.writeStartElement("CmdID");
            writer.writeCharacters(String.valueOf(this.idGenerator.nextCmdID()));
            writer.writeEndElement();
            if (sameFormat || sameType) {
                writer.writeStartElement("Meta");
                if (sameFormat) {
                    writer.writeStartElement("Format");
                    writer.writeAttribute("xmlns", "syncml:metinf");
                    writer.writeCharacters(this.devInfoNodes[0].getFormat());
                    writer.writeEndElement();
                }
                if (sameType) {
                    writer.writeStartElement("Type");
                    writer.writeAttribute("xmlns", "syncml:metinf");
                    writer.writeCharacters(this.devInfoNodes[0].getType());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            DMNode[] dMNodeArray = this.devInfoNodes;
            int n = this.devInfoNodes.length;
            int n2 = 0;
            while (n2 < n) {
                DMNode devInfoNode = dMNodeArray[n2];
                writer.writeStartElement("Item");
                writer.writeStartElement("Source");
                writer.writeStartElement("LocURI");
                writer.writeCharacters(devInfoNode.getURI());
                writer.writeEndElement();
                writer.writeEndElement();
                if (!sameFormat || !sameType) {
                    writer.writeStartElement("Meta");
                    if (!sameFormat) {
                        writer.writeStartElement("Format");
                        writer.writeAttribute("xmlns", "syncml:metinf");
                        writer.writeCharacters(devInfoNode.getFormat());
                        writer.writeEndElement();
                    }
                    if (!sameType) {
                        writer.writeStartElement("Type");
                        writer.writeAttribute("xmlns", "syncml:metinf");
                        writer.writeCharacters(devInfoNode.getType());
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeStartElement("Data");
                writer.writeCharacters(devInfoNode.getData());
                writer.writeEndElement();
                writer.writeEndElement();
                ++n2;
            }
            writer.writeEndElement();
        }
    }

    private void readMessage(InputStream in) throws XMLStreamException {
        XMLStreamReader reader = this.dmClient.createXMLStreamReader(in, ENCODING, new StreamFilter(){

            @Override
            public boolean accept(XMLStreamReader reader) {
                return !reader.isWhiteSpace() && !reader.isStandalone();
            }
        });
        DMBasicSession.jumpToStartTag(reader, "SyncHdr");
        this.readSyncHdr(reader);
        reader.nextTag();
        this.readSyncBody(reader);
        reader.nextTag();
        reader.close();
    }

    private void readSyncHdr(XMLStreamReader reader) throws XMLStreamException {
        DMBasicSession.jumpToStartTag(reader, "MsgID");
        this.currentServerMsgID = reader.getElementText();
        DMBasicSession.jumpToStartTag(reader, "RespURI");
        try {
            String newServer = reader.getElementText();
            if (newServer != null) {
                this.server = new URI(newServer);
            }
        }
        catch (URISyntaxException e) {
            Activator.logError("Malformed RespURI in sync header", e);
        }
        DMBasicSession.jumpToEndTag(reader, "SyncHdr");
        this.statusManager.putStatus(this.currentServerMsgID, "0", "SyncHdr", null, null, String.valueOf(StatusCode.AUTHENTICATION_ACCEPTED.getCode()));
    }

    private void readSyncBody(XMLStreamReader reader) throws XMLStreamException {
        boolean continueSyncBody = true;
        do {
            int next = reader.nextTag();
            String name = reader.getLocalName();
            block0 : switch (next) {
                case 1: {
                    switch (DMBasicSession.getKey(name)) {
                        case 1: {
                            this.readStatus(reader);
                            break block0;
                        }
                        case 4: {
                            this.readAdd(reader, new DMMeta());
                            break block0;
                        }
                        case 7: {
                            this.readCopy(reader);
                            break block0;
                        }
                        case 5: {
                            this.readDelete(reader);
                            break block0;
                        }
                        case 2: {
                            this.readGet(reader);
                            break block0;
                        }
                        case 6: {
                            this.readReplace(reader, new DMMeta());
                            break block0;
                        }
                        case 10: {
                            this.readExec(reader, new DMMeta());
                            break block0;
                        }
                        case 8: {
                            this.readSequence(reader);
                            break block0;
                        }
                        case 9: {
                            this.readAtomic(reader);
                            break block0;
                        }
                        case 3: {
                            this.readFinal(reader);
                            break block0;
                        }
                        case 11: {
                            this.readAlert(reader);
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    continueSyncBody = false;
                    break;
                }
            }
        } while (continueSyncBody);
    }

    private void readAlert(XMLStreamReader reader) throws XMLStreamException {
        reader.nextTag();
        String cmdID = reader.getElementText();
        reader.nextTag();
        this.statusManager.putStatus(this.currentServerMsgID, cmdID, "Alert", null, null, "406");
        DMBasicSession.jumpToEndTag(reader, "Alert");
    }

    private void readStatus(XMLStreamReader reader) throws XMLStreamException {
        DMBasicSession.jumpToStartTag(reader, "CmdRef");
        String cmdRef = reader.getElementText();
        reader.nextTag();
        String cmd = reader.getElementText();
        DMBasicSession.jumpToStartTag(reader, "Data");
        int data = Integer.parseInt(reader.getElementText());
        DMBasicSession.jumpToEndTag(reader, "Status");
        if (cmd.equals("SyncHdr")) {
            switch (data) {
                case 212: {
                    this.isClientAuthenticated = true;
                    break;
                }
                case 407: {
                    this.isClientAuthenticated = false;
                    break;
                }
            }
        }
        if (this.commandSends.containsKey(cmdRef)) {
            Object[] objects = this.commandSends.get(cmdRef);
            if (cmd.equals("Alert")) {
                ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
                int n = this.protocolLinsteners.length;
                int n2 = 0;
                while (n2 < n) {
                    ProtocolListener messageListener = protocolListenerArray[n2];
                    messageListener.clientAlert((String)objects[0], (String)objects[1], (DMItem[])objects[2], (Status)StatusCode.fromInt((int)data));
                    ++n2;
                }
            }
            this.commandSends.remove(cmdRef);
        }
    }

    private void readGet(XMLStreamReader reader) throws XMLStreamException {
        reader.nextTag();
        String cmdID = reader.getElementText();
        reader.nextTag();
        if (reader.getLocalName().equals("Meta")) {
            DMBasicSession.jumpToEndTag(reader, "Meta");
            reader.nextTag();
        }
        boolean continueGet = true;
        block4: do {
            switch (reader.getEventType()) {
                case 1: {
                    DMItem item = this.readItem(reader, new DMMeta());
                    reader.nextTag();
                    Status status = this.commandHandler.get(item.getTargetURI());
                    DMNode results = status.getResult();
                    if (results != null) {
                        this.statusManager.putStatus(this.currentServerMsgID, cmdID, "Get", item.getTargetURI(), null, String.valueOf(status.getCode()), results.getFormat(), results.getType(), results.getData());
                    } else {
                        this.statusManager.putStatus(this.currentServerMsgID, cmdID, "Get", item.getTargetURI(), null, String.valueOf(status.getCode()));
                    }
                    ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
                    int n = this.protocolLinsteners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ProtocolListener messageListener = protocolListenerArray[n2];
                        messageListener.get(item.getTargetURI(), status);
                        ++n2;
                    }
                    continue block4;
                }
                case 2: {
                    continueGet = false;
                    break;
                }
            }
        } while (continueGet);
    }

    private void readAdd(XMLStreamReader reader, DMMeta parentMeta) throws XMLStreamException {
        reader.nextTag();
        String cmdID = reader.getElementText();
        reader.nextTag();
        DMMeta globalMeta = new DMMeta(parentMeta);
        if (reader.getLocalName().equals("Meta")) {
            globalMeta.putAll((Map)this.readMeta(reader));
            reader.nextTag();
        }
        boolean continueAdd = true;
        block4: do {
            switch (reader.getEventType()) {
                case 1: {
                    DMItem item = this.readItem(reader, globalMeta);
                    reader.nextTag();
                    Status status = this.commandHandler.add(item.getTargetURI(), item.getMeta().getFormat(), item.getMeta().getType(), item.getData());
                    this.statusManager.putStatus(this.currentServerMsgID, cmdID, "Add", item.getTargetURI(), null, String.valueOf(status.getCode()));
                    ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
                    int n = this.protocolLinsteners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ProtocolListener messageListener = protocolListenerArray[n2];
                        messageListener.add(item.getTargetURI(), item.getData(), status);
                        ++n2;
                    }
                    continue block4;
                }
                case 2: {
                    continueAdd = false;
                    break;
                }
            }
        } while (continueAdd);
    }

    private void readDelete(XMLStreamReader reader) throws XMLStreamException {
        reader.nextTag();
        String cmdID = reader.getElementText();
        reader.nextTag();
        if (reader.getLocalName().equals("Meta")) {
            DMBasicSession.jumpToEndTag(reader, "Meta");
            reader.nextTag();
        }
        boolean continueDelete = true;
        block4: do {
            switch (reader.getEventType()) {
                case 1: {
                    DMItem item = this.readItem(reader, new DMMeta());
                    reader.nextTag();
                    Status status = this.commandHandler.delete(item.getTargetURI());
                    this.statusManager.putStatus(this.currentServerMsgID, cmdID, "Delete", item.getTargetURI(), null, String.valueOf(status.getCode()));
                    ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
                    int n = this.protocolLinsteners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ProtocolListener messageListener = protocolListenerArray[n2];
                        messageListener.delete(item.getTargetURI(), status);
                        ++n2;
                    }
                    continue block4;
                }
                case 2: {
                    continueDelete = false;
                    break;
                }
            }
        } while (continueDelete);
    }

    private void readReplace(XMLStreamReader reader, DMMeta parentMeta) throws XMLStreamException {
        reader.nextTag();
        String cmdID = reader.getElementText();
        reader.nextTag();
        DMMeta globalMeta = new DMMeta(parentMeta);
        if (reader.getLocalName().equals("Meta")) {
            globalMeta.putAll((Map)this.readMeta(reader));
            reader.nextTag();
        }
        boolean continueReplace = true;
        block4: do {
            switch (reader.getEventType()) {
                case 1: {
                    DMItem item = this.readItem(reader, globalMeta);
                    reader.nextTag();
                    Status status = this.commandHandler.replace(item.getTargetURI(), item.getMeta().getFormat(), item.getMeta().getType(), item.getData());
                    this.statusManager.putStatus(this.currentServerMsgID, cmdID, "Replace", item.getTargetURI(), null, String.valueOf(status.getCode()));
                    ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
                    int n = this.protocolLinsteners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ProtocolListener messageListener = protocolListenerArray[n2];
                        messageListener.replace(item.getTargetURI(), item.getData(), status);
                        ++n2;
                    }
                    continue block4;
                }
                case 2: {
                    continueReplace = false;
                    break;
                }
            }
        } while (continueReplace);
    }

    private void readCopy(XMLStreamReader reader) throws XMLStreamException {
        reader.nextTag();
        String cmdID = reader.getElementText();
        reader.nextTag();
        if (reader.getLocalName().equals("Meta")) {
            DMBasicSession.jumpToEndTag(reader, "Meta");
            reader.nextTag();
        }
        boolean continueCopy = true;
        block4: do {
            switch (reader.getEventType()) {
                case 1: {
                    DMItem item = this.readItem(reader, null);
                    reader.nextTag();
                    Status status = this.commandHandler.copy(item.getTargetURI(), item.getSourceURI());
                    this.statusManager.putStatus(this.currentServerMsgID, cmdID, "Copy", item.getTargetURI(), item.getSourceURI(), String.valueOf(status.getCode()));
                    ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
                    int n = this.protocolLinsteners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ProtocolListener messageListener = protocolListenerArray[n2];
                        messageListener.copy(item.getTargetURI(), item.getSourceURI(), status);
                        ++n2;
                    }
                    continue block4;
                }
                case 2: {
                    continueCopy = false;
                    break;
                }
            }
        } while (continueCopy);
    }

    private void readExec(XMLStreamReader reader, DMMeta parentMeta) throws XMLStreamException {
        String correlator;
        reader.nextTag();
        String cmdID = reader.getElementText();
        reader.nextTag();
        DMMeta globalMeta = new DMMeta(parentMeta);
        if (reader.getLocalName().equals("Meta")) {
            globalMeta.putAll((Map)this.readMeta(reader));
            reader.nextTag();
        }
        if (reader.getLocalName().equals("Correlator")) {
            correlator = reader.getElementText();
            reader.nextTag();
        } else {
            correlator = null;
        }
        DMItem item = this.readItem(reader, globalMeta);
        reader.nextTag();
        final Status status = this.commandHandler.exec(item.getTargetURI(), correlator, item.getMeta().getFormat(), item.getMeta().getType(), item.getData());
        this.statusManager.putStatus(this.currentServerMsgID, cmdID, "Exec", item.getTargetURI(), item.getSourceURI(), String.valueOf(status.getCode()));
        if (status.getDelayedProcessing() != null) {
            this.dmClient.execute(this.client, new Runnable(){

                @Override
                public void run() {
                    try {
                        DMBasicSession.this.dmClient.initiateManagementSession(DMBasicSession.this.server, "", DMBasicSession.this.client, DMBasicSession.this.devInfoNodes, DMBasicSession.this.commandHandler, DMBasicSession.this.protocolLinsteners, new DMGenericAlert[]{(DMGenericAlert)status.getDelayedProcessing().call()});
                    }
                    catch (Exception e) {
                        Activator.logError("Error while initializing management session", e);
                    }
                }
            });
        }
        ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
        int n = this.protocolLinsteners.length;
        int n2 = 0;
        while (n2 < n) {
            ProtocolListener messageListener = protocolListenerArray[n2];
            messageListener.exec(item.getTargetURI(), correlator, item.getData(), status);
            ++n2;
        }
    }

    private void readSequence(XMLStreamReader reader) throws XMLStreamException {
        DMMeta globalMeta;
        reader.nextTag();
        String cmdID = reader.getElementText();
        reader.nextTag();
        if (reader.getLocalName().equals("Meta")) {
            globalMeta = this.readMeta(reader);
            reader.nextTag();
        } else {
            globalMeta = new DMMeta();
        }
        this.statusManager.putStatus(this.currentServerMsgID, cmdID, "Sequence", null, null, String.valueOf(StatusCode.OK.getCode()));
        boolean continueSequence = true;
        do {
            switch (reader.getEventType()) {
                case 1: {
                    switch (DMBasicSession.getKey(reader.getLocalName())) {
                        case 4: {
                            this.readAdd(reader, globalMeta);
                            break;
                        }
                        case 7: {
                            this.readCopy(reader);
                            break;
                        }
                        case 5: {
                            this.readDelete(reader);
                            break;
                        }
                        case 2: {
                            this.readGet(reader);
                            break;
                        }
                        case 6: {
                            this.readReplace(reader, globalMeta);
                            break;
                        }
                        case 10: {
                            this.readExec(reader, globalMeta);
                            break;
                        }
                    }
                    reader.nextTag();
                    break;
                }
                case 2: {
                    continueSequence = false;
                    break;
                }
            }
        } while (continueSequence);
    }

    private void readAtomic(XMLStreamReader reader) throws XMLStreamException {
        reader.nextTag();
        String cmdID = reader.getElementText();
        DMBasicSession.jumpToEndTag(reader, "Atomic");
        this.statusManager.putStatus(this.currentServerMsgID, cmdID, "Atomic", null, null, String.valueOf(StatusCode.OPTIONAL_FEATURE_NOT_SUPPORTED.getCode()));
    }

    private DMMeta readMeta(XMLStreamReader reader) throws XMLStreamException {
        DMMeta meta = new DMMeta();
        boolean continueMeta = true;
        do {
            block0 : switch (reader.next()) {
                case 1: {
                    switch (DMMeta.getKey((String)reader.getLocalName())) {
                        case 1: {
                            meta.put((Object)1, (Object)reader.getElementText());
                            break block0;
                        }
                        case 2: {
                            meta.put((Object)2, (Object)reader.getElementText());
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    continueMeta = false;
                    break;
                }
            }
        } while (continueMeta);
        return meta;
    }

    private DMItem readItem(XMLStreamReader reader, DMMeta parentMeta) throws XMLStreamException {
        String data;
        String sourceURI;
        String targetURI;
        reader.nextTag();
        if (reader.getLocalName().equals("Target")) {
            reader.nextTag();
            targetURI = reader.getElementText();
            reader.nextTag();
            if (reader.getLocalName().equals("LocName")) {
                DMBasicSession.jumpToEndTag(reader, "LocName");
                reader.nextTag();
            }
            reader.nextTag();
        } else {
            targetURI = null;
        }
        if (reader.getLocalName().equals("Source")) {
            reader.nextTag();
            sourceURI = reader.getElementText();
            reader.nextTag();
            if (reader.getLocalName().equals("LocName")) {
                DMBasicSession.jumpToEndTag(reader, "LocName");
                reader.nextTag();
            }
            reader.nextTag();
        } else {
            sourceURI = null;
        }
        DMMeta meta = new DMMeta(parentMeta);
        if (reader.getLocalName().equals("Meta")) {
            meta.putAll((Map)this.readMeta(reader));
            reader.nextTag();
        }
        if (reader.getLocalName().equals("Data")) {
            data = reader.getElementText();
            reader.nextTag();
        } else {
            data = null;
        }
        return new DMItem(targetURI, sourceURI, meta, data);
    }

    private void readFinal(XMLStreamReader reader) throws XMLStreamException {
        reader.nextTag();
        this.isSessionContinue = !this.statusManager.onlySyncHdrStatus();
    }

    private static short getKey(String tag) {
        if (tag.equals("Status")) {
            return 1;
        }
        if (tag.equals("Get")) {
            return 2;
        }
        if (tag.equals("Final")) {
            return 3;
        }
        if (tag.equals("Add")) {
            return 4;
        }
        if (tag.equals("Delete")) {
            return 5;
        }
        if (tag.equals("Replace")) {
            return 6;
        }
        if (tag.equals("Copy")) {
            return 7;
        }
        if (tag.equals("Sequence")) {
            return 8;
        }
        if (tag.equals("Atomic")) {
            return 9;
        }
        if (tag.equals("Exec")) {
            return 10;
        }
        if (tag.equals("Alert")) {
            return 11;
        }
        return 0;
    }

    private static void jumpToStartTag(XMLStreamReader reader, String tag) throws XMLStreamException {
        while (reader.next() != 1 || !reader.getLocalName().equals(tag)) {
        }
    }

    private static void jumpToEndTag(XMLStreamReader reader, String tag) throws XMLStreamException {
        while (reader.next() != 2 || !reader.getLocalName().equals(tag)) {
        }
    }

    private void fireSessionBegin(String sessionID) {
        ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
        int n = this.protocolLinsteners.length;
        int n2 = 0;
        while (n2 < n) {
            ProtocolListener messageListener = protocolListenerArray[n2];
            messageListener.sessionBegin(sessionID);
            ++n2;
        }
    }

    private void fireSessionEnd() {
        ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
        int n = this.protocolLinsteners.length;
        int n2 = 0;
        while (n2 < n) {
            ProtocolListener messageListener = protocolListenerArray[n2];
            messageListener.sessionEnd();
            ++n2;
        }
    }

    private void fireSessionEnd(Throwable t) {
        ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
        int n = this.protocolLinsteners.length;
        int n2 = 0;
        while (n2 < n) {
            ProtocolListener messageListener = protocolListenerArray[n2];
            messageListener.sessionEnd(t);
            ++n2;
        }
    }

    private void fireSetupPhaseBegin() {
        ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
        int n = this.protocolLinsteners.length;
        int n2 = 0;
        while (n2 < n) {
            ProtocolListener messageListener = protocolListenerArray[n2];
            messageListener.setupPhaseBegin();
            ++n2;
        }
    }

    private void fireSetupPhaseEnd() {
        ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
        int n = this.protocolLinsteners.length;
        int n2 = 0;
        while (n2 < n) {
            ProtocolListener messageListener = protocolListenerArray[n2];
            messageListener.setupPhaseEnd();
            ++n2;
        }
    }

    private void fireManagementPhaseBegin() {
        ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
        int n = this.protocolLinsteners.length;
        int n2 = 0;
        while (n2 < n) {
            ProtocolListener messageListener = protocolListenerArray[n2];
            messageListener.managementPhaseBegin();
            ++n2;
        }
    }

    private void fireManagementPhaseEnd() {
        ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
        int n = this.protocolLinsteners.length;
        int n2 = 0;
        while (n2 < n) {
            ProtocolListener messageListener = protocolListenerArray[n2];
            messageListener.managementPhaseEnd();
            ++n2;
        }
    }

    private void fireNewClientPackage(String message) {
        ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
        int n = this.protocolLinsteners.length;
        int n2 = 0;
        while (n2 < n) {
            ProtocolListener messageListener = protocolListenerArray[n2];
            messageListener.newClientPackage(message);
            ++n2;
        }
    }

    private void fireNewServerPackage(String message) {
        ProtocolListener[] protocolListenerArray = this.protocolLinsteners;
        int n = this.protocolLinsteners.length;
        int n2 = 0;
        while (n2 < n) {
            ProtocolListener messageListener = protocolListenerArray[n2];
            messageListener.newServerPackage(message);
            ++n2;
        }
    }
}

