/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.protocols.omadm.client.basic;

import java.net.URI;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;

final class DMSessionExecutor {
    private final ExecutorService executorService;
    private final ConcurrentHashMap<URI, Queue<Runnable>> commands;

    public DMSessionExecutor(ExecutorService executorService) {
        this.executorService = executorService;
        this.commands = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(URI client, Runnable command) {
        Queue<Runnable> clientCommands;
        Queue<Runnable> queue = clientCommands = this.getClientCommands(client);
        synchronized (queue) {
            clientCommands.offer(command);
            if (clientCommands.size() == 1) {
                this.executorService.execute(new DMSessionRunnableProxy(client));
            }
        }
    }

    private Queue<Runnable> getClientCommands(URI client) {
        LinkedList<Runnable> newClientCommands = new LinkedList<Runnable>();
        LinkedList<Runnable> clientCommands = this.commands.putIfAbsent(client, newClientCommands);
        return clientCommands != null ? clientCommands : newClientCommands;
    }

    private final class DMSessionRunnableProxy
    implements Runnable {
        private final URI client;

        public DMSessionRunnableProxy(URI client) {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable command;
            Queue clientCommands;
            Queue queue = clientCommands = DMSessionExecutor.this.getClientCommands(this.client);
            synchronized (queue) {
                command = (Runnable)clientCommands.element();
            }
            command.run();
            queue = clientCommands;
            synchronized (queue) {
                clientCommands.remove();
                if (clientCommands.size() >= 1) {
                    DMSessionExecutor.this.executorService.execute(this);
                }
            }
        }
    }
}

