/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model.loader;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.intro.impl.model.AbstractBaseIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroIdElement;
import org.eclipse.ui.internal.intro.impl.model.util.BundleUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class ModelLoaderUtil {
    public static boolean isValidElementName(IConfigurationElement element, String validName) {
        return element.getName().equals(validName);
    }

    public static IConfigurationElement validateSingleContribution(IConfigurationElement[] configElements, String logAttribute) {
        int arraySize = configElements.length;
        if (arraySize == 0) {
            return null;
        }
        IConfigurationElement configElement = configElements[0];
        if (Log.logInfo) {
            String msg = "Loading " + ModelLoaderUtil.getLogString(configElement, logAttribute);
            Log.info(msg);
        }
        if (arraySize != 1) {
            int i = 1;
            while (i < arraySize) {
                Log.warning(String.valueOf(ModelLoaderUtil.getLogString(configElements[i], logAttribute)) + " ignored due to multiple contributions");
                ++i;
            }
        }
        return configElement;
    }

    public static String getLogString(IConfigurationElement element, String logAttribute) {
        StringBuffer buffer = new StringBuffer(element.getName());
        buffer.append(" element");
        if (logAttribute != null) {
            buffer.append(" with ");
            buffer.append(logAttribute);
            buffer.append("=\"");
            buffer.append(element.getAttribute(logAttribute));
        }
        buffer.append("\" in extension: ");
        buffer.append(element.getDeclaringExtension().getExtensionPointUniqueIdentifier());
        buffer.append(" in Bundle: ");
        buffer.append(element.getContributor().getName());
        return buffer.toString();
    }

    public static String getLogString(Bundle bundle, Element element, String logAttribute) {
        StringBuffer buffer = new StringBuffer(element.getNodeName());
        buffer.append(" element");
        if (logAttribute != null) {
            buffer.append(" with ");
            buffer.append(logAttribute);
            buffer.append("=\"");
            buffer.append(element.getAttribute(logAttribute));
        }
        buffer.append("\" from xml file in Bundle:");
        buffer.append(bundle.getSymbolicName());
        return buffer.toString();
    }

    public static Object createClassInstance(String pluginId, String className) {
        if (pluginId == null || className == null) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (!BundleUtil.bundleHasValidState(bundle)) {
            return null;
        }
        try {
            Class aClass = bundle.loadClass(className);
            Object aObject = aClass.newInstance();
            return aObject;
        }
        catch (Exception e) {
            Log.error("Intro Could not instantiate: " + className + " in " + pluginId, e);
            return null;
        }
    }

    public static StringBuffer createPathToElementKey(AbstractIntroIdElement element, boolean full) {
        if (element.getId() == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(element.getId());
        AbstractBaseIntroElement parent = (AbstractBaseIntroElement)element.getParent();
        while (parent != null && !parent.isOfType(1)) {
            if (parent.getId() == null) {
                return null;
            }
            buffer.insert(0, String.valueOf(parent.getId()) + ".");
            parent = (AbstractBaseIntroElement)parent.getParent();
        }
        return buffer;
    }
}

