/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.IWorkingCopyProvider;
import org.eclipse.dltk.internal.ui.UIModelProviderManager;
import org.eclipse.dltk.ui.IModelContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class StandardModelElementContentProvider
implements ITreeContentProvider,
IWorkingCopyProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers;
    protected boolean fProvideWorkingCopy;

    public StandardModelElementContentProvider() {
        this(false);
    }

    public StandardModelElementContentProvider(boolean provideMembers) {
        this.fProvideMembers = provideMembers;
        this.fProvideWorkingCopy = provideMembers;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean b) {
        this.fProvideMembers = b;
    }

    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    public void setProvideWorkingCopy(boolean b) {
        this.fProvideWorkingCopy = b;
    }

    public boolean providesWorkingCopies() {
        return this.getProvideWorkingCopy();
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getExtendedChildren(Object element, Object[] children) {
        IModelContentProvider[] providers = UIModelProviderManager.getContentProviders(this.getToolkitID(element));
        if (providers.length > 0) {
            ArrayList elements = new ArrayList(children.length + 2);
            Collections.addAll(elements, children);
            int i = 0;
            while (i < providers.length) {
                providers[i].provideModelChanges(element, elements, this);
                ++i;
            }
            return elements.toArray();
        }
        return children;
    }

    private String getToolkitID(Object element) {
        IDLTKLanguageToolkit toolkit;
        if (element instanceof IModelElement && (toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)((IModelElement)element))) != null) {
            return toolkit.getNatureId();
        }
        return null;
    }

    public Object getExtendedParent(Object element) {
        IModelContentProvider[] providers = UIModelProviderManager.getContentProviders(this.getToolkitID(element));
        if (providers.length > 0) {
            int i = 0;
            while (i < providers.length) {
                Object parent = providers[i].getParentElement(element, this);
                if (parent != null) {
                    return parent;
                }
                ++i;
            }
        }
        return null;
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return this.getExtendedChildren(element, NO_CHILDREN);
        }
        try {
            if (element instanceof IScriptModel) {
                return this.getExtendedChildren(element, this.getScriptProjects((IScriptModel)element));
            }
            if (element instanceof IScriptProject) {
                return this.getExtendedChildren(element, this.getProjectFragments((IScriptProject)element));
            }
            if (element instanceof IProjectFragment) {
                return this.getExtendedChildren(element, this.getProjectFragmentContent((IProjectFragment)element));
            }
            if (element instanceof IScriptFolder) {
                return this.getExtendedChildren(element, this.getScriptFolderContent((IScriptFolder)element));
            }
            if (element instanceof IFolder) {
                return this.getExtendedChildren(element, this.getFolderContent((IFolder)element));
            }
            if (this.getProvideMembers() && element instanceof ISourceReference && element instanceof IParent) {
                return this.getExtendedChildren(element, ((IParent)element).getChildren());
            }
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
        return this.getExtendedChildren(element, NO_CHILDREN);
    }

    public boolean hasChildren(Object element) {
        Object[] children;
        IScriptProject jp;
        if (this.getProvideMembers()) {
            if (element instanceof ISourceModule) {
                return true;
            }
        } else if (element instanceof ISourceModule || element instanceof IFile) {
            return false;
        }
        if (element instanceof IScriptProject && !(jp = (IScriptProject)element).getProject().isOpen()) {
            return false;
        }
        if (element instanceof IParent) {
            try {
                if (((IParent)element).hasChildren()) {
                    return true;
                }
            }
            catch (ModelException modelException) {
                return true;
            }
        }
        return (children = this.getChildren(element)) != null && children.length > 0;
    }

    public Object getParent(Object element) {
        if (!this.exists(element)) {
            return this.getExtendedParent(element);
        }
        Object parent = this.getExtendedParent(element);
        if (parent != null) {
            return parent;
        }
        return this.internalGetParent(element);
    }

    protected Object[] getProjectFragmentContent(IProjectFragment root) throws ModelException {
        Object[] fragments = root.getChildren();
        ArrayList<IModelElement> newFragments = new ArrayList<IModelElement>();
        int i = 0;
        while (i < fragments.length) {
            IScriptFolder scriptFolder;
            if (fragments[i] instanceof IScriptFolder && (scriptFolder = (IScriptFolder)fragments[i]).isRootFolder()) {
                IModelElement[] children = scriptFolder.getChildren();
                int j = 0;
                while (j < children.length) {
                    newFragments.add(children[j]);
                    ++j;
                }
            } else {
                newFragments.add(fragments[i]);
            }
            ++i;
        }
        fragments = newFragments.toArray(new IModelElement[newFragments.size()]);
        if (this.isProjectProjectFragment(root)) {
            return fragments;
        }
        Object[] nonJavaResources = root.getForeignResources();
        if (nonJavaResources == null) {
            return fragments;
        }
        return StandardModelElementContentProvider.concatenate(fragments, nonJavaResources);
    }

    protected Object[] getProjectFragments(IScriptProject project) throws ModelException {
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        IProjectFragment[] roots = project.getProjectFragments();
        ArrayList<Object> list = new ArrayList<Object>(roots.length);
        int i = 0;
        while (i < roots.length) {
            IProjectFragment root = roots[i];
            if (this.isProjectProjectFragment(root)) {
                Object[] fragments = this.getProjectFragmentContent(root);
                int j = 0;
                while (j < fragments.length) {
                    list.add(fragments[j]);
                    ++j;
                }
            } else {
                list.add(root);
            }
            ++i;
        }
        Object[] resources = project.getForeignResources();
        int i2 = 0;
        while (i2 < resources.length) {
            list.add(resources[i2]);
            ++i2;
        }
        return list.toArray();
    }

    protected Object[] getScriptProjects(IScriptModel jm) throws ModelException {
        return jm.getScriptProjects();
    }

    protected Object[] getScriptFolderContent(IScriptFolder fragment) throws ModelException {
        return StandardModelElementContentProvider.concatenate(fragment.getSourceModules(), fragment.getForeignResources());
    }

    protected Object[] getFolderContent(IFolder folder) throws CoreException {
        Object[] members = folder.members();
        IScriptProject javaProject = DLTKCore.create((IProject)folder.getProject());
        if (javaProject == null || !javaProject.exists()) {
            return members;
        }
        boolean isFolderOnClasspath = javaProject.isOnBuildpath((IResource)folder);
        ArrayList<Object> nonJavaResources = new ArrayList<Object>();
        int i = 0;
        while (i < members.length) {
            Object member = members[i];
            if (isFolderOnClasspath) {
                if (javaProject.findProjectFragment(member.getFullPath()) == null) {
                    nonJavaResources.add(member);
                }
            } else if (!javaProject.isOnBuildpath((IResource)member)) {
                nonJavaResources.add(member);
            }
            ++i;
        }
        return nonJavaResources.toArray();
    }

    protected boolean isBuildPathChange(IModelElementDelta delta) {
        if (delta.getElement().getElementType() != 3) {
            return false;
        }
        int flags = delta.getFlags();
        return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
    }

    protected Object skipProjectProjectFragment(IProjectFragment root) {
        if (this.isProjectProjectFragment(root)) {
            return root.getParent();
        }
        return root;
    }

    protected boolean isScriptFolderEmpty(IModelElement element) throws ModelException {
        IScriptFolder fragment;
        return element instanceof IScriptFolder && (fragment = (IScriptFolder)element).exists() && !fragment.hasChildren() && fragment.getForeignResources().length <= 0 && fragment.hasSubfolders();
    }

    protected boolean isProjectProjectFragment(IProjectFragment root) {
        IScriptProject javaProject = root.getScriptProject();
        return javaProject != null && javaProject.getPath().equals((Object)root.getPath());
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        if (element instanceof IModelElement) {
            return ((IModelElement)element).exists();
        }
        return true;
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IResource) {
            IContainer parent = ((IResource)element).getParent();
            IModelElement jParent = DLTKCore.create((IResource)parent);
            if (jParent != null && jParent.exists()) {
                return jParent;
            }
            return parent;
        }
        if (element instanceof IModelElement) {
            IModelElement parent = ((IModelElement)element).getParent();
            if (element instanceof IScriptFolder) {
                return this.skipProjectProjectFragment((IProjectFragment)parent);
            }
            if (parent instanceof IScriptFolder && parent.getPath().equals((Object)parent.getParent().getPath()) && !parent.getPath().equals((Object)parent.getScriptProject().getPath())) {
                return parent.getParent();
            }
            return parent;
        }
        return null;
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        if (a1Len == 0) {
            return a2;
        }
        if (a2Len == 0) {
            return a1;
        }
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }
}

