/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.ui.internal.interpreters;

import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.debug.ui.interpreters.ScriptInterpreterPreferencePage;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.koneki.ldt.debug.ui.internal.interpreters.LuaInterpretersBlock;
import org.eclipse.koneki.ldt.debug.ui.internal.interpreters.LuaInterpretersUpdater;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class LuaInterpreterPreferencePage
extends ScriptInterpreterPreferencePage {
    private LuaInterpretersBlock fInterpretersBlock;

    public InterpretersBlock createInterpretersBlock() {
        return new LuaInterpretersBlock();
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        this.fInterpretersBlock = (LuaInterpretersBlock)this.createInterpretersBlock();
        this.fInterpretersBlock.createControl(ancestor);
        Control control = this.fInterpretersBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.fInterpretersBlock.restoreColumnSettings(this.getDialogSettings(false), "org.eclipse.dltk.debug.ui.interpreter_preference_page_context");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)ancestor, "org.eclipse.dltk.debug.ui.interpreter_preference_page_context");
        this.checkDefaultInterpreter();
        this.fInterpretersBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LuaInterpreterPreferencePage.this.validateInterpreterList();
            }
        });
        this.applyDialogFont(ancestor);
        this.validateInterpreterList();
        return ancestor;
    }

    private void checkDefaultInterpreter() {
        IEnvironment[] environments;
        IEnvironment[] iEnvironmentArray = environments = EnvironmentManager.getEnvironments();
        int n = environments.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironment environment = iEnvironmentArray[n2];
            String currentNature = this.fInterpretersBlock.getCurrentNature();
            ScriptRuntime.DefaultInterpreterEntry defaultInterpreterEntry = new ScriptRuntime.DefaultInterpreterEntry(currentNature, environment.getId());
            IInterpreterInstall defaultInterpreter = ScriptRuntime.getDefaultInterpreterInstall((ScriptRuntime.DefaultInterpreterEntry)defaultInterpreterEntry);
            if (defaultInterpreter != null) {
                IInterpreterInstall[] iInterpreterInstallArray = this.fInterpretersBlock.getInterpreters();
                int n3 = iInterpreterInstallArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IInterpreterInstall interpreter = iInterpreterInstallArray[n4];
                    if (defaultInterpreter.equals(interpreter)) {
                        this.fInterpretersBlock.setCheckedInterpreter(interpreter);
                        return;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void validateInterpreterList() {
        this.setErrorMessage(null);
        if (this.fInterpretersBlock.getInterpreters().length > 0 && this.fInterpretersBlock.getSelection().isEmpty()) {
            this.setErrorMessage(InterpretersMessages.InterpreterPreferencePage_pleaseSetDefaultInterpreter);
        } else if (this.fInterpretersBlock.getInterpreters().length == 0) {
            this.setErrorMessage(InterpretersMessages.InterpreterPreferencePage_addInterpreter);
        }
    }

    public boolean performOk() {
        final boolean[] canceled = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                IInterpreterInstall[] defaultInterpreter = LuaInterpreterPreferencePage.this.fInterpretersBlock.getCheckedInterpreters();
                IInterpreterInstall[] interpreters = LuaInterpreterPreferencePage.this.fInterpretersBlock.getInterpreters();
                LuaInterpretersUpdater updater = new LuaInterpretersUpdater();
                if (!updater.updateInterpreterSettings(LuaInterpreterPreferencePage.this.fInterpretersBlock.getCurrentNature(), interpreters, defaultInterpreter)) {
                    canceled[0] = true;
                }
            }
        });
        if (canceled[0]) {
            return false;
        }
        this.fInterpretersBlock.saveColumnSettings(this.getDialogSettings(true), "org.eclipse.dltk.debug.ui.interpreter_preference_page_context");
        return true;
    }

    protected IDialogSettings getDialogSettings(boolean isSaving) {
        String nature;
        IDialogSettings settings = DLTKDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(nature = this.fInterpretersBlock.getCurrentNature());
        if (section == null) {
            section = isSaving ? settings.addNewSection(nature) : settings;
        }
        return section;
    }
}

