/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.utils.CorePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTListNode
extends ASTNode {
    private final List<ASTNode> nodes;

    public ASTListNode(int start, int end, List<ASTNode> nodes) {
        super(start, end);
        this.nodes = nodes;
    }

    public ASTListNode(int start, int end) {
        super(start, end);
        this.nodes = new ArrayList<ASTNode>();
    }

    public ASTListNode() {
        super(0, -1);
        this.nodes = new ArrayList<ASTNode>();
    }

    public void addNode(ASTNode s) {
        if (s != null) {
            this.nodes.add(s);
        }
    }

    @Override
    public List<ASTNode> getChilds() {
        return this.nodes;
    }

    public void setChilds(List<ASTNode> l) {
        this.nodes.clear();
        this.nodes.addAll(l);
    }

    public int getKind() {
        return 0;
    }

    @Override
    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit(this)) {
            if (this.nodes != null) {
                for (ASTNode s : this.nodes) {
                    s.traverse(visitor);
                }
            }
            visitor.endvisit(this);
        }
    }

    @Override
    public void printNode(CorePrinter output) {
        if (this.nodes != null) {
            output.print('[');
            for (ASTNode s : this.nodes) {
                s.printNode(output);
            }
            output.print(']');
        }
    }
}

