/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables.details;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class AbstractDetailPane
implements IDetailPane {
    private IWorkbenchPartSite fWorkbenchPartSite;
    private Map<String, IAction> fActionMap = new HashMap<String, IAction>();
    private List<String> fSelectionActions = new ArrayList<String>();

    @Override
    public void init(IWorkbenchPartSite workbench) {
        this.fWorkbenchPartSite = workbench;
    }

    @Override
    public void dispose() {
        this.fActionMap.clear();
        this.fSelectionActions.clear();
    }

    protected void setAction(String actionID, IAction action) {
        if (action == null) {
            this.fActionMap.remove(actionID);
        } else {
            this.fActionMap.put(actionID, action);
        }
    }

    protected void setGlobalAction(String actionID, IAction action) {
        this.getViewSite().getActionBars().setGlobalActionHandler(actionID, action);
    }

    protected void setSelectionDependantAction(String actionID) {
        if (actionID != null) {
            this.fSelectionActions.add(actionID);
        }
    }

    protected IAction getAction(String actionID) {
        return this.fActionMap.get(actionID);
    }

    protected void updateAction(String actionId) {
        IAction action = this.getAction(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void updateSelectionDependentActions() {
        for (String string : this.fSelectionActions) {
            this.updateAction(string);
        }
    }

    protected IViewSite getViewSite() {
        if (this.fWorkbenchPartSite == null) {
            return null;
        }
        return (IViewSite)this.fWorkbenchPartSite.getPart().getSite();
    }

    protected IWorkbenchPartSite getWorkbenchPartSite() {
        return this.fWorkbenchPartSite;
    }

    protected boolean isInView() {
        return this.fWorkbenchPartSite != null;
    }
}

