/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.framework;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.osgi.dto.DTO;
import org.osgi.dto.framework.BundleDTO;
import org.osgi.dto.framework.FrameworkDTO;
import org.osgi.dto.framework.ServiceReferenceDTO;
import org.osgi.dto.framework.startlevel.BundleStartLevelDTO;
import org.osgi.dto.framework.startlevel.FrameworkStartLevelDTO;
import org.osgi.dto.framework.wiring.BundleRevisionDTO;
import org.osgi.dto.framework.wiring.BundleRevisionsDTO;
import org.osgi.dto.framework.wiring.BundleWireDTO;
import org.osgi.dto.framework.wiring.BundleWiringDTO;
import org.osgi.dto.framework.wiring.BundleWiringsDTO;
import org.osgi.dto.resource.CapabilityDTO;
import org.osgi.dto.resource.RequirementDTO;
import org.osgi.dto.resource.WireDTO;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class DTOBuilder {
    private final Map<Object, Object> objects = new IdentityHashMap<Object, Object>();

    private DTOBuilder() {
    }

    public static BundleDTO newBundleDTO(Bundle bundle) {
        return new DTOBuilder().getBundleDTO(bundle);
    }

    private BundleDTO getBundleDTO(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        BundleDTO dto = (BundleDTO)this.objects.get(bundle);
        if (dto != null) {
            return dto;
        }
        dto = new BundleDTO();
        this.objects.put(bundle, dto);
        dto.id = bundle.getBundleId();
        dto.lastModified = bundle.getLastModified();
        dto.state = bundle.getState();
        dto.symbolicName = bundle.getSymbolicName();
        dto.version = bundle.getVersion().toString();
        return dto;
    }

    public static BundleStartLevelDTO newBundleStartLevelDTO(BundleStartLevel bsl) {
        if (bsl == null) {
            return null;
        }
        BundleStartLevelDTO dto = new BundleStartLevelDTO();
        dto.activationPolicyUsed = bsl.isActivationPolicyUsed();
        dto.persistentlyStarted = bsl.isPersistentlyStarted();
        dto.startLevel = bsl.getStartLevel();
        return dto;
    }

    public static BundleRevisionDTO newBundleRevisionDTO(BundleRevision revision) {
        return new DTOBuilder().getBundleRevisionDTO(revision);
    }

    private BundleRevisionDTO getBundleRevisionDTO(BundleRevision revision) {
        if (revision == null) {
            return null;
        }
        BundleRevisionDTO dto = (BundleRevisionDTO)this.objects.get(revision);
        if (dto != null) {
            return dto;
        }
        dto = new BundleRevisionDTO();
        this.objects.put(revision, dto);
        dto.bundle = this.getBundleDTO(revision.getBundle());
        dto.symbolicName = revision.getSymbolicName();
        dto.type = revision.getTypes();
        dto.version = revision.getVersion().toString();
        dto.capabilities = this.getListCapabilityDTO(revision.getDeclaredCapabilities(null));
        dto.requirements = this.getListRequirementDTO(revision.getDeclaredRequirements(null));
        return dto;
    }

    private List<CapabilityDTO> getListCapabilityDTO(List<BundleCapability> caps) {
        if (caps == null) {
            return null;
        }
        List<CapabilityDTO> dtos = (List<CapabilityDTO>)this.objects.get(caps);
        if (dtos != null) {
            return dtos;
        }
        dtos = DTOBuilder.newList(caps.size());
        this.objects.put(caps, dtos);
        for (BundleCapability cap : caps) {
            dtos.add(this.getCapabilityDTO(cap));
        }
        return dtos;
    }

    private CapabilityDTO getCapabilityDTO(BundleCapability cap) {
        if (cap == null) {
            return null;
        }
        CapabilityDTO dto = (CapabilityDTO)this.objects.get(cap);
        if (dto != null) {
            return dto;
        }
        dto = new CapabilityDTO();
        this.objects.put(cap, dto);
        dto.namespace = cap.getNamespace();
        dto.resource = this.getBundleRevisionDTO(cap.getResource());
        dto.attributes = DTOBuilder.newAttributesMapDTO(cap.getAttributes());
        dto.directives = DTOBuilder.newDirectivesMapDTO(cap.getDirectives());
        return dto;
    }

    private List<RequirementDTO> getListRequirementDTO(List<BundleRequirement> reqs) {
        if (reqs == null) {
            return null;
        }
        List<RequirementDTO> dtos = (List<RequirementDTO>)this.objects.get(reqs);
        if (dtos != null) {
            return dtos;
        }
        dtos = DTOBuilder.newList(reqs.size());
        this.objects.put(reqs, dtos);
        for (BundleRequirement req : reqs) {
            dtos.add(this.getRequirementDTO(req));
        }
        return dtos;
    }

    private RequirementDTO getRequirementDTO(BundleRequirement req) {
        if (req == null) {
            return null;
        }
        RequirementDTO dto = (RequirementDTO)this.objects.get(req);
        if (dto != null) {
            return dto;
        }
        dto = new RequirementDTO();
        this.objects.put(req, dto);
        dto.namespace = req.getNamespace();
        dto.resource = this.getBundleRevisionDTO(req.getResource());
        dto.attributes = DTOBuilder.newAttributesMapDTO(req.getAttributes());
        dto.directives = DTOBuilder.newDirectivesMapDTO(req.getDirectives());
        return dto;
    }

    public static BundleRevisionsDTO newBundleRevisionsDTO(BundleRevisions revisions) {
        return new DTOBuilder().getBundleRevisionsDTO(revisions);
    }

    private BundleRevisionsDTO getBundleRevisionsDTO(BundleRevisions revisions) {
        if (revisions == null) {
            return null;
        }
        BundleRevisionsDTO dto = new BundleRevisionsDTO();
        List<BundleRevision> revs = revisions.getRevisions();
        List<BundleRevisionDTO> dtos = DTOBuilder.newList(revs.size());
        for (BundleRevision rev : revs) {
            dtos.add(this.getBundleRevisionDTO(rev));
        }
        dto.revisions = dtos;
        return dto;
    }

    public static BundleWiringDTO newBundleWiringDTO(BundleRevision revision) {
        if (revision == null) {
            return null;
        }
        return new DTOBuilder().getBundleWiringDTO(revision.getWiring());
    }

    private BundleWiringDTO getBundleWiringDTO(BundleWiring wiring) {
        if (wiring == null) {
            return null;
        }
        BundleWiringDTO dto = (BundleWiringDTO)this.objects.get(wiring);
        if (dto != null) {
            return dto;
        }
        dto = new BundleWiringDTO();
        this.objects.put(wiring, dto);
        dto.current = wiring.isCurrent();
        dto.inUse = wiring.isInUse();
        dto.resource = this.getBundleRevisionDTO(wiring.getRevision());
        dto.capabilities = this.getListCapabilityDTO(wiring.getCapabilities(null));
        dto.requirements = this.getListRequirementDTO(wiring.getRequirements(null));
        dto.providedWires = this.getListBundleWireDTO(wiring.getProvidedWires(null));
        dto.requiredWires = this.getListBundleWireDTO(wiring.getRequiredWires(null));
        return dto;
    }

    private List<WireDTO> getListBundleWireDTO(List<BundleWire> wires) {
        if (wires == null) {
            return null;
        }
        List<WireDTO> dtos = (List<WireDTO>)this.objects.get(wires);
        if (dtos != null) {
            return dtos;
        }
        dtos = DTOBuilder.newList(wires.size());
        this.objects.put(wires, dtos);
        for (BundleWire wire : wires) {
            dtos.add(this.getBundleWireDTO(wire));
        }
        return dtos;
    }

    private BundleWireDTO getBundleWireDTO(BundleWire wire) {
        if (wire == null) {
            return null;
        }
        BundleWireDTO dto = (BundleWireDTO)this.objects.get(wire);
        if (dto != null) {
            return dto;
        }
        dto = new BundleWireDTO();
        this.objects.put(wire, dto);
        dto.capability = this.getCapabilityDTO(wire.getCapability());
        dto.requirement = this.getRequirementDTO(wire.getRequirement());
        dto.provider = this.getBundleRevisionDTO(wire.getProvider());
        dto.requirer = this.getBundleRevisionDTO(wire.getRequirer());
        dto.providerWiring = this.getBundleWiringDTO(wire.getProviderWiring());
        dto.requirerWiring = this.getBundleWiringDTO(wire.getRequirerWiring());
        return dto;
    }

    public static BundleWiringsDTO newBundleWiringsDTO(BundleRevisions revisions) {
        return new DTOBuilder().getBundleWiringsDTO(revisions);
    }

    private BundleWiringsDTO getBundleWiringsDTO(BundleRevisions revisions) {
        if (revisions == null) {
            return null;
        }
        BundleWiringsDTO dto = new BundleWiringsDTO();
        List<BundleRevision> revs = revisions.getRevisions();
        List<BundleWiringDTO> dtos = DTOBuilder.newList(revs.size());
        for (BundleRevision rev : revs) {
            BundleWiring wiring = rev.getWiring();
            if (wiring == null) continue;
            dtos.add(this.getBundleWiringDTO(wiring));
        }
        dto.wirings = dtos;
        return dto;
    }

    public static FrameworkDTO newFrameworkDTO(BundleContext systemBundleContext, Map<String, String> configuration) {
        return new DTOBuilder().getFrameworkDTO(systemBundleContext, configuration);
    }

    private FrameworkDTO getFrameworkDTO(BundleContext systemBundleContext, Map<String, String> configuration) {
        FrameworkDTO dto = new FrameworkDTO();
        dto.properties = DTOBuilder.asProperties(configuration);
        if (systemBundleContext == null) {
            dto.bundles = DTOBuilder.newList(0);
            dto.services = DTOBuilder.newList(0);
            return dto;
        }
        Bundle[] bundles = systemBundleContext.getBundles();
        int size = bundles == null ? 0 : bundles.length;
        List<BundleDTO> bundleDTOs = DTOBuilder.newList(size);
        int i = 0;
        while (i < size) {
            bundleDTOs.add(this.getBundleDTO(bundles[i]));
            ++i;
        }
        dto.bundles = bundleDTOs;
        try {
            ServiceReference<?>[] references = systemBundleContext.getAllServiceReferences(null, null);
            size = references == null ? 0 : references.length;
            List<ServiceReferenceDTO> refDTOs = DTOBuilder.newList(size);
            int i2 = 0;
            while (i2 < size) {
                ServiceReferenceDTO serviceRefDTO = this.getServiceReferenceDTO(references[i2]);
                if (serviceRefDTO != null) {
                    refDTOs.add(serviceRefDTO);
                }
                ++i2;
            }
            dto.services = refDTOs;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            dto.services = DTOBuilder.newList(0);
        }
        return dto;
    }

    private static Map<String, Object> asProperties(Map<String, ?> m) {
        return m;
    }

    private ServiceReferenceDTO getServiceReferenceDTO(ServiceReference<?> ref) {
        if (ref == null) {
            return null;
        }
        ServiceReferenceDTO dto = (ServiceReferenceDTO)this.objects.get(ref);
        if (dto != null) {
            return dto;
        }
        Bundle b = ref.getBundle();
        if (b == null) {
            return null;
        }
        dto = new ServiceReferenceDTO();
        this.objects.put(ref, dto);
        dto.bundle = b.getBundleId();
        String[] keys = ref.getPropertyKeys();
        Map<String, Object> properties = DTOBuilder.newMap(keys.length);
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            properties.put(k, DTOBuilder.mapValue(ref.getProperty(k)));
            ++n2;
        }
        dto.properties = properties;
        Bundle[] using = ref.getUsingBundles();
        int length = using == null ? 0 : using.length;
        long[] usingBundles = new long[length];
        int i = 0;
        while (i < length) {
            usingBundles[i] = using[i].getBundleId();
            ++i;
        }
        dto.usingBundles = usingBundles;
        return dto;
    }

    public static FrameworkStartLevelDTO newFrameworkStartLevelDTO(FrameworkStartLevel fsl) {
        if (fsl == null) {
            return null;
        }
        FrameworkStartLevelDTO dto = new FrameworkStartLevelDTO();
        dto.initialBundleStartLevel = fsl.getInitialBundleStartLevel();
        dto.startLevel = fsl.getStartLevel();
        return dto;
    }

    public static ServiceReferenceDTO[] newArrayServiceReferenceDTO(ServiceReference<?>[] references) {
        return new DTOBuilder().getArrayServiceReferenceDTO(references);
    }

    private ServiceReferenceDTO[] getArrayServiceReferenceDTO(ServiceReference<?>[] references) {
        int length = references == null ? 0 : references.length;
        ArrayList<ServiceReferenceDTO> refDTOs = new ArrayList<ServiceReferenceDTO>(length);
        int i = 0;
        while (i < length) {
            ServiceReferenceDTO dto = this.getServiceReferenceDTO(references[i]);
            if (dto != null) {
                refDTOs.add(dto);
            }
            ++i;
        }
        return refDTOs.toArray(new ServiceReferenceDTO[refDTOs.size()]);
    }

    private static Object mapValue(Object v) {
        if (v == null || v instanceof Number || v instanceof Boolean || v instanceof Character || v instanceof String || v instanceof DTO) {
            return v;
        }
        if (v instanceof Map) {
            Map m = (Map)v;
            Map<Object, Object> map = DTOBuilder.newMap(m.size());
            for (Map.Entry e : m.entrySet()) {
                map.put(DTOBuilder.mapValue(e.getKey()), DTOBuilder.mapValue(e.getValue()));
            }
            return map;
        }
        if (v instanceof List) {
            List c = (List)v;
            List<Object> list = DTOBuilder.newList(c.size());
            for (Object o : c) {
                list.add(DTOBuilder.mapValue(o));
            }
            return list;
        }
        if (v instanceof Set) {
            Set c = (Set)v;
            Set<Object> set = DTOBuilder.newSet(c.size());
            for (Object o : c) {
                set.add(DTOBuilder.mapValue(o));
            }
            return set;
        }
        if (v.getClass().isArray()) {
            int length = Array.getLength(v);
            Class<?> componentType = DTOBuilder.mapComponentType(v.getClass().getComponentType());
            Object array = Array.newInstance(componentType, length);
            int i = 0;
            while (i < length) {
                Array.set(array, i, DTOBuilder.mapValue(Array.get(v, i)));
                ++i;
            }
            return array;
        }
        return String.valueOf(v);
    }

    private static Class<?> mapComponentType(Class<?> componentType) {
        if (componentType.isPrimitive() || componentType.isArray() || Object.class.equals(componentType) || Number.class.isAssignableFrom(componentType) || Boolean.class.isAssignableFrom(componentType) || Character.class.isAssignableFrom(componentType) || String.class.isAssignableFrom(componentType) || DTO.class.isAssignableFrom(componentType)) {
            return componentType;
        }
        if (Map.class.isAssignableFrom(componentType)) {
            return Map.class;
        }
        if (List.class.isAssignableFrom(componentType)) {
            return List.class;
        }
        if (Set.class.isAssignableFrom(componentType)) {
            return Set.class;
        }
        return String.class;
    }

    private static <E> List<E> newList(int size) {
        return new ArrayList(size);
    }

    private static <E> Set<E> newSet(int size) {
        return new HashSet(size);
    }

    private static <K, V> Map<K, V> newMap(int size) {
        return new HashMap(size);
    }

    private static Map<String, String> newDirectivesMapDTO(Map<String, String> map) {
        HashMap<String, String> dto = new HashMap<String, String>(map);
        return dto;
    }

    private static Map<String, Object> newAttributesMapDTO(Map<String, Object> map) {
        HashMap<String, Object> dto = new HashMap<String, Object>(map);
        for (Map.Entry entry : dto.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Version) {
                entry.setValue(String.valueOf(value));
                continue;
            }
            if (!(value instanceof List)) continue;
            ArrayList newList = new ArrayList((List)value);
            ListIterator<String> iter = newList.listIterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof Version)) continue;
                iter.set(String.valueOf(element));
            }
            entry.setValue(newList);
        }
        return dto;
    }
}

