/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.compatibility.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.compatibility.state.FilterParser;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

class StateConverter {
    private final State state;

    StateConverter(State state) {
        this.state = state;
    }

    BundleDescription createDescription(BundleRevision resource) {
        GenericDescription[] genericDescs;
        List idList = resource.getCapabilities("osgi.identity");
        if (idList.size() != 1) {
            throw new IllegalArgumentException("Bogus osgi.identity: " + idList);
        }
        Capability id = (Capability)idList.iterator().next();
        HashMap idAttrs = new HashMap(id.getAttributes());
        String symbolicName = (String)idAttrs.remove("osgi.identity");
        Version version = (Version)idAttrs.remove("version");
        String symbolicNameSpecification = String.valueOf(symbolicName) + StateConverter.toString(idAttrs, "=", true) + StateConverter.toString(id.getDirectives(), ":=", true);
        ArrayList<ExportPackageDescription> exportPackages = new ArrayList<ExportPackageDescription>();
        ArrayList<GenericDescription> provideCapabilities = new ArrayList<GenericDescription>();
        ArrayList<ImportPackageSpecification> importPackages = new ArrayList<ImportPackageSpecification>();
        ArrayList<GenericSpecification> requireCapabilities = new ArrayList<GenericSpecification>();
        ArrayList<HostSpecification> fragmentHost = new ArrayList<HostSpecification>(0);
        ArrayList<BundleSpecification> requireBundles = new ArrayList<BundleSpecification>();
        List capabilities = resource.getCapabilities(null);
        Capability osgiIdentity = null;
        for (Capability capability : capabilities) {
            String namespace = capability.getNamespace();
            if ("osgi.identity".equals(namespace)) {
                osgiIdentity = capability;
                continue;
            }
            if ("osgi.wiring.host".equals(namespace) || "osgi.wiring.bundle".equals(namespace)) continue;
            if ("osgi.wiring.package".equals(namespace)) {
                exportPackages.addAll(this.creatExportPackage(capability));
                continue;
            }
            provideCapabilities.addAll(this.createProvideCapability(capability));
        }
        List requirements = resource.getRequirements(null);
        for (Requirement requirement : requirements) {
            String namespace = requirement.getNamespace();
            if ("osgi.wiring.bundle".equals(namespace)) {
                requireBundles.addAll(this.createRequireBundle(requirement));
                continue;
            }
            if ("osgi.wiring.host".equals(namespace)) {
                fragmentHost.addAll(this.createFragmentHost(requirement));
                continue;
            }
            if ("osgi.wiring.package".equals(namespace)) {
                importPackages.addAll(this.createImportPackage(requirement));
                continue;
            }
            requireCapabilities.addAll(this.createRequireCapability(requirement));
        }
        BundleDescription result = this.state.getFactory().createBundleDescription(resource.getBundle().getBundleId(), symbolicNameSpecification, version, resource.getBundle().getLocation(), requireBundles.toArray(new BundleSpecification[requireBundles.size()]), fragmentHost.size() == 0 ? null : (HostSpecification)fragmentHost.get(0), importPackages.toArray(new ImportPackageSpecification[importPackages.size()]), exportPackages.toArray(new ExportPackageDescription[exportPackages.size()]), null, null, requireCapabilities.toArray(new GenericSpecification[requireCapabilities.size()]), provideCapabilities.toArray(new GenericDescription[provideCapabilities.size()]), null);
        result.setUserObject((Object)resource);
        GenericDescription[] genericDescriptionArray = genericDescs = result.getGenericCapabilities();
        int n = genericDescs.length;
        int n2 = 0;
        while (n2 < n) {
            GenericDescription genericDesc = genericDescriptionArray[n2];
            if ("osgi.identity".equals(genericDesc.getType())) {
                genericDesc.setUserObject((Object)osgiIdentity);
            }
            ++n2;
        }
        return result;
    }

    private List<ExportPackageDescription> creatExportPackage(Capability capability) {
        HashMap attributes = new HashMap(capability.getAttributes());
        Map directives = capability.getDirectives();
        String packageName = (String)attributes.remove("osgi.wiring.package");
        attributes.remove("bundle-symbolic-name");
        attributes.remove("bundle-version");
        String declaration = String.valueOf(packageName) + StateConverter.toString(attributes, "=", true) + StateConverter.toString(directives, ":=", true);
        List result = this.state.getFactory().createExportPackageDescriptions(declaration);
        for (ExportPackageDescription export : result) {
            export.setUserObject((Object)capability);
        }
        return result;
    }

    private List<GenericDescription> createProvideCapability(Capability capability) {
        Map attributes = capability.getAttributes();
        Map directives = capability.getDirectives();
        String declaration = String.valueOf(capability.getNamespace()) + StateConverter.toString(attributes, "=", false) + StateConverter.toString(directives, ":=", true);
        List result = this.state.getFactory().createGenericDescriptions(declaration);
        for (GenericDescription genericDescription : result) {
            genericDescription.setUserObject((Object)capability);
        }
        return result;
    }

    private List<BundleSpecification> createRequireBundle(Requirement requirement) {
        String declaration = this.createOSGiRequirement(requirement, "osgi.wiring.bundle", "bundle-version");
        List result = this.state.getFactory().createBundleSpecifications(declaration);
        for (BundleSpecification bundleSpecification : result) {
            bundleSpecification.setUserObject((Object)requirement);
        }
        return result;
    }

    private List<HostSpecification> createFragmentHost(Requirement requirement) {
        String declaration = this.createOSGiRequirement(requirement, "osgi.wiring.host", "bundle-version");
        List result = this.state.getFactory().createHostSpecifications(declaration);
        for (HostSpecification hostSpecification : result) {
            hostSpecification.setUserObject((Object)requirement);
        }
        return result;
    }

    private List<ImportPackageSpecification> createImportPackage(Requirement requirement) {
        String declaration = this.createOSGiRequirement(requirement, "osgi.wiring.package", "version", "bundle-version");
        List result = this.state.getFactory().createImportPackageSpecifications(declaration);
        for (ImportPackageSpecification importPackageSpecification : result) {
            importPackageSpecification.setUserObject((Object)requirement);
        }
        return result;
    }

    private List<GenericSpecification> createRequireCapability(Requirement requirement) {
        String declaration = String.valueOf(requirement.getNamespace()) + StateConverter.toString(requirement.getAttributes(), "=", false) + StateConverter.toString(requirement.getDirectives(), ":=", true);
        List result = this.state.getFactory().createGenericSpecifications(declaration);
        for (GenericSpecification genericSpecification : result) {
            genericSpecification.setUserObject((Object)requirement);
        }
        return result;
    }

    private String createOSGiRequirement(Requirement requirement, String namespace, String ... versions) {
        HashMap directives = new HashMap(requirement.getDirectives());
        String filter = (String)directives.remove("filter");
        if (filter == null) {
            throw new IllegalArgumentException("No filter directive found:" + requirement);
        }
        FilterParser parser = new FilterParser(filter);
        FilterParser.FilterComponent component = null;
        try {
            component = parser.parse();
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter directive", e);
        }
        Map<String, String> matchingAttributes = component.getStandardOSGiAttributes(versions);
        String name = matchingAttributes.remove(namespace);
        if (name == null) {
            throw new IllegalArgumentException("Invalid requirement: " + requirement);
        }
        return String.valueOf(name) + StateConverter.toString(matchingAttributes, "=", true) + StateConverter.toString(directives, ":=", true);
    }

    static <V> String toString(Map<String, V> map, String assignment, boolean stringsOnly) {
        if (map.isEmpty()) {
            return "";
        }
        Set<Map.Entry<String, V>> set = map.entrySet();
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, V> entry : set) {
            sb.append("; ");
            String key = entry.getKey();
            V value = entry.getValue();
            if (value instanceof List) {
                List list = (List)value;
                if (list.size() == 0) continue;
                Object component = list.get(0);
                String className = component.getClass().getName();
                String type = className.substring(className.lastIndexOf(46) + 1);
                sb.append(key).append(':').append("List<").append(type).append(">").append(assignment).append('\"');
                for (Object object : list) {
                    sb.append(object).append(',');
                }
                sb.setLength(sb.length() - 1);
                sb.append('\"');
                continue;
            }
            String type = "";
            if (!(value instanceof String) && !stringsOnly) {
                String className = value.getClass().getName();
                type = ":" + className.substring(className.lastIndexOf(46) + 1);
            }
            sb.append(key).append(type).append(assignment).append('\"').append(value).append('\"');
        }
        return sb.toString();
    }
}

