/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.fieldassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

@Deprecated
public class FieldAssistColors {
    private static boolean DEBUG = false;
    private static Map<Color, Color> requiredFieldColorMap = new HashMap<Color, Color>();
    private static Map<Color, Display> displays = new HashMap<Color, Display>();

    public static RGB computeErrorFieldBackgroundRGB(Control control) {
        Color dest = control.getBackground();
        Color src = JFaceColors.getErrorText(control.getDisplay());
        int destRed = dest.getRed();
        int destGreen = dest.getGreen();
        int destBlue = dest.getBlue();
        int alpha = 25;
        destRed += (src.getRed() - destRed) * alpha / 255;
        destGreen += (src.getGreen() - destGreen) * alpha / 255;
        destBlue += (src.getBlue() - destBlue) * alpha / 255;
        return new RGB(destRed, destGreen, destBlue);
    }

    public static Color getRequiredFieldBackgroundColor(Control control) {
        final Display display = control.getDisplay();
        if (display.getHighContrast()) {
            return control.getBackground();
        }
        Color storedColor = requiredFieldColorMap.get(control.getBackground());
        if (storedColor != null) {
            return storedColor;
        }
        Color dest = control.getBackground();
        Color src = display.getSystemColor(7);
        int destRed = dest.getRed();
        int destGreen = dest.getGreen();
        int destBlue = dest.getBlue();
        int alpha = 38;
        destRed += (src.getRed() - destRed) * alpha / 255;
        destGreen += (src.getGreen() - destGreen) * alpha / 255;
        destBlue += (src.getBlue() - destBlue) * alpha / 255;
        Color color = new Color((Device)display, destRed, destGreen, destBlue);
        requiredFieldColorMap.put(dest, color);
        if (!displays.containsValue(display)) {
            display.disposeExec(new Runnable(){

                public void run() {
                    FieldAssistColors.disposeColors(display);
                }
            });
        }
        displays.put(color, display);
        return color;
    }

    private static void disposeColors(Display display) {
        ArrayList<Color> toBeRemoved = new ArrayList<Color>(1);
        if (DEBUG) {
            System.out.println("Display map is " + displays.toString());
            System.out.println("Color map is " + requiredFieldColorMap.toString());
        }
        for (Color color : displays.keySet()) {
            if (!displays.get(color).equals(display)) continue;
            toBeRemoved.add(color);
            ArrayList<Color> toBeRemovedFromRequiredMap = new ArrayList<Color>(1);
            for (Color bgColor : requiredFieldColorMap.keySet()) {
                if (!requiredFieldColorMap.get(bgColor).equals((Object)color)) continue;
                toBeRemovedFromRequiredMap.add(bgColor);
            }
            int j = 0;
            while (j < toBeRemovedFromRequiredMap.size()) {
                requiredFieldColorMap.remove(toBeRemovedFromRequiredMap.get(j));
                ++j;
            }
        }
        int i = 0;
        while (i < toBeRemoved.size()) {
            Color color;
            color = (Color)toBeRemoved.get(i);
            displays.remove(color);
            if (DEBUG) {
                System.out.println("Disposing color " + color.toString());
            }
            color.dispose();
            ++i;
        }
        if (DEBUG) {
            System.out.println("Display map is " + displays.toString());
            System.out.println("Color map is " + requiredFieldColorMap.toString());
        }
    }
}

