/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    long boxHandle;
    long labelHandle;
    long imageHandle;
    long arrowHandle;
    long groupHandle;
    boolean selected;
    boolean grayed;
    ImageList imageList;
    Image image;
    String text;
    static final int INNER_BORDER = 1;
    static final int DEFAULT_BORDER = 1;

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    static int checkStyle(int style) {
        if (((style = Button.checkBits(style, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x30) != 0) {
            return Button.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Button.checkBits(style |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    static GtkBorder getBorder(byte[] border, long handle, int defaultBorder) {
        GtkBorder gtkBorder = new GtkBorder();
        long[] borderPtr = new long[1];
        OS.gtk_widget_style_get(handle, border, borderPtr, 0L);
        if (borderPtr[0] != 0L) {
            OS.memmove(gtkBorder, borderPtr[0], (long)GtkBorder.sizeof);
            OS.gtk_border_free(borderPtr[0]);
            return gtkBorder;
        }
        gtkBorder.left = defaultBorder;
        gtkBorder.top = defaultBorder;
        gtkBorder.right = defaultBorder;
        gtkBorder.bottom = defaultBorder;
        return gtkBorder;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        boolean wrap;
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        this.forceResize();
        int[] reqWidth = null;
        int[] reqHeight = null;
        if ((this.style & 0x30) != 0) {
            reqWidth = new int[1];
            reqHeight = new int[1];
            OS.gtk_widget_get_size_request(this.boxHandle, reqWidth, reqHeight);
            OS.gtk_widget_set_size_request(this.boxHandle, -1, -1);
        }
        boolean bl = wrap = this.labelHandle != 0L && (this.style & 0x40) != 0 && this.gtk_widget_get_visible(this.labelHandle);
        if (wrap) {
            int trimWidth;
            int borderWidth = OS.gtk_container_get_border_width(this.handle);
            int[] focusWidth = new int[1];
            OS.gtk_widget_style_get(this.handle, OS.focus_line_width, focusWidth, 0L);
            int[] focusPadding = new int[1];
            OS.gtk_widget_style_get(this.handle, OS.focus_padding, focusPadding, 0L);
            int trimHeight = trimWidth = 2 * (borderWidth + focusWidth[0] + focusPadding[0]);
            int indicatorHeight = 0;
            if ((this.style & 0x30) != 0) {
                int[] indicatorSize = new int[1];
                OS.gtk_widget_style_get(this.handle, OS.indicator_size, indicatorSize, 0L);
                int[] indicatorSpacing = new int[1];
                OS.gtk_widget_style_get(this.handle, OS.indicator_spacing, indicatorSpacing, 0L);
                indicatorHeight = indicatorSize[0] + 2 * indicatorSpacing[0];
                trimWidth += indicatorHeight + indicatorSpacing[0];
            } else {
                Point thickness = this.getThickness(this.handle);
                trimWidth += thickness.x * 2;
                trimHeight += thickness.y * 2;
                GtkBorder innerBorder = Button.getBorder(OS.inner_border, this.handle, 1);
                trimWidth += innerBorder.left + innerBorder.right;
                trimHeight += innerBorder.top + innerBorder.bottom;
                if (this.gtk_widget_get_can_default(this.handle)) {
                    GtkBorder defaultBorder = Button.getBorder(OS.default_border, this.handle, 1);
                    trimWidth += defaultBorder.left + defaultBorder.right;
                    trimHeight += defaultBorder.top + defaultBorder.bottom;
                }
            }
            int imageWidth = 0;
            int imageHeight = 0;
            if (this.gtk_widget_get_visible(this.imageHandle)) {
                GtkRequisition requisition = new GtkRequisition();
                this.gtk_widget_get_preferred_size(this.imageHandle, requisition);
                imageWidth = requisition.width;
                imageHeight = requisition.height;
                int[] spacing = new int[1];
                OS.g_object_get(this.boxHandle, OS.spacing, spacing, 0L);
                imageWidth += spacing[0];
            }
            long labelLayout = OS.gtk_label_get_layout(this.labelHandle);
            int pangoWidth = OS.pango_layout_get_width(labelLayout);
            if (wHint != -1) {
                OS.pango_layout_set_width(labelLayout, Math.max(1, wHint - imageWidth - trimWidth) * 1024);
            } else {
                OS.pango_layout_set_width(labelLayout, -1);
            }
            int[] w = new int[1];
            int[] h = new int[1];
            OS.pango_layout_get_pixel_size(labelLayout, w, h);
            OS.pango_layout_set_width(labelLayout, pangoWidth);
            size = new Point(0, 0);
            size.x = size.x + (wHint == -1 ? w[0] + imageWidth + trimWidth : wHint);
            size.y = size.y + (hHint == -1 ? Math.max(Math.max(imageHeight, indicatorHeight), h[0]) + trimHeight : hHint);
        } else {
            size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        }
        if ((this.style & 0x30) != 0) {
            OS.gtk_widget_set_size_request(this.boxHandle, reqWidth[0], reqHeight[0]);
        }
        if ((wHint != -1 || hHint != -1) && this.gtk_widget_get_can_default(this.handle)) {
            GtkBorder border = Button.getBorder(OS.default_border, this.handle, 1);
            if (wHint != -1) {
                size.x += border.left + border.right;
            }
            if (hHint != -1) {
                size.y += border.top + border.bottom;
            }
        }
        return size;
    }

    void createHandle(int index) {
        this.state |= 8;
        if ((this.style & 0xA) == 0) {
            this.state |= 0x10000;
        }
        int bits = 62;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        this.gtk_widget_set_has_window(this.fixedHandle, true);
        switch (this.style & bits) {
            case 4: {
                int arrow_type = 0;
                if ((this.style & 0x80) != 0) {
                    arrow_type = 0;
                }
                if ((this.style & 0x400) != 0) {
                    arrow_type = 1;
                }
                if ((this.style & 0x4000) != 0) {
                    arrow_type = 2;
                }
                if ((this.style & 0x20000) != 0) {
                    arrow_type = 3;
                }
                this.handle = OS.gtk_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                this.arrowHandle = OS.gtk_arrow_new(arrow_type, 2);
                if (this.arrowHandle != 0L) break;
                this.error(2);
                break;
            }
            case 2: {
                this.handle = OS.gtk_toggle_button_new();
                if (this.handle != 0L) break;
                this.error(2);
                break;
            }
            case 32: {
                this.handle = OS.gtk_check_button_new();
                if (this.handle != 0L) break;
                this.error(2);
                break;
            }
            case 16: {
                this.groupHandle = OS.gtk_radio_button_new(0L);
                if (this.groupHandle == 0L) {
                    this.error(2);
                }
                OS.g_object_ref(this.groupHandle);
                OS.g_object_ref_sink(this.groupHandle);
                this.handle = OS.gtk_radio_button_new(OS.gtk_radio_button_get_group(this.groupHandle));
                if (this.handle != 0L) break;
                this.error(2);
                break;
            }
            default: {
                this.handle = OS.gtk_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                this.gtk_widget_set_can_default(this.handle, true);
            }
        }
        if ((this.style & 4) != 0) {
            OS.gtk_container_add(this.handle, this.arrowHandle);
        } else {
            this.boxHandle = this.gtk_box_new(0, false, 4);
            if (this.boxHandle == 0L) {
                this.error(2);
            }
            this.labelHandle = OS.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0L) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            if (this.imageHandle == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(this.handle, this.boxHandle);
            OS.gtk_container_add(this.boxHandle, this.imageHandle);
            OS.gtk_container_add(this.boxHandle, this.labelHandle);
            if ((this.style & 0x40) != 0) {
                OS.gtk_label_set_line_wrap(this.labelHandle, true);
                OS.gtk_label_set_line_wrap_mode(this.labelHandle, 2);
            }
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        if ((this.style & 4) != 0) {
            return;
        }
        this._setAlignment(this.style & 0x1024000);
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.text = "";
    }

    void deregister() {
        super.deregister();
        if (this.boxHandle != 0L) {
            this.display.removeWidget(this.boxHandle);
        }
        if (this.labelHandle != 0L) {
            this.display.removeWidget(this.labelHandle);
        }
        if (this.imageHandle != 0L) {
            this.display.removeWidget(this.imageHandle);
        }
        if (this.arrowHandle != 0L) {
            this.display.removeWidget(this.arrowHandle);
        }
    }

    long fontHandle() {
        if (this.labelHandle != 0L) {
            return this.labelHandle;
        }
        return super.fontHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return OS.gtk_toggle_button_get_active(this.handle);
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    long gtk_button_press_event(long widget, long event) {
        long result = super.gtk_button_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return result;
    }

    long gtk_clicked(long widget) {
        if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.selected);
            } else {
                this.selectRadio();
            }
        } else if ((this.style & 0x20) != 0 && this.grayed) {
            if (OS.gtk_toggle_button_get_active(this.handle)) {
                OS.gtk_toggle_button_set_inconsistent(this.handle, true);
            } else {
                OS.gtk_toggle_button_set_inconsistent(this.handle, false);
            }
        }
        this.sendSelectionEvent(13);
        return 0L;
    }

    long gtk_focus_in_event(long widget, long event) {
        long result = super.gtk_focus_in_event(widget, event);
        if (this.handle == 0L) {
            return 0L;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            if ((this.style & 8) != 0 && OS.gtk_widget_has_default(this.handle)) {
                Decorations menuShell = this.menuShell();
                menuShell.defaultButton = this;
            }
        } else if ((this.style & 8) != 0 && OS.GTK_WIDGET_HAS_DEFAULT(this.handle)) {
            Decorations menuShell = this.menuShell();
            menuShell.defaultButton = this;
        }
        return result;
    }

    long gtk_focus_out_event(long widget, long event) {
        long result = super.gtk_focus_out_event(widget, event);
        if (this.handle == 0L) {
            return 0L;
        }
        if ((this.style & 8) != 0) {
            Decorations menuShell = this.menuShell();
            if (menuShell.defaultButton == this) {
                menuShell.defaultButton = null;
            }
        }
        return result;
    }

    long gtk_key_press_event(long widget, long event) {
        long result = super.gtk_key_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return result;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    boolean isDescribedByLabel() {
        return false;
    }

    boolean mnemonicHit(char key) {
        if (this.labelHandle == 0L) {
            return false;
        }
        boolean result = super.mnemonicHit(this.labelHandle, key);
        if (result) {
            this.setFocus();
        }
        return result;
    }

    boolean mnemonicMatch(char key) {
        if (this.labelHandle == 0L) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, key);
    }

    void register() {
        super.register();
        if (this.boxHandle != 0L) {
            this.display.addWidget(this.boxHandle, this);
        }
        if (this.labelHandle != 0L) {
            this.display.addWidget(this.labelHandle, this);
        }
        if (this.imageHandle != 0L) {
            this.display.addWidget(this.imageHandle, this);
        }
        if (this.arrowHandle != 0L) {
            this.display.addWidget(this.arrowHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.arrowHandle = 0L;
        this.labelHandle = 0L;
        this.imageHandle = 0L;
        this.boxHandle = 0L;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.groupHandle != 0L) {
            OS.g_object_unref(this.groupHandle);
        }
        this.groupHandle = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.image = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void resizeHandle(int width, int height) {
        super.resizeHandle(width, height);
        if (!OS.GTK3 && (this.style & 0x30) != 0) {
            OS.gtk_widget_set_size_request(this.boxHandle, width, -1);
        }
    }

    void selectRadio() {
        Control[] children = this.parent._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (this != child) {
                child.setRadioSelection(false);
            }
            ++i;
        }
        this.setSelection(true);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        this._setAlignment(alignment);
    }

    void _setAlignment(int alignment) {
        boolean bothVisible;
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= alignment & 0x24480;
            int arrow_type = 0;
            boolean isRTL = (this.style & 0x4000000) != 0;
            switch (alignment) {
                case 128: {
                    arrow_type = 0;
                    break;
                }
                case 1024: {
                    arrow_type = 1;
                    break;
                }
                case 16384: {
                    arrow_type = isRTL ? 3 : 2;
                    break;
                }
                case 131072: {
                    arrow_type = isRTL ? 2 : 3;
                }
            }
            OS.gtk_arrow_set(this.arrowHandle, arrow_type, 2);
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        boolean bl = bothVisible = this.gtk_widget_get_visible(this.labelHandle) && this.gtk_widget_get_visible(this.imageHandle);
        if (bothVisible) {
            if ((this.style & 0x30) != 0) {
                alignment = 16384;
            }
            if ((this.style & 0xA) != 0) {
                alignment = 0x1000000;
            }
        }
        if ((alignment & 0x4000) != 0) {
            if (bothVisible) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 0, 0);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 0);
            } else if (OS.GTK3) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
            }
            OS.gtk_misc_set_alignment(this.labelHandle, 0.0f, 0.5f);
            OS.gtk_label_set_justify(this.labelHandle, 0);
            OS.gtk_misc_set_alignment(this.imageHandle, 0.0f, 0.5f);
            return;
        }
        if ((alignment & 0x1000000) != 0) {
            if (bothVisible) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
                OS.gtk_misc_set_alignment(this.labelHandle, 0.0f, 0.5f);
                OS.gtk_misc_set_alignment(this.imageHandle, 1.0f, 0.5f);
            } else {
                if (OS.GTK3) {
                    OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                    OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
                }
                OS.gtk_misc_set_alignment(this.labelHandle, 0.5f, 0.5f);
                OS.gtk_label_set_justify(this.labelHandle, 2);
                OS.gtk_misc_set_alignment(this.imageHandle, 0.5f, 0.5f);
            }
            return;
        }
        if ((alignment & 0x20000) != 0) {
            if (bothVisible) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 0, 1);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 1);
            } else if (OS.GTK3) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
            }
            OS.gtk_misc_set_alignment(this.labelHandle, 1.0f, 0.5f);
            OS.gtk_label_set_justify(this.labelHandle, 1);
            OS.gtk_misc_set_alignment(this.imageHandle, 1.0f, 0.5f);
            return;
        }
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        this.setBackgroundColor(this.fixedHandle, color);
        if (this.labelHandle != 0L) {
            this.setBackgroundColor(this.labelHandle, color);
        }
        if (this.imageHandle != 0L) {
            this.setBackgroundColor(this.imageHandle, color);
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean wrap;
        boolean bl = wrap = this.labelHandle != 0L && (this.style & 0x40) != 0 && this.gtk_widget_get_visible(this.labelHandle);
        if (wrap) {
            OS.gtk_widget_set_size_request(this.boxHandle, -1, -1);
        }
        int result = super.setBounds(x, y, width, height, move, resize);
        if (wrap) {
            GtkRequisition requisition;
            GtkAllocation allocation = new GtkAllocation();
            this.gtk_widget_get_allocation(this.boxHandle, allocation);
            int boxWidth = allocation.width;
            int boxHeight = allocation.height;
            long labelLayout = OS.gtk_label_get_layout(this.labelHandle);
            int pangoWidth = OS.pango_layout_get_width(labelLayout);
            OS.pango_layout_set_width(labelLayout, -1);
            int[] w = new int[1];
            int[] h = new int[1];
            OS.pango_layout_get_pixel_size(labelLayout, w, h);
            OS.pango_layout_set_width(labelLayout, pangoWidth);
            int imageWidth = 0;
            if (this.gtk_widget_get_visible(this.imageHandle)) {
                requisition = new GtkRequisition();
                this.gtk_widget_get_preferred_size(this.imageHandle, requisition);
                imageWidth = requisition.width;
                int[] spacing = new int[1];
                OS.g_object_get(this.boxHandle, OS.spacing, spacing, 0L);
                imageWidth += spacing[0];
            }
            OS.gtk_widget_set_size_request(this.labelHandle, Math.min(w[0], boxWidth - imageWidth), -1);
            requisition = new GtkRequisition();
            this.gtk_widget_get_preferred_size(this.boxHandle, requisition);
            allocation.width = boxWidth;
            allocation.height = boxHeight;
            OS.gtk_widget_size_allocate(this.boxHandle, allocation);
        }
        return result;
    }

    void setFontDescription(long font) {
        super.setFontDescription(font);
        if (this.labelHandle != 0L) {
            this.setFontDescription(this.labelHandle, font);
        }
        if (this.imageHandle != 0L) {
            this.setFontDescription(this.imageHandle, font);
        }
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        this.setForegroundColor(this.fixedHandle, color);
        if (this.labelHandle != 0L) {
            this.setForegroundColor(this.labelHandle, color);
        }
        if (this.imageHandle != 0L) {
            this.setForegroundColor(this.imageHandle, color);
        }
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        this.grayed = grayed;
        if (grayed && OS.gtk_toggle_button_get_active(this.handle)) {
            OS.gtk_toggle_button_set_inconsistent(this.handle, true);
        } else {
            OS.gtk_toggle_button_set_inconsistent(this.handle, false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            this.imageList = new ImageList();
            int imageIndex = this.imageList.add(image);
            long pixbuf = this.imageList.getPixbuf(imageIndex);
            this.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
            if (this.text.length() == 0) {
                OS.gtk_widget_hide(this.labelHandle);
            }
            OS.gtk_widget_show(this.imageHandle);
        } else {
            this.gtk_image_set_from_pixbuf(this.imageHandle, 0L);
            OS.gtk_widget_show(this.labelHandle);
            OS.gtk_widget_hide(this.imageHandle);
        }
        this.image = image;
        this._setAlignment(this.style);
    }

    void setOrientation(boolean create) {
        super.setOrientation(create);
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.boxHandle != 0L) {
                OS.gtk_widget_set_direction(this.boxHandle, dir);
            }
            if (this.labelHandle != 0L) {
                OS.gtk_widget_set_direction(this.labelHandle, dir);
            }
            if (this.imageHandle != 0L) {
                OS.gtk_widget_set_direction(this.imageHandle, dir);
            }
            if (this.arrowHandle != 0L) {
                dir = (this.style & 0x4000000) != 0 ? 3 : 2;
                switch (this.style & 0x24000) {
                    case 16384: {
                        OS.gtk_arrow_set(this.arrowHandle, dir, 2);
                        break;
                    }
                    case 131072: {
                        OS.gtk_arrow_set(this.arrowHandle, dir, 2);
                    }
                }
            }
        }
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
        OS.gtk_toggle_button_set_active(this.handle, selected);
        if ((this.style & 0x20) != 0) {
            if (selected && this.grayed) {
                OS.gtk_toggle_button_set_inconsistent(this.handle, true);
            } else {
                OS.gtk_toggle_button_set_inconsistent(this.handle, false);
            }
        }
        if ((this.style & 0x10) != 0) {
            OS.gtk_toggle_button_set_active(this.groupHandle, !selected);
        }
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        if (this.image == null) {
            OS.gtk_widget_hide(this.imageHandle);
        }
        OS.gtk_widget_show(this.labelHandle);
        this._setAlignment(this.style);
    }

    void showWidget() {
        super.showWidget();
        if (this.boxHandle != 0L) {
            OS.gtk_widget_show(this.boxHandle);
        }
        if (this.labelHandle != 0L) {
            OS.gtk_widget_show(this.labelHandle);
        }
        if (this.arrowHandle != 0L) {
            OS.gtk_widget_show(this.arrowHandle);
        }
    }

    int traversalCode(int key, GdkEventKey event) {
        int code = super.traversalCode(key, event);
        if ((this.style & 4) != 0) {
            code &= 0xFFFFFFE7;
        }
        if ((this.style & 0x10) != 0) {
            code |= 0x60;
        }
        return code;
    }
}

