/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.quickaccess.ActionProvider;
import org.eclipse.ui.internal.quickaccess.CommandProvider;
import org.eclipse.ui.internal.quickaccess.EditorProvider;
import org.eclipse.ui.internal.quickaccess.PerspectiveProvider;
import org.eclipse.ui.internal.quickaccess.PreferenceProvider;
import org.eclipse.ui.internal.quickaccess.PreviousPicksProvider;
import org.eclipse.ui.internal.quickaccess.PropertiesProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessContents;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.ViewProvider;
import org.eclipse.ui.internal.quickaccess.WizardProvider;
import org.eclipse.ui.swt.IFocusService;

public class SearchField {
    private static final String TEXT_ARRAY = "textArray";
    private static final String TEXT_ENTRIES = "textEntries";
    private static final String ORDERED_PROVIDERS = "orderedProviders";
    private static final String ORDERED_ELEMENTS = "orderedElements";
    private static final int MAXIMUM_NUMBER_OF_ELEMENTS = 60;
    private static final int MAXIMUM_NUMBER_OF_TEXT_ENTRIES_PER_ELEMENT = 3;
    private static final String DIALOG_HEIGHT = "dialogHeight";
    private static final String DIALOG_WIDTH = "dialogWidth";
    Shell shell;
    private Text text;
    private QuickAccessContents quickAccessContents;
    private MWindow window;
    private Map<String, QuickAccessProvider> providerMap = new HashMap<String, QuickAccessProvider>();
    private Map<String, QuickAccessElement> elementMap = new HashMap<String, QuickAccessElement>();
    private Map<QuickAccessElement, ArrayList<String>> textMap = new HashMap<QuickAccessElement, ArrayList<String>>();
    private LinkedList<QuickAccessElement> previousPicksList = new LinkedList();
    private int dialogHeight = -1;
    private int dialogWidth = -1;
    private Control previousFocusControl;
    @Inject
    private EPartService partService;
    private Table table;
    private String selectedString = "";
    private AccessibleAdapter accessibleListener;

    @PostConstruct
    void createWidget(Composite parent, MApplication application, MWindow window) {
        this.window = window;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.text = this.createText(comp);
        parent.getShell().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                this.closeDropDown();
            }

            public void controlMoved(ControlEvent e) {
                this.closeDropDown();
            }

            private void closeDropDown() {
                if (SearchField.this.shell == null || SearchField.this.shell.isDisposed() || SearchField.this.text.isDisposed() || !SearchField.this.shell.isVisible()) {
                    return;
                }
                SearchField.this.quickAccessContents.doClose();
            }
        });
        this.hookUpSelectAll();
        final CommandProvider commandProvider = new CommandProvider();
        QuickAccessProvider[] providers = new QuickAccessProvider[]{new PreviousPicksProvider(this.previousPicksList), new EditorProvider(), new ViewProvider(application, window), new PerspectiveProvider(), commandProvider, new ActionProvider(), new WizardProvider(), new PreferenceProvider(), new PropertiesProvider()};
        int i = 0;
        while (i < providers.length) {
            this.providerMap.put(providers[i].getId(), providers[i]);
            ++i;
        }
        this.restoreDialog();
        this.quickAccessContents = new QuickAccessContents(providers){

            protected void updateFeedback(boolean filterTextEmpty, boolean showAllMatches) {
            }

            protected void doClose() {
                SearchField.this.text.setText("");
                this.resetProviders();
                SearchField.this.dialogHeight = SearchField.this.shell.getSize().y;
                SearchField.this.dialogWidth = SearchField.this.shell.getSize().x;
                SearchField.this.shell.setVisible(false);
                SearchField.this.removeAccessibleListener();
            }

            protected QuickAccessElement getPerfectMatch(String filter) {
                return (QuickAccessElement)SearchField.this.elementMap.get(filter);
            }

            protected void handleElementSelected(String string, Object selectedElement) {
                if (selectedElement instanceof QuickAccessElement) {
                    MPart activePart;
                    QuickAccessElement element = (QuickAccessElement)selectedElement;
                    SearchField.this.addPreviousPick(string, element);
                    SearchField.this.text.setText("");
                    element.execute();
                    if (SearchField.this.text.isFocusControl() && (activePart = SearchField.this.partService.getActivePart()) != null) {
                        IPresentationEngine pe = (IPresentationEngine)activePart.getContext().get(IPresentationEngine.class);
                        pe.focusGui((MUIElement)activePart);
                    }
                }
            }
        };
        this.quickAccessContents.hookFilterText(this.text);
        this.shell = new Shell(parent.getShell(), 16400);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setText(QuickAccessMessages.QuickAccess_EnterSearch);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SearchField.this.quickAccessContents.doClose();
                e.doit = false;
            }
        });
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.shell);
        this.table = this.quickAccessContents.createTable((Composite)this.shell, Window.getDefaultOrientation());
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                SearchField.this.table.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        SearchField.this.checkFocusLost(SearchField.this.table, SearchField.this.text);
                    }
                });
            }

            public void focusGained(FocusEvent e) {
                IHandlerService hs = (IHandlerService)SearchField.this.window.getContext().get(IHandlerService.class);
                if (commandProvider.getContextSnapshot() == null) {
                    commandProvider.setSnapshot(hs.createContextSnapshot(true));
                }
                SearchField.this.previousFocusControl = (Control)e.getSource();
            }
        });
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SearchField.this.table.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        SearchField.this.checkFocusLost(SearchField.this.table, SearchField.this.text);
                    }
                });
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean nowVisible;
                boolean wasVisible = SearchField.this.shell.getVisible();
                boolean bl = nowVisible = SearchField.this.text.getText().length() > 0;
                if (!wasVisible && nowVisible) {
                    SearchField.this.layoutShell();
                    SearchField.this.addAccessibleListener();
                    SearchField.this.quickAccessContents.preOpen();
                }
                if (wasVisible && !nowVisible) {
                    SearchField.this.removeAccessibleListener();
                }
                if (nowVisible) {
                    SearchField.this.notifyAccessibleTextChanged();
                }
                SearchField.this.shell.setVisible(nowVisible);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    SearchField.this.text.setText("");
                    if (SearchField.this.previousFocusControl != null && !SearchField.this.previousFocusControl.isDisposed()) {
                        SearchField.this.previousFocusControl.setFocus();
                    }
                } else if (e.keyCode == 0x1000001) {
                    e.doit = false;
                } else if (e.keyCode == 0x1000002) {
                    e.doit = false;
                }
                if (!e.doit) {
                    SearchField.this.notifyAccessibleTextChanged();
                }
            }
        });
        this.quickAccessContents.createInfoLabel((Composite)this.shell);
    }

    private Text createText(Composite parent) {
        Text text = new Text(parent, 640);
        text.setMessage(QuickAccessMessages.QuickAccess_EnterSearch);
        GC gc = new GC((Drawable)text);
        FontMetrics fm = gc.getFontMetrics();
        int width = text.computeSize((int)(fm.getAverageCharWidth() * text.getMessage().length()), (int)-1).x + 15;
        gc.dispose();
        GridDataFactory.fillDefaults().hint(width, -1).applyTo((Control)text);
        return text;
    }

    private void hookUpSelectAll() {
        IEclipseContext windowContext = this.window.getContext();
        IFocusService focus = (IFocusService)windowContext.get(IFocusService.class);
        focus.addFocusTracker((Control)this.text, SearchField.class.getName());
        Expression focusExpr = new Expression(){

            public void collectExpressionInfo(ExpressionInfo info) {
                info.addVariableNameAccess("activeFocusControlId");
            }

            public EvaluationResult evaluate(IEvaluationContext context) {
                return EvaluationResult.valueOf((boolean)SearchField.class.getName().equals(context.getVariable("activeFocusControlId")));
            }
        };
        IHandlerService whService = (IHandlerService)windowContext.get(IHandlerService.class);
        whService.activateHandler("org.eclipse.ui.edit.selectAll", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                SearchField.this.text.selectAll();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.cut", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                SearchField.this.text.cut();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.copy", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                SearchField.this.text.copy();
                return null;
            }
        }, focusExpr);
        whService.activateHandler("org.eclipse.ui.edit.paste", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                SearchField.this.text.paste();
                return null;
            }
        }, focusExpr);
    }

    private static Monitor getClosestMonitor(Display toSearch, Point toFind) {
        int closest = Integer.MAX_VALUE;
        Monitor[] monitors = toSearch.getMonitors();
        Monitor result = monitors[0];
        int idx = 0;
        while (idx < monitors.length) {
            Monitor current = monitors[idx];
            Rectangle clientArea = current.getClientArea();
            if (clientArea.contains(toFind)) {
                return current;
            }
            int distance = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)clientArea), (Point)toFind);
            if (distance < closest) {
                closest = distance;
                result = current;
            }
            ++idx;
        }
        return result;
    }

    private Rectangle getConstrainedShellBounds(Display display, Rectangle preferredSize) {
        Rectangle result = new Rectangle(preferredSize.x, preferredSize.y, preferredSize.width, preferredSize.height);
        Point topLeft = new Point(preferredSize.x, preferredSize.y);
        Monitor mon = SearchField.getClosestMonitor(display, topLeft);
        Rectangle bounds = mon.getClientArea();
        if (result.height > bounds.height) {
            result.height = bounds.height;
        }
        if (result.width > bounds.width) {
            result.width = bounds.width;
        }
        result.x = Math.max(bounds.x, Math.min(result.x, bounds.x + bounds.width - result.width));
        result.y = Math.max(bounds.y, Math.min(result.y, bounds.y + bounds.height - result.height));
        return result;
    }

    void layoutShell() {
        Display display = this.text.getDisplay();
        Rectangle tempBounds = this.text.getBounds();
        Rectangle compBounds = display.map((Control)this.text, null, tempBounds);
        int preferredWidth = this.dialogWidth == -1 ? 350 : this.dialogWidth;
        int width = Math.max(preferredWidth, compBounds.width);
        int height = this.dialogHeight == -1 ? 250 : this.dialogHeight;
        Rectangle shellBounds = this.text.getShell().getBounds();
        if (compBounds.x + width > shellBounds.x + shellBounds.width) {
            compBounds.x = Math.max(shellBounds.x, compBounds.x + compBounds.width - width);
        }
        this.shell.setBounds(this.getConstrainedShellBounds(display, new Rectangle(compBounds.x, compBounds.y + compBounds.height, width, height)));
        this.shell.layout();
    }

    public void activate(Control previousFocusControl) {
        this.previousFocusControl = previousFocusControl;
        if (!this.shell.isVisible()) {
            this.layoutShell();
            this.quickAccessContents.preOpen();
            this.shell.setVisible(true);
            this.addAccessibleListener();
            this.quickAccessContents.refresh(this.text.getText().toLowerCase());
        } else {
            this.quickAccessContents.setShowAllMatches(!this.quickAccessContents.getShowAllMatches());
        }
    }

    protected void checkFocusLost(Table table, Text text) {
        if (!(this.shell.isDisposed() || table.isDisposed() || text.isDisposed())) {
            if (table.getDisplay().getActiveShell() == table.getShell()) {
                text.setFocus();
                return;
            }
            if (!(this.shell.isFocusControl() || table.isFocusControl() || text.isFocusControl())) {
                this.quickAccessContents.doClose();
            }
        }
    }

    private void addAccessibleListener() {
        if (this.accessibleListener == null) {
            this.accessibleListener = new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = SearchField.this.selectedString;
                }
            };
            this.text.getAccessible().addAccessibleListener((AccessibleListener)this.accessibleListener);
        }
    }

    private void removeAccessibleListener() {
        if (this.accessibleListener != null) {
            this.text.getAccessible().removeAccessibleListener((AccessibleListener)this.accessibleListener);
            this.accessibleListener = null;
        }
        this.selectedString = "";
    }

    private void notifyAccessibleTextChanged() {
        if (this.table.getSelection().length == 0) {
            return;
        }
        TableItem item = this.table.getSelection()[0];
        this.selectedString = NLS.bind((String)QuickAccessMessages.QuickAccess_SelectedString, (Object)item.getText(0), (Object)item.getText(1));
        this.text.getAccessible().sendEvent(32780, null);
    }

    private void restoreDialog() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            String[] orderedElements = dialogSettings.getArray(ORDERED_ELEMENTS);
            String[] orderedProviders = dialogSettings.getArray(ORDERED_PROVIDERS);
            String[] textEntries = dialogSettings.getArray(TEXT_ENTRIES);
            String[] textArray = dialogSettings.getArray(TEXT_ARRAY);
            try {
                this.dialogHeight = dialogSettings.getInt(DIALOG_HEIGHT);
                this.dialogWidth = dialogSettings.getInt(DIALOG_WIDTH);
            }
            catch (NumberFormatException numberFormatException) {
                this.dialogHeight = -1;
                this.dialogWidth = -1;
            }
            if (orderedElements != null && orderedProviders != null && textEntries != null && textArray != null) {
                int arrayIndex = 0;
                int i = 0;
                while (i < orderedElements.length) {
                    QuickAccessElement quickAccessElement;
                    QuickAccessProvider quickAccessProvider = this.providerMap.get(orderedProviders[i]);
                    int numTexts = Integer.parseInt(textEntries[i]);
                    if (quickAccessProvider != null && (quickAccessElement = quickAccessProvider.getElementForId(orderedElements[i])) != null) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        int j = arrayIndex;
                        while (j < arrayIndex + numTexts) {
                            String text = textArray[j];
                            if (text.length() > 0) {
                                arrayList.add(text);
                                this.elementMap.put(text, quickAccessElement);
                            }
                            ++j;
                        }
                        this.textMap.put(quickAccessElement, arrayList);
                        this.previousPicksList.add(quickAccessElement);
                    }
                    arrayIndex += numTexts;
                    ++i;
                }
            }
        }
    }

    @PreDestroy
    void dispose() {
        this.storeDialog();
    }

    private void storeDialog() {
        String[] orderedElements = new String[this.previousPicksList.size()];
        String[] orderedProviders = new String[this.previousPicksList.size()];
        String[] textEntries = new String[this.previousPicksList.size()];
        ArrayList<String> arrayList = new ArrayList<String>();
        int i = 0;
        while (i < orderedElements.length) {
            QuickAccessElement quickAccessElement = this.previousPicksList.get(i);
            ArrayList<String> elementText = this.textMap.get(quickAccessElement);
            Assert.isNotNull(elementText);
            orderedElements[i] = quickAccessElement.getId();
            orderedProviders[i] = quickAccessElement.getProvider().getId();
            arrayList.addAll(elementText);
            textEntries[i] = String.valueOf(elementText.size());
            ++i;
        }
        String[] textArray = arrayList.toArray(new String[arrayList.size()]);
        IDialogSettings dialogSettings = this.getDialogSettings();
        dialogSettings.put(ORDERED_ELEMENTS, orderedElements);
        dialogSettings.put(ORDERED_PROVIDERS, orderedProviders);
        dialogSettings.put(TEXT_ENTRIES, textEntries);
        dialogSettings.put(TEXT_ARRAY, textArray);
        dialogSettings.put(DIALOG_HEIGHT, this.shell.getSize().y);
        dialogSettings.put(DIALOG_WIDTH, this.shell.getSize().x);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings workbenchDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings result = workbenchDialogSettings.getSection(this.getId());
        if (result == null) {
            result = workbenchDialogSettings.addNewSection(this.getId());
        }
        return result;
    }

    private String getId() {
        return "org.eclipse.ui.internal.QuickAccess";
    }

    private void addPreviousPick(String text, QuickAccessElement element) {
        this.previousPicksList.remove(element);
        if (this.previousPicksList.size() == 60) {
            QuickAccessElement removedElement = this.previousPicksList.removeLast();
            ArrayList<String> removedList = this.textMap.remove(removedElement);
            int i = 0;
            while (i < removedList.size()) {
                this.elementMap.remove(removedList.get(i));
                ++i;
            }
        }
        this.previousPicksList.addFirst(element);
        ArrayList<String> textList = this.textMap.get(element);
        if (textList == null) {
            textList = new ArrayList();
            this.textMap.put(element, textList);
        }
        textList.remove(text);
        if (textList.size() == 3) {
            String removedText = textList.remove(0);
            this.elementMap.remove(removedText);
        }
        if (text.length() > 0) {
            textList.add(text);
            QuickAccessElement replacedElement = this.elementMap.put(text, element);
            if (replacedElement != null && !replacedElement.equals(element) && (textList = this.textMap.get(replacedElement)) != null) {
                textList.remove(text);
                if (textList.isEmpty()) {
                    this.textMap.remove(replacedElement);
                    this.previousPicksList.remove(replacedElement);
                }
            }
        }
    }

    public Shell getQuickAccessShell() {
        return this.shell;
    }

    public Text getQuickAccessSearchText() {
        return this.text;
    }

    public Table getQuickAccessTable() {
        return this.table;
    }
}

