/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.net.URL;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IToc;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.search.ISearchEngineResult2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchHit
implements ISearchEngineResult2,
Comparable<SearchHit> {
    private String href;
    private String label;
    private float score;
    private IToc toc;
    private String summary;
    private String id;
    private String participantId;
    private boolean isPotentialHit;

    public SearchHit(String href, String label, String summary, float score, IToc toc, String id, String participantId, boolean isPotentialHit) {
        this.href = href;
        this.label = label;
        this.score = score;
        this.toc = toc;
        this.summary = summary;
        this.id = id;
        this.participantId = participantId;
        this.isPotentialHit = isPotentialHit;
    }

    @Override
    public int compareTo(SearchHit o) {
        float s2;
        if (o == this) {
            return 0;
        }
        float s1 = this.getScore();
        return s1 < (s2 = o.getScore()) ? 1 : (s1 > s2 ? -1 : 0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SearchHit) {
            if (obj == this) {
                return true;
            }
            return ((SearchHit)obj).getHref().equals(this.href);
        }
        return false;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    public IToc getToc() {
        return this.toc;
    }

    public int hashCode() {
        return this.href.hashCode();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setPotentialHit(boolean isPotentialHit) {
        this.isPotentialHit = isPotentialHit;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public void setToc(IToc toc) {
        this.toc = toc;
    }

    @Override
    public String getDescription() {
        return this.getSummary();
    }

    @Override
    public IHelpResource getCategory() {
        if (this.participantId == null) {
            return this.toc;
        }
        return BaseHelpSystem.getLocalSearchManager().getParticipantCategory(this.participantId);
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public boolean getForceExternalWindow() {
        return this.participantId != null;
    }

    @Override
    public String toAbsoluteHref(String href, boolean frames) {
        return href;
    }

    @Override
    public String getId() {
        return String.valueOf(this.participantId) + "/" + this.id;
    }

    public String getRawId() {
        return this.id;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    @Override
    public URL getIconURL() {
        if (this.participantId == null) {
            return null;
        }
        return BaseHelpSystem.getLocalSearchManager().getParticipantIconURL(this.participantId);
    }

    @Override
    public boolean canOpen() {
        return this.participantId != null;
    }

    public boolean isPotentialHit() {
        return this.isPotentialHit;
    }
}

