/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.completion;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.service.command.CommandSession;
import org.eclipse.equinox.console.completion.CommandLineParser;
import org.eclipse.equinox.console.completion.CommandNamesCompleter;
import org.eclipse.equinox.console.completion.FileNamesCompleter;
import org.eclipse.equinox.console.completion.VariableNamesCompleter;
import org.eclipse.equinox.console.completion.common.Completer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionHandler {
    private BundleContext context;
    private CommandSession session;
    Set<Completer> completers;
    private static final String FILE = "file";
    private static final char VARIABLE_PREFIX = '$';

    public CompletionHandler(BundleContext context, CommandSession session) {
        this.context = context;
        this.session = session;
        this.completers = new HashSet<Completer>();
    }

    public Map<String, Integer> getCandidates(byte[] buf, int cursor) {
        String currentInput = new String(buf);
        String currentToken = CommandLineParser.getCurrentToken(currentInput, cursor);
        if (currentToken == null) {
            return new HashMap<String, Integer>();
        }
        if (currentToken.contains(FILE)) {
            this.completers.add(new FileNamesCompleter());
        } else if (cursor - currentToken.length() > 0 && buf[cursor - currentToken.length() - 1] == 36) {
            this.completers.add(new VariableNamesCompleter(this.session));
        } else {
            this.completers.add(new CommandNamesCompleter(this.context, this.session));
            this.completers.add(new FileNamesCompleter());
        }
        this.lookupCustomCompleters();
        TreeMap<String, Integer> candidates = new TreeMap<String, Integer>();
        for (Completer completer : this.completers) {
            candidates.putAll(completer.getCandidates(currentInput, cursor));
        }
        return candidates;
    }

    private void lookupCustomCompleters() {
        ServiceReference[] completersRefs = null;
        try {
            completersRefs = this.context.getServiceReferences(Completer.class.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (completersRefs != null) {
            ServiceReference[] serviceReferenceArray = completersRefs;
            int n = completersRefs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                Completer completer = (Completer)this.context.getService(ref);
                if (completer != null) {
                    this.completers.add(completer);
                }
                ++n2;
            }
        }
    }
}

