/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.tweaklets.PreferencePageEnhancer;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.themes.ITheme;

public class ViewsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IThemeEngine engine;
    private ComboViewer themeIdCombo;
    private org.eclipse.e4.ui.css.swt.theme.ITheme currentTheme;
    private String defaultTheme;
    private Button enableAnimations;
    private Button useColoredLabels;
    private Text themeDescriptionText;
    private Combo themeCombo;

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 0).setText(WorkbenchMessages.ViewsPreferencePage_Theme);
        this.themeIdCombo = new ComboViewer(comp, 8);
        this.themeIdCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((org.eclipse.e4.ui.css.swt.theme.ITheme)element).getLabel();
            }
        });
        this.themeIdCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.themeIdCombo.setInput((Object)this.engine.getThemes());
        this.themeIdCombo.getControl().setLayoutData((Object)new GridData(768));
        this.currentTheme = this.engine.getActiveTheme();
        if (this.currentTheme != null) {
            this.themeIdCombo.setSelection((ISelection)new StructuredSelection((Object)this.currentTheme));
        }
        this.themeIdCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                org.eclipse.e4.ui.css.swt.theme.ITheme selection = ViewsPreferencePage.this.getSelection();
                ViewsPreferencePage.this.engine.setTheme(selection, false);
                ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).setSelection(selection);
            }
        });
        this.createThemeCombo(comp);
        this.createThemeDescriptionText(comp);
        this.createEnableAnimationsPref(comp);
        this.createColoredLabelsPref(comp);
        ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).setSelection(this.currentTheme);
        ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).createContents(comp);
        return comp;
    }

    private void createColoredLabelsPref(Composite composite) {
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.useColoredLabels = this.createCheckButton(composite, WorkbenchMessages.ViewsPreference_useColoredLabels, apiStore.getBoolean("USE_COLORED_LABELS"));
    }

    private Button createCheckButton(Composite composite, String text, boolean selection) {
        Button button = new Button(composite, 32);
        GridData data = new GridData(1, 0x1000000, false, false, 2, 1);
        button.setLayoutData((Object)data);
        button.setText(text);
        button.setSelection(selection);
        return button;
    }

    protected void createEnableAnimationsPref(Composite composite) {
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.enableAnimations = this.createCheckButton(composite, WorkbenchMessages.ViewsPreference_enableAnimations, apiStore.getBoolean("ENABLE_ANIMATIONS"));
    }

    private org.eclipse.e4.ui.css.swt.theme.ITheme getSelection() {
        return (org.eclipse.e4.ui.css.swt.theme.ITheme)((IStructuredSelection)this.themeIdCombo.getSelection()).getFirstElement();
    }

    public void init(IWorkbench workbench) {
        MApplication application = (MApplication)workbench.getService(MApplication.class);
        IEclipseContext context = application.getContext();
        this.defaultTheme = (String)context.get("cssTheme");
        this.engine = (IThemeEngine)context.get(IThemeEngine.class);
    }

    public boolean performOk() {
        if (this.getSelection() != null) {
            if (!this.getSelection().equals(this.currentTheme)) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)WorkbenchMessages.ThemeChangeWarningTitle, (String)WorkbenchMessages.ThemeChangeWarningText);
            }
            this.engine.setTheme(this.getSelection(), true);
        }
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        int idx = this.themeCombo.getSelectionIndex();
        if (idx <= 0) {
            PlatformUI.getWorkbench().getThemeManager().setCurrentTheme("org.eclipse.ui.defaultTheme");
            this.refreshThemeCombo("org.eclipse.ui.defaultTheme");
        } else {
            IThemeDescriptor applyTheme = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes()[idx - 1];
            PlatformUI.getWorkbench().getThemeManager().setCurrentTheme(applyTheme.getId());
            this.refreshThemeCombo(applyTheme.getId());
        }
        this.refreshThemeDescriptionText();
        apiStore.setValue("ENABLE_ANIMATIONS", this.enableAnimations.getSelection());
        apiStore.setValue("USE_COLORED_LABELS", this.useColoredLabels.getSelection());
        ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).performOK();
        return super.performOk();
    }

    protected void performDefaults() {
        ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).performDefaults();
        this.engine.setTheme(this.defaultTheme, true);
        if (this.engine.getActiveTheme() != null) {
            this.themeIdCombo.setSelection((ISelection)new StructuredSelection((Object)this.engine.getActiveTheme()));
        }
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.enableAnimations.setSelection(apiStore.getDefaultBoolean("ENABLE_ANIMATIONS"));
        this.useColoredLabels.setSelection(apiStore.getDefaultBoolean("USE_COLORED_LABELS"));
        super.performDefaults();
    }

    public boolean performCancel() {
        if (this.currentTheme != null) {
            this.engine.setTheme(this.currentTheme, false);
        }
        return super.performCancel();
    }

    private void createThemeCombo(Composite composite) {
        new Label(composite, 0).setText(WorkbenchMessages.ViewsPreference_currentTheme);
        this.themeCombo = new Combo(composite, 8);
        this.themeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.themeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.refreshThemeDescriptionText();
            }
        });
        this.refreshThemeCombo(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getId());
    }

    private void createThemeDescriptionText(Composite parent) {
        new Label(parent, 0).setText(WorkbenchMessages.ViewsPreference_currentThemeDescription);
        this.themeDescriptionText = new Text(parent, 2888);
        GridData layoutData = new GridData(4, 4, true, true);
        GC gc = new GC((Drawable)parent);
        layoutData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)2);
        gc.dispose();
        this.themeDescriptionText.setLayoutData((Object)layoutData);
        this.refreshThemeDescriptionText();
    }

    private void refreshThemeDescriptionText() {
        String description = null;
        int idx = this.themeCombo.getSelectionIndex();
        if (idx > 0) {
            IThemeDescriptor theme = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes()[idx - 1];
            description = theme.getDescription();
        }
        if (description == null) {
            description = "";
        }
        this.themeDescriptionText.setText(description);
    }

    private void refreshThemeCombo(String themeToSelect) {
        this.themeCombo.removeAll();
        ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        IThemeDescriptor[] descs = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes();
        String defaultThemeString = PlatformUI.getWorkbench().getThemeManager().getTheme("org.eclipse.ui.defaultTheme").getLabel();
        if (currentTheme.getId().equals("org.eclipse.ui.defaultTheme")) {
            defaultThemeString = NLS.bind((String)WorkbenchMessages.ViewsPreference_currentThemeFormat, (Object[])new Object[]{defaultThemeString});
        }
        this.themeCombo.add(defaultThemeString);
        int selection = 0;
        int i = 0;
        while (i < descs.length) {
            String themeString = descs[i].getName();
            if (descs[i].getId().equals(currentTheme.getId())) {
                themeString = NLS.bind((String)WorkbenchMessages.ViewsPreference_currentThemeFormat, (Object[])new Object[]{themeString});
            }
            if (themeToSelect.equals(descs[i].getId())) {
                selection = i + 1;
            }
            this.themeCombo.add(themeString);
            ++i;
        }
        this.themeCombo.select(selection);
    }
}

