/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.compatibility.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class FilterParser {
    private final String filterstring;
    private final char[] filterChars;
    private int pos;

    public FilterParser(String filterstring) {
        this.filterstring = filterstring;
        this.filterChars = filterstring.toCharArray();
        this.pos = 0;
    }

    public FilterComponent parse() throws InvalidSyntaxException {
        FilterComponent filter;
        try {
            filter = this.parse_filter();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InvalidSyntaxException("Filter ended abruptly", this.filterstring, (Throwable)e);
        }
        if (this.pos != this.filterChars.length) {
            throw new InvalidSyntaxException("Extraneous trailing characters: " + this.filterstring.substring(this.pos), this.filterstring);
        }
        return filter;
    }

    private FilterComponent parse_filter() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        if (this.filterChars[this.pos] != '(') {
            throw new InvalidSyntaxException("Missing '(': " + this.filterstring.substring(this.pos), this.filterstring);
        }
        ++this.pos;
        FilterComponent filter = this.parse_filtercomp();
        this.skipWhiteSpace();
        if (this.filterChars[this.pos] != ')') {
            throw new InvalidSyntaxException("Missing ')': " + this.filterstring.substring(this.pos), this.filterstring);
        }
        ++this.pos;
        this.skipWhiteSpace();
        return filter;
    }

    private FilterComponent parse_filtercomp() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        char c = this.filterChars[this.pos];
        switch (c) {
            case '&': {
                ++this.pos;
                return this.parse_and();
            }
            case '|': {
                ++this.pos;
                return this.parse_or();
            }
            case '!': {
                ++this.pos;
                return this.parse_not();
            }
        }
        return this.parse_item();
    }

    private FilterComponent parse_and() throws InvalidSyntaxException {
        int lookahead = this.pos;
        this.skipWhiteSpace();
        if (this.filterChars[this.pos] != '(') {
            this.pos = lookahead - 1;
            return this.parse_item();
        }
        ArrayList<FilterComponent> operands = new ArrayList<FilterComponent>(10);
        while (this.filterChars[this.pos] == '(') {
            FilterComponent child = this.parse_filter();
            operands.add(child);
        }
        return new FilterComponent(7, operands);
    }

    private FilterComponent parse_or() throws InvalidSyntaxException {
        int lookahead = this.pos;
        this.skipWhiteSpace();
        if (this.filterChars[this.pos] != '(') {
            this.pos = lookahead - 1;
            return this.parse_item();
        }
        ArrayList<FilterComponent> operands = new ArrayList<FilterComponent>(10);
        while (this.filterChars[this.pos] == '(') {
            FilterComponent child = this.parse_filter();
            operands.add(child);
        }
        return new FilterComponent(8, operands);
    }

    private FilterComponent parse_not() throws InvalidSyntaxException {
        int lookahead = this.pos;
        this.skipWhiteSpace();
        if (this.filterChars[this.pos] != '(') {
            this.pos = lookahead - 1;
            return this.parse_item();
        }
        ArrayList<FilterComponent> operands = new ArrayList<FilterComponent>(1);
        FilterComponent child = this.parse_filter();
        operands.add(child);
        return new FilterComponent(9, operands);
    }

    private FilterComponent parse_item() throws InvalidSyntaxException {
        String attr = this.parse_attr();
        this.skipWhiteSpace();
        switch (this.filterChars[this.pos]) {
            case '~': {
                if (this.filterChars[this.pos + 1] != '=') break;
                this.pos += 2;
                return new FilterComponent(2, attr, this.parse_value());
            }
            case '>': {
                if (this.filterChars[this.pos + 1] != '=') break;
                this.pos += 2;
                return new FilterComponent(3, attr, this.parse_value());
            }
            case '<': {
                if (this.filterChars[this.pos + 1] != '=') break;
                this.pos += 2;
                return new FilterComponent(4, attr, this.parse_value());
            }
            case '=': {
                ++this.pos;
                return new FilterComponent(1, attr, this.parse_value());
            }
        }
        throw new InvalidSyntaxException("Invalid operator: " + this.filterstring.substring(this.pos), this.filterstring);
    }

    private String parse_attr() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        int begin = this.pos;
        int end = this.pos;
        char c = this.filterChars[this.pos];
        while (c != '~' && c != '<' && c != '>' && c != '=' && c != '(' && c != ')') {
            ++this.pos;
            if (!Character.isWhitespace(c)) {
                end = this.pos;
            }
            c = this.filterChars[this.pos];
        }
        int length = end - begin;
        if (length == 0) {
            throw new InvalidSyntaxException("Missing attr: " + this.filterstring.substring(this.pos), this.filterstring);
        }
        return new String(this.filterChars, begin, length);
    }

    private String parse_value() throws InvalidSyntaxException {
        StringBuffer sb = new StringBuffer(this.filterChars.length - this.pos);
        block5: while (true) {
            char c = this.filterChars[this.pos];
            switch (c) {
                case ')': {
                    break block5;
                }
                case '(': {
                    throw new InvalidSyntaxException("Invalid value: " + this.filterstring.substring(this.pos), this.filterstring);
                }
                case '\\': {
                    ++this.pos;
                    c = this.filterChars[this.pos];
                }
                default: {
                    sb.append(c);
                    ++this.pos;
                    continue block5;
                }
            }
            break;
        }
        if (sb.length() == 0) {
            throw new InvalidSyntaxException("Missing value: " + this.filterstring.substring(this.pos), this.filterstring);
        }
        return sb.toString();
    }

    private void skipWhiteSpace() {
        int length = this.filterChars.length;
        while (this.pos < length && Character.isWhitespace(this.filterChars[this.pos])) {
            ++this.pos;
        }
    }

    public static class FilterComponent {
        public static final int EQUAL = 1;
        public static final int APPROX = 2;
        public static final int GREATER = 3;
        public static final int LESS = 4;
        public static final int AND = 7;
        public static final int OR = 8;
        public static final int NOT = 9;
        private final int op;
        private final String attr;
        private final String value;
        private final List<FilterComponent> nested;

        public FilterComponent(int op, List<FilterComponent> nested) {
            this.op = op;
            this.attr = null;
            this.value = null;
            this.nested = nested;
        }

        public FilterComponent(int op, String attr, String value) {
            this.op = op;
            this.attr = attr;
            this.value = value;
            this.nested = Collections.emptyList();
        }

        public int getOp() {
            return this.op;
        }

        public String getAttr() {
            return this.attr;
        }

        public String getValue() {
            return this.value;
        }

        public List<FilterComponent> getNested() {
            return this.nested;
        }

        public Map<String, String> getStandardOSGiAttributes(String ... versions) {
            if (this.op != 7 && this.op != 1) {
                throw new IllegalStateException("Invalid filter for Starndard OSGi Attributes: " + this.op);
            }
            HashMap<String, String> result = new HashMap<String, String>();
            HashMap<String, Range> versionAttrs = new HashMap<String, Range>();
            if (versions != null) {
                String[] stringArray = versions;
                int n = versions.length;
                int n2 = 0;
                while (n2 < n) {
                    String versionAttr = stringArray[n2];
                    versionAttrs.put(versionAttr, null);
                    ++n2;
                }
            }
            this.addAttributes(result, versionAttrs, false);
            for (Map.Entry entry : versionAttrs.entrySet()) {
                Range range = (Range)entry.getValue();
                if (range == null) continue;
                result.put((String)entry.getKey(), range.toString());
            }
            return result;
        }

        private void addAttributes(Map<String, String> attributes, Map<String, Range> versionAttrs, boolean not) {
            if (this.op == 1) {
                if (!versionAttrs.containsKey(this.attr)) {
                    attributes.put(this.attr, this.value);
                } else {
                    Range currentRange = versionAttrs.get(this.attr);
                    if (currentRange != null) {
                        if (not) {
                            currentRange.addExclude(new Version(this.value));
                        } else {
                            throw new IllegalStateException("Invalid range for: " + this.attr);
                        }
                    }
                    currentRange = new Range();
                    Version version = new Version(this.value);
                    currentRange.setLeft('[', version);
                    currentRange.setRight(']', version);
                    versionAttrs.put(this.attr, currentRange);
                }
            } else if (this.op == 4) {
                if (!versionAttrs.containsKey(this.attr)) {
                    throw new IllegalStateException("Invalid attribute: " + this.attr);
                }
                Range currentRange = versionAttrs.get(this.attr);
                if (currentRange == null) {
                    currentRange = new Range();
                    versionAttrs.put(this.attr, currentRange);
                }
                if (not) {
                    if (!currentRange.setLeft('(', new Version(this.value))) {
                        throw new IllegalStateException("range start is already processed for attribute: " + this.attr);
                    }
                } else if (!currentRange.setRight(']', new Version(this.value))) {
                    throw new IllegalStateException("range end is already processed for attribute: " + this.attr);
                }
            } else if (this.op == 3) {
                if (!versionAttrs.containsKey(this.attr)) {
                    throw new IllegalStateException("Invalid attribute: " + this.attr);
                }
                Range currentRange = versionAttrs.get(this.attr);
                if (currentRange == null) {
                    currentRange = new Range();
                    versionAttrs.put(this.attr, currentRange);
                }
                if (not) {
                    if (!currentRange.setRight(')', new Version(this.value))) {
                        throw new IllegalStateException("range end is already processed for attribute: " + this.attr);
                    }
                } else if (!currentRange.setLeft('[', new Version(this.value))) {
                    throw new IllegalStateException("range start is already processed for attribute: " + this.attr);
                }
            } else if (this.op == 7) {
                for (FilterComponent component : this.nested) {
                    component.addAttributes(attributes, versionAttrs, false);
                }
            } else if (this.op == 9) {
                this.nested.get(0).addAttributes(attributes, versionAttrs, true);
            } else {
                throw new IllegalStateException("Invalid filter for standard OSGi requirements: " + this.op);
            }
        }
    }

    static class Range {
        private char leftRule = '\u0000';
        private Version leftVersion;
        private Version rightVersion;
        private char rightRule = '\u0000';
        private Collection<Version> excludes = new ArrayList<Version>(0);

        Range() {
        }

        public String toString() {
            if (this.rightVersion == null) {
                return this.leftVersion.toString();
            }
            return String.valueOf(this.leftRule) + this.leftVersion.toString() + ',' + this.rightVersion.toString() + this.rightRule;
        }

        void addExclude(Version exclude) {
            this.excludes.add(exclude);
            this.setLeft(this.leftRule, this.leftVersion);
            this.setRight(this.rightRule, this.rightVersion);
        }

        boolean setLeft(char leftRule, Version leftVersion) {
            if (this.leftVersion != null && this.leftVersion != leftVersion) {
                return false;
            }
            this.leftRule = (char)(this.excludes.contains(leftVersion) ? 40 : (int)leftRule);
            this.leftVersion = leftVersion;
            return true;
        }

        boolean setRight(char rightRule, Version rightVersion) {
            if (this.rightVersion != null && this.rightVersion != rightVersion) {
                return false;
            }
            this.rightRule = (char)(this.excludes.contains(rightVersion) ? 41 : (int)rightRule);
            this.rightVersion = rightVersion;
            return true;
        }
    }
}

