/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.servlet.PrioritizedFilter;
import org.eclipse.help.webapp.IFilter;

public class ExtraFilters
implements IFilter {
    public static final String CONTENTFILTER_XP_NAME = "org.eclipse.help.webapp.contentFilter";
    private static List filters = null;

    public ExtraFilters() {
        if (filters == null) {
            this.readFilters();
        }
    }

    private void readFilters() {
        filters = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(CONTENTFILTER_XP_NAME);
        int i = 0;
        while (i < elements.length) {
            Object obj = null;
            try {
                obj = elements[i].createExecutableExtension("class");
            }
            catch (CoreException e) {
                HelpWebappPlugin.logError("Create extension failed:[org.eclipse.help.webapp.contentFilter].", e);
            }
            if (obj instanceof IFilter) {
                int priority = 0;
                String priStr = elements[i].getAttribute("priority");
                if (priStr != null && !"".equals(priStr)) {
                    try {
                        priority = Integer.parseInt(priStr);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                PrioritizedFilter filter = new PrioritizedFilter((IFilter)obj, priority);
                filters.add(filter);
            }
            ++i;
        }
        ExtraFilters.sortFilters();
    }

    private static void sortFilters() {
        Collections.sort(filters);
        Collections.reverse(filters);
    }

    public static void setFilters(PrioritizedFilter[] newFilters) {
        filters = new ArrayList();
        int i = 0;
        while (i < newFilters.length) {
            filters.add(newFilters[i]);
            ++i;
        }
        ExtraFilters.sortFilters();
    }

    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        int index = 0;
        while (index < filters.size()) {
            PrioritizedFilter filter = (PrioritizedFilter)filters.get(index);
            out = filter.filter(req, out);
            ++index;
        }
        return out;
    }
}

