/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.layout;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LayoutGenerator {
    private static final Point defaultSize = new Point(150, 150);
    private static final int wrapSize = 350;
    private static final GridDataFactory nonWrappingLabelData = GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false);

    LayoutGenerator() {
    }

    private static boolean hasStyle(Control c, int style) {
        return (c.getStyle() & style) != 0;
    }

    public static void generateLayout(Composite toGenerate) {
        Control[] children = toGenerate.getChildren();
        int i = 0;
        while (i < children.length) {
            Control control = children[i];
            if (control.getLayoutData() == null) {
                LayoutGenerator.applyLayoutDataTo(control);
            }
            ++i;
        }
    }

    private static void applyLayoutDataTo(Control control) {
        LayoutGenerator.defaultsFor(control).applyTo(control);
    }

    public static GridDataFactory defaultsFor(Control control) {
        boolean userEditable;
        Composite composite;
        Layout theLayout;
        Scrollable scrollable;
        if (control instanceof Button) {
            Button button = (Button)control;
            if (LayoutGenerator.hasStyle((Control)button, 32)) {
                return nonWrappingLabelData.copy();
            }
            return GridDataFactory.fillDefaults().align(4, 0x1000000).hint(Geometry.max(button.computeSize(-1, -1, true), LayoutConstants.getMinButtonSize()));
        }
        if (control instanceof Scrollable && (scrollable = (Scrollable)control) instanceof Composite && (theLayout = (composite = (Composite)control).getLayout()) instanceof GridLayout) {
            boolean growsHorizontally = false;
            boolean growsVertically = false;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                GridData data = (GridData)child.getLayoutData();
                if (data != null) {
                    if (data.grabExcessHorizontalSpace) {
                        growsHorizontally = true;
                    }
                    if (data.grabExcessVerticalSpace) {
                        growsVertically = true;
                    }
                }
                ++i;
            }
            return GridDataFactory.fillDefaults().grab(growsHorizontally, growsVertically);
        }
        boolean wrapping = LayoutGenerator.hasStyle(control, 64);
        boolean hScroll = LayoutGenerator.hasStyle(control, 256);
        boolean vScroll = LayoutGenerator.hasStyle(control, 512);
        boolean containsText = LayoutGenerator.hasMethod(control, "setText", new Class[]{String.class});
        boolean bl = userEditable = !LayoutGenerator.hasStyle(control, 8) && containsText && LayoutGenerator.hasMethod(control, "addModifyListener", new Class[]{ModifyListener.class});
        if (userEditable) {
            if (LayoutGenerator.hasStyle(control, 2)) {
                vScroll = true;
            }
            if (!wrapping) {
                hScroll = true;
            }
        }
        int hHint = -1;
        boolean grabHorizontal = hScroll;
        if (hScroll) {
            hHint = LayoutGenerator.defaultSize.x;
        } else if (wrapping && containsText) {
            hHint = 350;
            grabHorizontal = true;
        }
        int vAlign = 4;
        if (!vScroll && !wrapping && !userEditable && containsText) {
            vAlign = 0x1000000;
        }
        return GridDataFactory.fillDefaults().grab(grabHorizontal, vScroll).align(4, vAlign).hint(hHint, vScroll ? LayoutGenerator.defaultSize.y : -1);
    }

    private static boolean hasMethod(Control control, String name, Class<?>[] parameterTypes) {
        Class<?> c = control.getClass();
        try {
            return c.getMethod(name, parameterTypes) != null;
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }
}

