/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.search;

import java.util.HashSet;
import org.eclipse.dltk.internal.ui.search.DLTKSearchContentProvider;
import org.eclipse.dltk.internal.ui.search.DLTKSearchResult;
import org.eclipse.dltk.internal.ui.search.DLTKSearchResultPage;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Table;

public class DLTKSearchTableContentProvider
extends DLTKSearchContentProvider
implements IStructuredContentProvider {
    public DLTKSearchTableContentProvider(DLTKSearchResultPage page) {
        super(page);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof DLTKSearchResult) {
            HashSet<Object> filteredElements = new HashSet<Object>();
            Object[] rawElements = ((DLTKSearchResult)((Object)inputElement)).getElements();
            int limit = this.getPage().getElementLimit();
            int i = 0;
            while (i < rawElements.length) {
                if (this.getPage().getDisplayedMatchCount(rawElements[i]) > 0) {
                    filteredElements.add(rawElements[i]);
                    if (limit != -1 && limit < filteredElements.size()) break;
                }
                ++i;
            }
            return filteredElements.toArray();
        }
        return this.EMPTY_ARR;
    }

    public void elementsChanged(Object[] updatedElements) {
        if (this.fResult == null) {
            return;
        }
        int addLimit = this.getAddLimit();
        TableViewer viewer = (TableViewer)this.getPage().getViewer();
        HashSet<Object> updated = new HashSet<Object>();
        HashSet<Object> added = new HashSet<Object>();
        HashSet<Object> removed = new HashSet<Object>();
        int i = 0;
        while (i < updatedElements.length) {
            if (this.getPage().getDisplayedMatchCount(updatedElements[i]) > 0) {
                if (viewer.testFindItem(updatedElements[i]) != null) {
                    updated.add(updatedElements[i]);
                } else if (addLimit > 0) {
                    added.add(updatedElements[i]);
                    --addLimit;
                }
            } else {
                removed.add(updatedElements[i]);
            }
            ++i;
        }
        viewer.add(added.toArray());
        viewer.update(updated.toArray(), new String[]{"org.eclipse.dltk.search.matchCount"});
        viewer.remove(removed.toArray());
    }

    private int getAddLimit() {
        int limit = this.getPage().getElementLimit();
        if (limit != -1) {
            Table table = (Table)this.getPage().getViewer().getControl();
            int itemCount = table.getItemCount();
            if (itemCount >= limit) {
                return 0;
            }
            return limit - itemCount;
        }
        return Integer.MAX_VALUE;
    }

    public void clear() {
        this.getPage().getViewer().refresh();
    }
}

