/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.ResourceBundle;
import org.eclipse.ui.internal.themes.Theme;

public class ThemeElementDefinition {
    private String id;
    private String label;
    private String description;
    private String categoryId;
    private boolean overridden;
    private boolean addedByCss;
    private String overriddenLabel;

    public ThemeElementDefinition(String id, String label, String description, String categoryId) {
        this.id = id;
        this.label = label;
        this.description = description;
        this.categoryId = categoryId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.label;
    }

    public void setName(String label) {
        this.label = label;
        this.setOverridden(true);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.setOverridden(true);
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
        this.setOverridden(true);
    }

    public boolean isOverridden() {
        return this.overridden;
    }

    protected void setOverridden(boolean overridden) {
        this.overridden = overridden;
        if (this.isAddedByCss()) {
            return;
        }
        boolean hasOverriddenLabel = this.description.endsWith(this.getOverriddenLabel());
        if (overridden && !hasOverriddenLabel) {
            this.description = String.valueOf(this.description) + ' ' + this.getOverriddenLabel();
        } else if (!overridden && hasOverriddenLabel) {
            this.description = this.description.substring(0, this.description.length() - this.getOverriddenLabel().length() - 1);
        }
    }

    public boolean isAddedByCss() {
        return this.addedByCss;
    }

    public void setAddedByCss(boolean addedByCss) {
        this.addedByCss = addedByCss;
    }

    public String getOverriddenLabel() {
        if (this.overriddenLabel == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(Theme.class.getName());
            this.overriddenLabel = resourceBundle.getString("Overridden.by.css.label");
        }
        return this.overriddenLabel;
    }

    public void resetToDefaultValue() {
        this.setOverridden(false);
        this.setAddedByCss(false);
    }
}

