/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import java.util.List;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimBarLayout;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimmedPartLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TrimDropAgent
extends DropAgent {
    private SideValue side;
    private MTrimBar trimBar;

    public TrimDropAgent(DnDManager manager) {
        super(manager);
    }

    public boolean canDrop(MUIElement dragElement, DnDInfo info) {
        if (!(dragElement instanceof MTrimElement)) {
            return false;
        }
        this.side = this.getDropSide(info);
        return this.side != null;
    }

    private SideValue getDropSide(DnDInfo info) {
        Shell ds = this.dndManager.getDragShell();
        if (ds.getLayout() instanceof TrimmedPartLayout) {
            TrimmedPartLayout tpl = (TrimmedPartLayout)ds.getLayout();
            if (tpl.getTrimRect(128).contains(info.cursorPos)) {
                return SideValue.TOP;
            }
            if (tpl.getTrimRect(1024).contains(info.cursorPos)) {
                return SideValue.BOTTOM;
            }
            if (tpl.getTrimRect(16384).contains(info.cursorPos)) {
                return SideValue.LEFT;
            }
            if (tpl.getTrimRect(131072).contains(info.cursorPos)) {
                return SideValue.RIGHT;
            }
        }
        return null;
    }

    private MUIElement getInsertionElement(MUIElement dragElement, DnDInfo info) {
        Point trimPos;
        Composite trimComp = (Composite)this.trimBar.getWidget();
        if (info.curCtrl == trimComp) {
            return null;
        }
        TrimBarLayout tbl = (TrimBarLayout)trimComp.getLayout();
        Control trimCtrl = tbl.ctrlFromPoint(trimComp, trimPos = trimComp.getDisplay().map(null, (Control)trimComp, info.cursorPos));
        if (trimCtrl == null) {
            return null;
        }
        if (trimCtrl == dragElement.getWidget()) {
            return dragElement;
        }
        MUIElement trimElement = (MUIElement)trimCtrl.getData("modelElement");
        if (this.isAfter(trimCtrl, info)) {
            MElementContainer trimParent = trimElement.getParent();
            int trimIndex = trimParent.getChildren().indexOf(trimElement);
            if (trimIndex == trimParent.getChildren().size() - 1) {
                return null;
            }
            return (MUIElement)trimParent.getChildren().get(trimIndex + 1);
        }
        return trimElement;
    }

    private boolean isAfter(Control trimCtrl, DnDInfo info) {
        boolean horizontal;
        Rectangle bounds = trimCtrl.getBounds();
        bounds = trimCtrl.getDisplay().map((Control)trimCtrl.getParent(), null, bounds);
        Point center = new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        boolean bl = horizontal = this.trimBar.getSide() == SideValue.TOP || this.trimBar.getSide() == SideValue.BOTTOM;
        boolean after = horizontal ? info.cursorPos.x > center.x : info.cursorPos.y > center.y;
        return after;
    }

    public void dragEnter(MUIElement dragElement, DnDInfo info) {
        super.dragEnter(dragElement, info);
        MTrimmedWindow window = (MTrimmedWindow)this.dndManager.getDragWindow();
        this.trimBar = this.dndManager.getModelService().getTrim(window, this.side);
        this.trimBar.setToBeRendered(true);
        dragElement.setVisible(true);
        this.track(dragElement, info);
        this.dndManager.setCursor(Display.getCurrent().getSystemCursor(21));
    }

    public void dragLeave(MUIElement dragElement, DnDInfo info) {
        this.trimBar = null;
        this.side = null;
        this.dndManager.setCursor(Display.getCurrent().getSystemCursor(20));
        super.dragLeave(dragElement, info);
    }

    public boolean track(MUIElement dragElement, DnDInfo info) {
        SideValue curSide = this.getDropSide(info);
        if (this.side != curSide) {
            return false;
        }
        MUIElement insertBefore = this.getInsertionElement(dragElement, info);
        MElementContainer curParent = dragElement.getParent();
        List trimKids = this.trimBar.getChildren();
        boolean sameParent = curParent == this.trimBar;
        boolean alreadyThere = false;
        if (sameParent) {
            if (insertBefore == null) {
                alreadyThere = trimKids.get(trimKids.size() - 1) == dragElement;
            } else {
                boolean bl = alreadyThere = insertBefore == dragElement;
                if (!alreadyThere) {
                    boolean bl2 = alreadyThere = trimKids.indexOf(dragElement) == trimKids.indexOf(insertBefore) - 1;
                }
            }
        }
        if (!sameParent || !alreadyThere) {
            this.dock(dragElement, insertBefore);
        }
        return true;
    }

    private void dock(MUIElement dragElement, MUIElement insertBefore) {
        dragElement.setToBeRendered(false);
        dragElement.getParent().getChildren().remove(dragElement);
        dragElement.setVisible(true);
        if (insertBefore == null) {
            this.trimBar.getChildren().add((MTrimElement)dragElement);
        } else {
            int dropIndex = this.trimBar.getChildren().indexOf(insertBefore);
            this.trimBar.getChildren().add(dropIndex, (MTrimElement)dragElement);
        }
        dragElement.setToBeRendered(true);
        Control trimCtrl = (Control)dragElement.getWidget();
        trimCtrl.setBackground(trimCtrl.getDisplay().getSystemColor(18));
    }

    public boolean drop(MUIElement dragElement, DnDInfo info) {
        Control trimCtrl = (Control)dragElement.getWidget();
        trimCtrl.setBackground(null);
        return true;
    }
}

