/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.widgets.ImageBasedFrame;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DragAgent;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStack;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class IBFDragAgent
extends DragAgent {
    private ImageBasedFrame frame;
    private Shell ds;

    public IBFDragAgent(DnDManager manager) {
        super(manager);
    }

    public MUIElement getElementToDrag(DnDInfo info) {
        if (!(info.curCtrl instanceof ImageBasedFrame)) {
            return null;
        }
        if (!(info.curElement instanceof MTrimElement)) {
            return null;
        }
        ImageBasedFrame frame = (ImageBasedFrame)info.curCtrl;
        Rectangle handleRect = frame.getHandleRect();
        handleRect = frame.getDisplay().map((Control)frame, null, handleRect);
        if (handleRect.contains(info.cursorPos)) {
            this.dragElement = info.curElement;
            return info.curElement;
        }
        return null;
    }

    public void dragStart(DnDInfo info) {
        MToolControl tc;
        super.dragStart(info);
        if (this.dragElement instanceof MToolControl && (tc = (MToolControl)this.dragElement).getObject() instanceof TrimStack) {
            TrimStack ts = (TrimStack)tc.getObject();
            ts.showStack(false);
        }
        if (this.dropAgent == null) {
            this.attachToCursor(info);
        }
    }

    private void attachToCursor(DnDInfo info) {
        this.frame = (ImageBasedFrame)this.dragElement.getWidget();
        this.dragElement.setVisible(false);
        this.dragElement.getTags().add("LockVisibility");
        if (this.ds == null) {
            this.ds = new Shell(this.dndManager.getDragShell(), 8);
        }
        this.frame.setParent((Composite)this.ds);
        this.frame.setLocation(0, 0);
        this.ds.setSize(this.frame.getSize());
        this.ds.setLocation(info.cursorPos.x - 5, info.cursorPos.y - 5);
        this.ds.open();
        info.update();
    }

    public void track(DnDInfo info) {
        super.track(info);
        if (this.dropAgent != null && this.ds != null && !this.ds.isDisposed() && this.ds.getChildren().length == 0) {
            this.ds.dispose();
            this.ds = null;
        }
        if (this.dropAgent == null) {
            this.attachToCursor(info);
        }
        if (this.ds != null) {
            this.ds.setLocation(info.cursorPos.x - 5, info.cursorPos.y - 5);
        }
    }

    public void dragFinished(boolean performDrop, DnDInfo info) {
        this.dragElement.getTags().remove("LockVisibility");
        this.dragElement.setVisible(true);
        super.dragFinished(performDrop, info);
        if (this.ds != null && !this.ds.isDisposed()) {
            this.ds.dispose();
        }
        this.ds = null;
    }
}

