/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.BasicPartList;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.SWTRenderersMessages;
import org.eclipse.e4.ui.internal.workbench.swt.CSSRenderingUtils;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MOpaqueMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MOpaqueMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.LazyStackRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.w3c.dom.css.CSSValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackRenderer
extends LazyStackRenderer {
    @Inject
    @Named(value="org.eclipse.e4.ui.workbench.renderers.swt.SHARED_ELEMENTS_STORE")
    Map<MUIElement, Set<MPlaceholder>> renderedMap;
    public static final String TAG_VIEW_MENU = "ViewMenu";
    private static final String SHELL_CLOSE_EDITORS_MENU = "shell_close_editors_menu";
    private static final String STACK_SELECTED_PART = "stack_selected_part";
    private static final String INHIBIT_FOCUS = "InhibitFocus";
    private static int MIN_VIEW_CHARS = 1;
    private static int MIN_EDITOR_CHARS = 15;
    Image viewMenuImage;
    @Inject
    IStylingEngine stylingEngine;
    @Inject
    IEventBroker eventBroker;
    @Inject
    IPresentationEngine renderer;
    private EventHandler itemUpdater;
    private EventHandler dirtyUpdater;
    private EventHandler viewMenuUpdater;
    private EventHandler childrenHandler;
    private EventHandler tabStateHandler;
    private EventHandler stylingHandler;
    private boolean ignoreTabSelChanges = false;
    boolean adjusting = false;

    List<CTabItem> getItemsToSet(MPart part) {
        ArrayList<CTabItem> itemsToSet = new ArrayList<CTabItem>();
        MElementContainer partParent = part.getParent();
        if (partParent instanceof MPartStack) {
            CTabItem item = this.findItemForPart(part);
            if (item != null) {
                itemsToSet.add(this.findItemForPart(part));
            }
        } else if (part.getCurSharedRef() != null) {
            MWindow topWin = this.modelService.getTopLevelWindowFor((MUIElement)part);
            List partRefs = this.modelService.findElements((MUIElement)topWin, part.getElementId(), MPlaceholder.class, null);
            for (MPlaceholder ref : partRefs) {
                CTabItem item = this.findItemForPart((MUIElement)ref, null);
                if (item == null) continue;
                itemsToSet.add(item);
            }
        }
        return itemsToSet;
    }

    @Inject
    @Optional
    private void handleTransientDataEvents(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/transientData/*") Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (!(changedElement instanceof MPart)) {
            return;
        }
        String key = UIEvents.isREMOVE((Event)event) ? (String)((Map.Entry)event.getProperty("OldValue")).getKey() : (String)((Map.Entry)event.getProperty("NewValue")).getKey();
        if (!"e4_override_icon_image_key".equals(key) && !"e4_override_title_tool_tip_key".equals(key)) {
            return;
        }
        MPart part = (MPart)changedElement;
        List<CTabItem> itemsToSet = this.getItemsToSet(part);
        for (CTabItem item : itemsToSet) {
            if (key.equals("e4_override_icon_image_key")) {
                item.setImage(this.getImage((MUILabel)part));
                continue;
            }
            if (!key.equals("e4_override_title_tool_tip_key")) continue;
            String newTip = this.getToolTip((MUILabel)part);
            item.setToolTipText(this.getToolTip(newTip));
        }
    }

    @Inject
    @Optional
    private void subscribeTopicTagsChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MPart)) {
            return;
        }
        MPart part = (MPart)changedObj;
        CTabItem item = this.findItemForPart(part);
        if (item == null || item.isDisposed()) {
            return;
        }
        if (UIEvents.isADD((Event)event)) {
            if (UIEvents.contains((Event)event, (String)"NewValue", (Object)"Pin Adornment")) {
                item.setImage(this.getImage((MUILabel)part));
            }
        } else if (UIEvents.isREMOVE((Event)event) && UIEvents.contains((Event)event, (String)"OldValue", (Object)"Pin Adornment")) {
            item.setImage(this.getImage((MUILabel)part));
        }
    }

    @Override
    protected boolean requiresFocus(MPart element) {
        MPart inStack;
        Object object = inStack = element.getCurSharedRef() != null ? element.getCurSharedRef() : element;
        if (inStack.getParent() != null && inStack.getParent().getTransientData().containsKey(INHIBIT_FOCUS)) {
            inStack.getParent().getTransientData().remove(INHIBIT_FOCUS);
            return false;
        }
        return super.requiresFocus(element);
    }

    @PostConstruct
    public void init() {
        super.init(this.eventBroker);
        this.itemUpdater = new EventHandler(){

            public void handleEvent(Event event) {
                MUIElement element = (MUIElement)event.getProperty("ChangedElement");
                if (!(element instanceof MPart)) {
                    return;
                }
                MPart part = (MPart)element;
                String attName = (String)event.getProperty("AttName");
                Object newValue = event.getProperty("NewValue");
                if (element.getParent() != null && element.getParent().getRenderer() == StackRenderer.this) {
                    CTabItem cti = StackRenderer.this.findItemForPart(element, (MElementContainer<MUIElement>)element.getParent());
                    if (cti != null) {
                        StackRenderer.this.updateTab(cti, part, attName, newValue);
                    }
                    return;
                }
                MWindow win = StackRenderer.this.modelService.getTopLevelWindowFor((MUIElement)part);
                List refs = StackRenderer.this.modelService.findElements((MUIElement)win, null, MPlaceholder.class, null);
                if (refs != null) {
                    for (MPlaceholder ref : refs) {
                        CTabItem cti;
                        MElementContainer refParent;
                        if (ref.getRef() != part || (refParent = ref.getParent()) == null || !(refParent.getRenderer() instanceof StackRenderer) || (cti = StackRenderer.this.findItemForPart((MUIElement)ref, (MElementContainer<MUIElement>)refParent)) == null) continue;
                        StackRenderer.this.updateTab(cti, part, attName, newValue);
                    }
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UILabel/*", this.itemUpdater);
        this.dirtyUpdater = new EventHandler(){

            public void handleEvent(Event event) {
                Object objElement = event.getProperty("ChangedElement");
                if (!(objElement instanceof MPart)) {
                    return;
                }
                MPart part = (MPart)objElement;
                String attName = (String)event.getProperty("AttName");
                Object newValue = event.getProperty("NewValue");
                MElementContainer parent = part.getParent();
                if (parent != null && parent.getRenderer() == StackRenderer.this) {
                    CTabItem cti = StackRenderer.this.findItemForPart((MUIElement)part, (MElementContainer<MUIElement>)parent);
                    if (cti != null) {
                        StackRenderer.this.updateTab(cti, part, attName, newValue);
                    }
                    return;
                }
                Set<MPlaceholder> refs = StackRenderer.this.renderedMap.get(part);
                if (refs != null) {
                    for (MPlaceholder ref : refs) {
                        CTabItem cti;
                        MElementContainer refParent = ref.getParent();
                        if (!(refParent.getRenderer() instanceof StackRenderer) || (cti = StackRenderer.this.findItemForPart((MUIElement)ref, (MElementContainer<MUIElement>)refParent)) == null) continue;
                        StackRenderer.this.updateTab(cti, part, attName, newValue);
                    }
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/Dirtyable", (String)"dirty"), this.dirtyUpdater);
        this.viewMenuUpdater = new EventHandler(){

            public void handleEvent(Event event) {
                Object widget;
                Object objElement = event.getProperty("ChangedElement");
                if (!(objElement instanceof MMenuElement)) {
                    return;
                }
                MMenuElement menuModel = (MMenuElement)objElement;
                MUIElement menuParent = StackRenderer.this.modelService.getContainer((MUIElement)menuModel);
                if (!(menuParent instanceof MPart)) {
                    return;
                }
                MPart element = (MPart)menuParent;
                MElementContainer parentElement = element.getParent();
                if (parentElement == null) {
                    MPlaceholder placeholder = element.getCurSharedRef();
                    if (placeholder == null) {
                        return;
                    }
                    parentElement = placeholder.getParent();
                    if (parentElement == null) {
                        return;
                    }
                }
                if ((widget = parentElement.getWidget()) instanceof CTabFolder) {
                    StackRenderer.this.adjustTopRight((CTabFolder)widget);
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/visible/*", this.viewMenuUpdater);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this.viewMenuUpdater);
        this.childrenHandler = new EventHandler(){

            public void handleEvent(Event event) {
                Object widget;
                MElementContainer parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (!(changedObj instanceof MToolBar)) {
                    return;
                }
                MUIElement container = StackRenderer.this.modelService.getContainer((MUIElement)changedObj);
                if (container instanceof MPart && (parent = ((MPart)container).getParent()) instanceof MPartStack && parent.getSelectedElement() == container && parent.getRenderer() == StackRenderer.this && (widget = parent.getWidget()) instanceof CTabFolder) {
                    StackRenderer.this.adjustTopRight((CTabFolder)widget);
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this.childrenHandler);
        this.stylingHandler = new EventHandler(){

            public void handleEvent(Event event) {
                MUIElement changed = (MUIElement)event.getProperty("ChangedElement");
                if (!(changed instanceof MPart)) {
                    return;
                }
                MPart newActivePart = (MPart)changed;
                MElementContainer partParent = newActivePart.getParent();
                if (partParent == null && newActivePart.getCurSharedRef() != null) {
                    partParent = newActivePart.getCurSharedRef().getParent();
                }
                while (partParent != null && partParent instanceof MPartSashContainer) {
                    partParent = partParent.getParent();
                }
                if (partParent instanceof MCompositePart) {
                    partParent = partParent.getParent();
                }
                MPartStack pStack = (MPartStack)(partParent instanceof MPartStack ? partParent : null);
                EModelService ms = (EModelService)newActivePart.getContext().get(EModelService.class);
                ArrayList<String> tags = new ArrayList<String>();
                tags.add("active");
                List activeElements = ms.findElements((MUIElement)ms.getTopLevelWindowFor((MUIElement)newActivePart), null, MUIElement.class, tags);
                for (MUIElement element : activeElements) {
                    if (element instanceof MPartStack && element != pStack) {
                        StackRenderer.this.styleElement(element, false);
                        continue;
                    }
                    if (!(element instanceof MPart) || element == newActivePart) continue;
                    StackRenderer.this.styleElement(element, false);
                }
                if (pStack != null) {
                    StackRenderer.this.styleElement((MUIElement)pStack, true);
                }
                StackRenderer.this.styleElement((MUIElement)newActivePart, true);
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/activate", this.stylingHandler);
        this.tabStateHandler = new TabStateHandler();
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/application/ApplicationElement/tags/*", this.tabStateHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this.tabStateHandler);
    }

    protected void updateTab(CTabItem cti, MPart part, String attName, Object newValue) {
        if ("label".equals(attName)) {
            String newName = (String)newValue;
            cti.setText(this.getLabel((MUILabel)part, newName));
        } else if ("iconURI".equals(attName)) {
            cti.setImage(this.getImage((MUILabel)part));
        } else if ("tooltip".equals(attName)) {
            String newTTip = (String)newValue;
            cti.setToolTipText(this.getToolTip(newTTip));
        } else if ("dirty".equals(attName)) {
            boolean hasAsterisk;
            Boolean dirtyState = (Boolean)newValue;
            String text = cti.getText();
            boolean bl = hasAsterisk = text.length() > 0 && text.charAt(0) == '*';
            if (dirtyState.booleanValue()) {
                if (!hasAsterisk) {
                    cti.setText(String.valueOf('*') + text);
                }
            } else if (hasAsterisk) {
                cti.setText(text.substring(1));
            }
        }
    }

    @PreDestroy
    public void contextDisposed() {
        super.contextDisposed(this.eventBroker);
        this.eventBroker.unsubscribe(this.itemUpdater);
        this.eventBroker.unsubscribe(this.dirtyUpdater);
        this.eventBroker.unsubscribe(this.viewMenuUpdater);
        this.eventBroker.unsubscribe(this.childrenHandler);
        this.eventBroker.unsubscribe(this.stylingHandler);
        this.eventBroker.unsubscribe(this.tabStateHandler);
    }

    private String getLabel(MUILabel itemPart, String newName) {
        newName = newName == null ? "" : LegacyActionTools.escapeMnemonics((String)newName);
        if (itemPart instanceof MDirtyable && ((MDirtyable)itemPart).isDirty()) {
            newName = String.valueOf('*') + newName;
        }
        return newName;
    }

    private String getToolTip(String newToolTip) {
        return newToolTip == null || newToolTip.length() == 0 ? null : LegacyActionTools.escapeMnemonics((String)newToolTip);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MPartStack) || !(parent instanceof Composite)) {
            return null;
        }
        Composite parentComposite = (Composite)parent;
        if (element.getElementId() == null || element.getElementId().length() == 0) {
            String generatedId = "PartStack@" + Integer.toHexString(element.hashCode());
            element.setElementId(generatedId);
        }
        CTabFolder ctf = new CTabFolder(parentComposite, 2048);
        ctf.setMRUVisible(this.getInitialMRUValue((Control)ctf));
        int location = this.modelService.getElementLocation(element);
        if ((location & 8) != 0) {
            ctf.setMinimumCharacters(MIN_EDITOR_CHARS);
            ctf.setUnselectedCloseVisible(true);
        } else {
            ctf.setMinimumCharacters(MIN_VIEW_CHARS);
            ctf.setUnselectedCloseVisible(false);
        }
        this.bindWidget(element, ctf);
        this.addTopRight(ctf);
        return ctf;
    }

    private boolean getInitialMRUValue(Control control) {
        boolean result = false;
        CSSRenderingUtils util = (CSSRenderingUtils)this.context.get(CSSRenderingUtils.class);
        if (util == null) {
            return result;
        }
        CSSValue value = util.getCSSValue(control, "MPartStack", "swt-mru-visible");
        if (value == null) {
            value = util.getCSSValue(control, "MPartStack", "mru-visible");
        }
        if (value == null) {
            return result;
        }
        return Boolean.parseBoolean(value.getCssText());
    }

    private void addTopRight(CTabFolder ctf) {
        Composite trComp = new Composite((Composite)ctf, 0);
        trComp.setBackground(Display.getCurrent().getSystemColor(14));
        RowLayout rl = new RowLayout();
        trComp.setLayout((Layout)rl);
        rl.marginLeft = 0;
        rl.marginRight = 0;
        rl.marginTop = 0;
        rl.marginBottom = 0;
        ctf.setTopRight((Control)trComp, 131136);
        trComp.setVisible(false);
        ToolBar menuTB = new ToolBar(trComp, 0x820000);
        menuTB.setData((Object)TAG_VIEW_MENU);
        RowData rd = new RowData();
        menuTB.setLayoutData((Object)rd);
        ToolItem ti = new ToolItem(menuTB, 8);
        ti.setImage(this.getViewMenuImage());
        ti.setHotImage(null);
        ti.setToolTipText(SWTRenderersMessages.viewMenu);
        rd.exclude = true;
        menuTB.setVisible(false);
        ti.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StackRenderer.this.showMenu((ToolItem)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StackRenderer.this.showMenu((ToolItem)e.widget);
            }
        });
        menuTB.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID != -1) {
                    ToolItem item;
                    Accessible accessible = (Accessible)e.getSource();
                    ToolBar toolBar = (ToolBar)accessible.getControl();
                    if (e.childID >= 0 && e.childID < toolBar.getItemCount() && (item = toolBar.getItem(e.childID)) != null) {
                        e.result = item.getToolTipText();
                    }
                }
            }
        });
        trComp.pack();
    }

    public void adjustTopRight(CTabFolder ctf) {
        if (this.adjusting) {
            return;
        }
        this.adjusting = true;
        try {
            MPartStack stack = (MPartStack)ctf.getData("modelElement");
            MUIElement element = stack.getSelectedElement();
            MPart curPart = (MPart)ctf.getTopRight().getData("thePart");
            MPart part = null;
            if (element != null) {
                part = (MPart)(element instanceof MPart ? element : ((MPlaceholder)element).getRef());
            }
            if (part != curPart && curPart != null && curPart.getToolbar() != null) {
                curPart.getToolbar().setVisible(false);
            }
            Composite trComp = (Composite)ctf.getTopRight();
            Control[] kids = trComp.getChildren();
            boolean needsTB = part != null && part.getToolbar() != null && part.getToolbar().isToBeRendered();
            MMenu viewMenu = StackRenderer.getViewMenu(part);
            boolean needsMenu = viewMenu != null && this.hasVisibleMenuItems(viewMenu, part);
            ToolBar menuTB = (ToolBar)kids[kids.length - 1];
            RowData rd = (RowData)menuTB.getLayoutData();
            if (needsMenu) {
                menuTB.getItem(0).setData("thePart", (Object)part);
                menuTB.moveBelow(null);
                menuTB.pack();
                rd.exclude = false;
                menuTB.setVisible(true);
            } else {
                menuTB.getItem(0).setData("thePart", null);
                rd.exclude = true;
                menuTB.setVisible(false);
            }
            ToolBar newViewTB = null;
            if (needsTB) {
                part.getToolbar().setVisible(true);
                newViewTB = (ToolBar)this.renderer.createGui((MUIElement)part.getToolbar(), (Object)ctf.getTopRight(), part.getContext());
                if (newViewTB == null) {
                    this.adjusting = false;
                    return;
                }
                newViewTB.moveAbove(null);
                newViewTB.pack();
            }
            if (needsMenu || needsTB) {
                ctf.getTopRight().setData("thePart", (Object)part);
                ctf.getTopRight().pack(true);
                ctf.getTopRight().setVisible(true);
            } else {
                ctf.getTopRight().setData("thePart", null);
                ctf.getTopRight().setVisible(false);
            }
            trComp.pack();
        }
        finally {
            this.adjusting = false;
        }
    }

    @Override
    protected void createTab(MElementContainer<MUIElement> stack, MUIElement element) {
        Control ctrl;
        MPart part = null;
        if (element instanceof MPart) {
            part = (MPart)element;
        } else if (element instanceof MPlaceholder) {
            part = (MPart)((MPlaceholder)element).getRef();
            part.setCurSharedRef((MPlaceholder)element);
        }
        CTabFolder ctf = (CTabFolder)stack.getWidget();
        CTabItem cti = this.findItemForPart(element, stack);
        if (cti != null) {
            if (element.getWidget() != null && cti.getControl() != element.getWidget()) {
                cti.setControl((Control)element.getWidget());
            }
            return;
        }
        int createFlags = 0;
        if (part != null && this.isClosable(part)) {
            createFlags |= 0x40;
        }
        int index = Math.min(this.calcIndexFor(stack, element), ctf.getItemCount());
        cti = new CTabItem(ctf, createFlags, index);
        cti.setData("modelElement", (Object)element);
        cti.setText(this.getLabel((MUILabel)part, part.getLocalizedLabel()));
        cti.setImage(this.getImage((MUILabel)part));
        String toolTip = this.getToolTip((MUILabel)part);
        if (toolTip == null) {
            toolTip = part.getLocalizedTooltip();
        }
        cti.setToolTipText(this.getToolTip(toolTip));
        if (element.getWidget() != null && (ctrl = (Control)element.getWidget()).getParent() == ctf) {
            cti.setControl((Control)element.getWidget());
        }
    }

    private int calcIndexFor(MElementContainer<MUIElement> stack, MUIElement part) {
        int index = 0;
        for (MUIElement mPart : stack.getChildren()) {
            if (mPart == part) {
                return index;
            }
            if (!mPart.isToBeRendered() || !mPart.isVisible()) continue;
            ++index;
        }
        return index;
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        if (!(parentElement instanceof MPartStack) || !(element instanceof MStackElement)) {
            return;
        }
        this.createTab(parentElement, element);
    }

    private CTabItem findItemForPart(MUIElement element, MElementContainer<MUIElement> stack) {
        CTabFolder ctf;
        if (stack == null) {
            stack = element.getParent();
        }
        if ((ctf = (CTabFolder)stack.getWidget()) == null || ctf.isDisposed()) {
            return null;
        }
        CTabItem[] items = ctf.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData("modelElement") == element) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public CTabItem findItemForPart(MPart part) {
        CTabItem cti;
        if (!part.isToBeRendered()) {
            return null;
        }
        if (part.getParent() != null && part.getParent().getRenderer() == this && (cti = this.findItemForPart((MUIElement)part, (MElementContainer<MUIElement>)part.getParent())) != null) {
            return cti;
        }
        MWindow win = this.modelService.getTopLevelWindowFor((MUIElement)part);
        if (win == null) {
            return null;
        }
        List refs = this.modelService.findElements((MUIElement)win, null, MPlaceholder.class, null);
        if (refs != null) {
            for (MPlaceholder ref : refs) {
                CTabItem cti2;
                MElementContainer refParent;
                if (ref.getRef() != part || (refParent = ref.getParent()) == null || !(refParent.getRenderer() instanceof StackRenderer) || (cti2 = this.findItemForPart((MUIElement)ref, (MElementContainer<MUIElement>)refParent)) == null) continue;
                return cti2;
            }
        }
        return null;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        CTabFolder ctf = (CTabFolder)parentElement.getWidget();
        if (ctf == null) {
            return;
        }
        CTabItem cti = this.findItemForPart(child, parentElement);
        if (cti == ctf.getSelection() && ctf.getItemCount() == 1) {
            this.adjustTopRight(ctf);
        }
        if (cti != null && !cti.isDisposed()) {
            cti.setControl(null);
            cti.dispose();
        }
    }

    @Override
    public void hookControllerLogic(final MUIElement me) {
        super.hookControllerLogic(me);
        if (!(me instanceof MElementContainer)) {
            return;
        }
        final MElementContainer stack = (MElementContainer)me;
        final CTabFolder ctf = (CTabFolder)me.getWidget();
        ctf.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 64 || e.detail == 32) {
                    me.getTransientData().put(StackRenderer.INHIBIT_FOCUS, true);
                } else if (e.detail == 4) {
                    me.getTransientData().remove(StackRenderer.INHIBIT_FOCUS);
                    CTabItem cti = ctf.getSelection();
                    if (cti != null) {
                        MUIElement stackElement = (MUIElement)cti.getData("modelElement");
                        if (stackElement instanceof MPlaceholder) {
                            stackElement = ((MPlaceholder)stackElement).getRef();
                        }
                        if (stackElement instanceof MPart && ctf.isFocusControl()) {
                            MPart thePart = (MPart)stackElement;
                            StackRenderer.this.renderer.focusGui((MUIElement)thePart);
                        }
                    }
                }
            }
        });
        ctf.addListener(26, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                if (event.detail == 3) {
                    CTabFolder ctf = (CTabFolder)event.widget;
                    if (ctf.getSelection() == null) {
                        return;
                    }
                    Point cp = event.display.getCursorLocation();
                    CTabItem overItem = ctf.getItem(cp = event.display.map(null, (Control)ctf, cp));
                    if (overItem == null || overItem == ctf.getSelection()) {
                        MUIElement uiElement = (MUIElement)ctf.getSelection().getData("modelElement");
                        if (uiElement instanceof MPlaceholder) {
                            uiElement = ((MPlaceholder)uiElement).getRef();
                        }
                        if (uiElement instanceof MPart) {
                            StackRenderer.this.activate((MPart)uiElement);
                        }
                    }
                }
            }
        });
        ctf.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (StackRenderer.this.ignoreTabSelChanges) {
                    return;
                }
                MUIElement ele = (MUIElement)e.item.getData("modelElement");
                ele.getParent().setSelectedElement(ele);
                if (ele instanceof MPlaceholder) {
                    ele = ((MPlaceholder)ele).getRef();
                }
                if (ele instanceof MPart) {
                    StackRenderer.this.activate((MPart)ele);
                }
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Control ctrl;
                MUIElement ele;
                CTabItem item = ctf.getSelection();
                if (item != null && (ele = (MUIElement)item.getData("modelElement")).getParent().getSelectedElement() == ele && (ctrl = (Control)ele.getWidget()) != null) {
                    ctrl.setFocus();
                }
            }

            public void mouseUp(MouseEvent e) {
                CTabItem item = ctf.getItem(new Point(e.x, e.y));
                if (item != null && e.button == 2) {
                    StackRenderer.this.closePart((Widget)item, false);
                }
                if (e.button == 1) {
                    Control ctrl;
                    MUIElement ele;
                    Rectangle clientArea;
                    if (item == null && !(clientArea = ctf.getClientArea()).contains(e.x, e.y)) {
                        item = ctf.getSelection();
                    }
                    if (item != null && (ele = (MUIElement)item.getData("modelElement")).getParent().getSelectedElement() == ele && (ctrl = (Control)ele.getWidget()) != null) {
                        ctrl.setFocus();
                    }
                }
            }
        };
        ctf.addMouseListener((MouseListener)mouseListener);
        CTabFolder2Adapter closeListener = new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                event.doit = StackRenderer.this.closePart(event.item, true);
            }

            public void showList(CTabFolderEvent event) {
                event.doit = false;
                StackRenderer.this.showAvailableItems(stack, ctf);
            }
        };
        ctf.addCTabFolder2Listener((CTabFolder2Listener)closeListener);
        ctf.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                Rectangle clientArea;
                Point absolutePoint = new Point(e.x, e.y);
                Point relativePoint = ctf.getDisplay().map(null, (Control)ctf, absolutePoint);
                CTabItem eventTabItem = ctf.getItem(relativePoint);
                if (eventTabItem == null && !(clientArea = ctf.getClientArea()).contains(relativePoint)) {
                    eventTabItem = ctf.getSelection();
                }
                if (eventTabItem != null) {
                    MUIElement uiElement = (MUIElement)eventTabItem.getData("modelElement");
                    MPart tabPart = (MPart)(uiElement instanceof MPart ? uiElement : ((MPlaceholder)uiElement).getRef());
                    StackRenderer.this.openMenuFor(tabPart, ctf, absolutePoint);
                }
            }
        });
    }

    public void showAvailableItems(MElementContainer<?> stack, CTabFolder ctf) {
        IEclipseContext ctxt = this.getContext((MUIElement)stack);
        final BasicPartList editorList = new BasicPartList(ctf.getShell(), 16384, 768, (EPartService)ctxt.get(EPartService.class), stack, this, (ISWTResourceUtilities)ctxt.get(IResourceUtilities.class), this.getInitialMRUValue((Control)ctf));
        editorList.setInput();
        Point size = editorList.computeSizeHint();
        editorList.setSize(size.x, size.y);
        Point location = ctf.toDisplay(this.getChevronLocation(ctf));
        Monitor mon = ctf.getMonitor();
        Rectangle bounds = mon.getClientArea();
        if (location.x + size.x > bounds.x + bounds.width) {
            location.x = bounds.x + bounds.width - size.x;
        }
        if (location.y + size.y > bounds.y + bounds.height) {
            location.y = bounds.y + bounds.height - size.y;
        }
        editorList.setLocation(location);
        editorList.setVisible(true);
        editorList.setFocus();
        editorList.getShell().addListener(27, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                editorList.getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        editorList.dispose();
                    }
                });
            }
        });
    }

    private Point getChevronLocation(CTabFolder tabFolder) {
        int numItems = tabFolder.getItemCount();
        CTabItem item = null;
        int i = 0;
        while (i < numItems) {
            CTabItem tempItem = tabFolder.getItem(i);
            if (tempItem.isShowing()) {
                item = tempItem;
            }
            ++i;
        }
        if (item == null) {
            return new Point(0, 0);
        }
        Rectangle itemBounds = item.getBounds();
        int x = itemBounds.x + itemBounds.width;
        int y = itemBounds.y + itemBounds.height;
        return new Point(x, y);
    }

    private boolean closePart(Widget widget, boolean check) {
        MUIElement uiElement = (MUIElement)widget.getData("modelElement");
        MPart part = (MPart)(uiElement instanceof MPart ? uiElement : ((MPlaceholder)uiElement).getRef());
        if (!check && !this.isClosable(part)) {
            return false;
        }
        IEclipseContext partContext = part.getContext();
        IEclipseContext parentContext = this.getContextForParent((MUIElement)part);
        IEclipseContext context = partContext == null ? parentContext : partContext;
        EPartService partService = (EPartService)context.get(EPartService.class.getName());
        if (partService.savePart(part, true)) {
            partService.hidePart(part);
            return true;
        }
        return false;
    }

    @Override
    protected void showTab(MUIElement element) {
        Control ctrl;
        super.showTab(element);
        if (!element.isVisible()) {
            return;
        }
        CTabFolder ctf = (CTabFolder)this.getParentWidget(element);
        CTabItem cti = this.findItemForPart(element, null);
        if (cti == null) {
            this.createTab((MElementContainer<MUIElement>)element.getParent(), element);
            cti = this.findItemForPart(element, (MElementContainer<MUIElement>)element.getParent());
        }
        if ((ctrl = (Control)element.getWidget()) != null && ctrl.getParent() != ctf) {
            ctrl.setParent((Composite)ctf);
            cti.setControl(ctrl);
        } else if (element.getWidget() == null) {
            Control tabCtrl = (Control)this.renderer.createGui(element);
            cti.setControl(tabCtrl);
        }
        this.ignoreTabSelChanges = true;
        ctf.setSelection(cti);
        this.ignoreTabSelChanges = false;
        this.adjustTopRight(ctf);
    }

    protected void showMenu(ToolItem item) {
        MPart part = (MPart)item.getData("thePart");
        Control ctrl = (Control)part.getWidget();
        MMenu menuModel = StackRenderer.getViewMenu(part);
        if (menuModel == null || !menuModel.isToBeRendered()) {
            return;
        }
        final Menu swtMenu = (Menu)this.renderer.createGui((MUIElement)menuModel, (Object)ctrl.getShell(), part.getContext());
        if (swtMenu == null) {
            return;
        }
        ctrl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!swtMenu.isDisposed()) {
                    swtMenu.dispose();
                }
            }
        });
        Rectangle ib = item.getBounds();
        Point displayAt = item.getParent().toDisplay(ib.x, ib.y + ib.height);
        swtMenu.setLocation(displayAt);
        swtMenu.setVisible(true);
        Display display = Display.getCurrent();
        while (!swtMenu.isDisposed() && swtMenu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!swtMenu.isDisposed() && !(swtMenu.getData() instanceof MenuManager)) {
            swtMenu.dispose();
        }
    }

    private Image getViewMenuImage() {
        if (this.viewMenuImage == null) {
            Display d = Display.getCurrent();
            Image viewMenu = new Image((Device)d, 16, 16);
            Image viewMenuMask = new Image((Device)d, 16, 16);
            Display display = Display.getCurrent();
            GC gc = new GC((Drawable)viewMenu);
            GC maskgc = new GC((Drawable)viewMenuMask);
            gc.setForeground(display.getSystemColor(17));
            gc.setBackground(display.getSystemColor(25));
            int[] shapeArray = new int[]{6, 1, 15, 1, 11, 5, 10, 5};
            gc.fillPolygon(shapeArray);
            gc.drawPolygon(shapeArray);
            Color black = display.getSystemColor(2);
            Color white = display.getSystemColor(1);
            maskgc.setBackground(black);
            maskgc.fillRectangle(0, 0, 16, 16);
            maskgc.setBackground(white);
            maskgc.setForeground(white);
            maskgc.fillPolygon(shapeArray);
            maskgc.drawPolygon(shapeArray);
            gc.dispose();
            maskgc.dispose();
            ImageData data = viewMenu.getImageData();
            data.transparentPixel = data.getPixel(0, 0);
            this.viewMenuImage = new Image((Device)d, viewMenu.getImageData(), viewMenuMask.getImageData());
            viewMenu.dispose();
            viewMenuMask.dispose();
        }
        return this.viewMenuImage;
    }

    private void openMenuFor(MPart part, CTabFolder folder, Point point) {
        Menu tabMenu = this.createTabMenu(folder, part);
        tabMenu.setData(STACK_SELECTED_PART, (Object)part);
        tabMenu.setLocation(point.x, point.y);
        tabMenu.setVisible(true);
    }

    private boolean isClosable(MPart part) {
        if (part.getCurSharedRef() != null) {
            return !part.getCurSharedRef().getTags().contains("NoClose");
        }
        return part.isCloseable();
    }

    private Menu createTabMenu(CTabFolder folder, MPart part) {
        MElementContainer<MUIElement> parent;
        Shell shell = folder.getShell();
        Menu cachedMenu = (Menu)shell.getData(SHELL_CLOSE_EDITORS_MENU);
        if (cachedMenu == null) {
            cachedMenu = new Menu((Control)folder);
            shell.setData(SHELL_CLOSE_EDITORS_MENU, (Object)cachedMenu);
        } else {
            MenuItem[] menuItemArray = cachedMenu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                item.dispose();
                ++n2;
            }
        }
        final Menu menu = cachedMenu;
        int closeableElements = 0;
        if (this.isClosable(part)) {
            MenuItem menuItemClose = new MenuItem(menu, 0);
            menuItemClose.setText(SWTRenderersMessages.menuClose);
            menuItemClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MPart part = (MPart)menu.getData(StackRenderer.STACK_SELECTED_PART);
                    EPartService partService = (EPartService)StackRenderer.this.getContextForParent((MUIElement)part).get(EPartService.class);
                    if (partService.savePart(part, true)) {
                        partService.hidePart(part);
                    }
                }
            });
            ++closeableElements;
        }
        if ((parent = this.getParent(part)) != null && (closeableElements += this.getCloseableSiblingParts(part).size()) >= 2) {
            MenuItem menuItemOthers = new MenuItem(menu, 0);
            menuItemOthers.setText(SWTRenderersMessages.menuCloseOthers);
            menuItemOthers.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MPart part = (MPart)menu.getData(StackRenderer.STACK_SELECTED_PART);
                    StackRenderer.this.closeSiblingParts(part, true);
                }
            });
            MenuItem menuItemAll = new MenuItem(menu, 0);
            menuItemAll.setText(SWTRenderersMessages.menuCloseAll);
            menuItemAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MPart part = (MPart)menu.getData(StackRenderer.STACK_SELECTED_PART);
                    StackRenderer.this.closeSiblingParts(part, false);
                }
            });
        }
        return menu;
    }

    private MElementContainer<MUIElement> getParent(MPart part) {
        MElementContainer parent = part.getParent();
        if (parent == null) {
            MPlaceholder placeholder = part.getCurSharedRef();
            return placeholder == null ? null : placeholder.getParent();
        }
        return parent;
    }

    private List<MPart> getCloseableSiblingParts(MPart part) {
        MElementContainer<MUIElement> container = this.getParent(part);
        ArrayList<MPart> closeableSiblings = new ArrayList<MPart>();
        if (container == null) {
            return closeableSiblings;
        }
        List children = container.getChildren();
        for (MUIElement child : children) {
            MUIElement otherItem;
            if (!child.isToBeRendered()) continue;
            MPart otherPart = null;
            if (child instanceof MPart) {
                otherPart = (MPart)child;
            } else if (child instanceof MPlaceholder && (otherItem = ((MPlaceholder)child).getRef()) instanceof MPart) {
                otherPart = (MPart)otherItem;
            }
            if (otherPart == null || part.equals(otherPart) || !otherPart.isToBeRendered() || !this.isClosable(otherPart)) continue;
            closeableSiblings.add(otherPart);
        }
        return closeableSiblings;
    }

    private void closeSiblingParts(MPart part, boolean skipThisPart) {
        MUIElement selectedElement;
        MElementContainer<MUIElement> container = this.getParent(part);
        if (container == null) {
            return;
        }
        List<MPart> others = this.getCloseableSiblingParts(part);
        if (!skipThisPart && part.isToBeRendered() && this.isClosable(part)) {
            others.add(part);
        }
        if (others.remove(selectedElement = container.getSelectedElement())) {
            others.add((MPart)selectedElement);
        } else if (selectedElement instanceof MPlaceholder && others.remove(selectedElement = ((MPlaceholder)selectedElement).getRef())) {
            others.add((MPart)selectedElement);
        }
        EPartService partService = (EPartService)this.getContextForParent((MUIElement)part).get(EPartService.class);
        for (MPart otherPart : others) {
            if (!partService.savePart(otherPart, true)) continue;
            partService.hidePart(otherPart);
        }
    }

    public static MMenu getViewMenu(MPart part) {
        if (part == null || part.getMenus() == null) {
            return null;
        }
        for (MMenu menu : part.getMenus()) {
            if (!menu.getTags().contains(TAG_VIEW_MENU)) continue;
            return menu;
        }
        return null;
    }

    private boolean hasVisibleMenuItems(MMenu viewMenu, MPart part) {
        Menu menu;
        MenuManager manager;
        if (!viewMenu.isToBeRendered() || !viewMenu.isVisible()) {
            return false;
        }
        for (MMenuElement menuElement : viewMenu.getChildren()) {
            IContributionItem item;
            if (!menuElement.isToBeRendered() || !menuElement.isVisible()) continue;
            if (menuElement instanceof MOpaqueMenuItem) {
                item = (IContributionItem)((MOpaqueMenuItem)menuElement).getOpaqueItem();
                if (item == null || !item.isVisible()) continue;
                return true;
            }
            if (menuElement instanceof MOpaqueMenuSeparator) {
                item = (IContributionItem)((MOpaqueMenuSeparator)menuElement).getOpaqueItem();
                if (item == null || !item.isVisible()) continue;
                return true;
            }
            return true;
        }
        Object menuRenderer = viewMenu.getRenderer();
        if (menuRenderer instanceof MenuManagerRenderer && (manager = ((MenuManagerRenderer)((Object)menuRenderer)).getManager(viewMenu)) != null && manager.isVisible()) {
            return true;
        }
        Control control = (Control)part.getWidget();
        if (control != null && (menu = (Menu)this.renderer.createGui((MUIElement)viewMenu, (Object)control.getShell(), part.getContext())) != null) {
            MenuManagerRenderer menuManagerRenderer;
            MenuManager manager2;
            menuRenderer = viewMenu.getRenderer();
            if (menuRenderer instanceof MenuManagerRenderer && (manager2 = (menuManagerRenderer = (MenuManagerRenderer)((Object)menuRenderer)).getManager(viewMenu)) != null) {
                manager2.markDirty();
            }
            return menu.getItemCount() != 0;
        }
        return false;
    }

    public class TabStateHandler
    implements EventHandler {
        public void handleEvent(Event event) {
            Object element = event.getProperty("ChangedElement");
            Object newValue = event.getProperty("NewValue");
            Object oldValue = event.getProperty("OldValue");
            if (!this.validateElement(element) || !this.validateValues(oldValue, newValue)) {
                return;
            }
            MPart part = newValue instanceof MPlaceholder ? (MPart)((MPlaceholder)newValue).getRef() : (MPart)element;
            CTabItem cti = StackRenderer.this.findItemForPart(part);
            if (cti == null) {
                return;
            }
            if ("contentChange".equals(newValue)) {
                part.getTags().remove("contentChange");
                if (cti != cti.getParent().getSelection()) {
                    part.getTags().add("highlighted");
                }
            } else if (newValue instanceof MPlaceholder && part.getTags().contains("highlighted")) {
                part.getTags().remove("highlighted");
            }
            StackRenderer.this.setCSSInfo((MUIElement)part, cti);
            StackRenderer.this.reapplyStyles((Widget)cti.getParent());
        }

        public boolean validateElement(Object element) {
            return element instanceof MPart || element instanceof MPartStack;
        }

        public boolean validateValues(Object oldValue, Object newValue) {
            return newValue instanceof MPlaceholder || this.isTagAdded("busy", oldValue, newValue) || this.isTagRemoved("busy", oldValue, newValue) || this.isTagAdded("contentChange", oldValue, newValue);
        }

        private boolean isTagAdded(String tagName, Object oldValue, Object newValue) {
            return oldValue == null && tagName.equals(newValue);
        }

        private boolean isTagRemoved(String tagName, Object oldValue, Object newValue) {
            return newValue == null && tagName.equals(oldValue);
        }
    }
}

