/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.tweaklets.PreferencePageEnhancer;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.internal.util.PrefUtil;

public class ViewsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String E4_THEME_EXTENSION_POINT = "org.eclipse.e4.ui.css.swt.theme";
    private IThemeEngine engine;
    private ComboViewer themeIdCombo;
    private ITheme currentTheme;
    private String defaultTheme;
    private Button enableAnimations;
    private Button useColoredLabels;
    private Text colorsAndFontsThemeDescriptionText;
    private ComboViewer colorsAndFontsThemeCombo;
    private ColorsAndFontsTheme currentColorsAndFontsTheme;
    private Map<String, String> themeAssociations;

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 0).setText(WorkbenchMessages.ViewsPreferencePage_Theme);
        this.themeIdCombo = new ComboViewer(comp, 8);
        this.themeIdCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ITheme)element).getLabel();
            }
        });
        this.themeIdCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.themeIdCombo.setInput((Object)this.engine.getThemes());
        this.themeIdCombo.getControl().setLayoutData((Object)new GridData(768));
        this.currentTheme = this.engine.getActiveTheme();
        if (this.currentTheme != null) {
            this.themeIdCombo.setSelection((ISelection)new StructuredSelection((Object)this.currentTheme));
        }
        this.themeIdCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITheme selection = ViewsPreferencePage.this.getSelectedTheme();
                ViewsPreferencePage.this.engine.setTheme(selection, false);
                try {
                    ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).setSelection(selection);
                }
                catch (SWTException e) {
                    WorkbenchPlugin.log("Failed to set CSS preferences", e);
                }
                ViewsPreferencePage.this.selectColorsAndFontsTheme(ViewsPreferencePage.this.getColorAndFontThemeIdByThemeId(selection.getId()));
            }
        });
        this.currentColorsAndFontsTheme = this.getCurrentColorsAndFontsTheme();
        this.createColorsAndFontsThemeCombo(comp);
        this.createColorsAndFontsThemeDescriptionText(comp);
        this.createEnableAnimationsPref(comp);
        this.createColoredLabelsPref(comp);
        ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).setSelection(this.currentTheme);
        ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).createContents(comp);
        if (this.currentTheme != null) {
            String colorsAndFontsThemeId = this.getColorAndFontThemeIdByThemeId(this.currentTheme.getId());
            if (colorsAndFontsThemeId != null && !this.currentColorsAndFontsTheme.getId().equals(colorsAndFontsThemeId)) {
                colorsAndFontsThemeId = this.currentColorsAndFontsTheme.getId();
            }
            this.selectColorsAndFontsTheme(colorsAndFontsThemeId);
        }
        return comp;
    }

    private void createColoredLabelsPref(Composite composite) {
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.useColoredLabels = this.createCheckButton(composite, WorkbenchMessages.ViewsPreference_useColoredLabels, apiStore.getBoolean("USE_COLORED_LABELS"));
    }

    private Button createCheckButton(Composite composite, String text, boolean selection) {
        Button button = new Button(composite, 32);
        GridData data = new GridData(1, 0x1000000, false, false, 2, 1);
        button.setLayoutData((Object)data);
        button.setText(text);
        button.setSelection(selection);
        return button;
    }

    protected void createEnableAnimationsPref(Composite composite) {
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.enableAnimations = this.createCheckButton(composite, WorkbenchMessages.ViewsPreference_enableAnimations, apiStore.getBoolean("ENABLE_ANIMATIONS"));
    }

    private ITheme getSelectedTheme() {
        return (ITheme)((IStructuredSelection)this.themeIdCombo.getSelection()).getFirstElement();
    }

    @Override
    public void init(IWorkbench workbench) {
        MApplication application = (MApplication)workbench.getService(MApplication.class);
        IEclipseContext context = application.getContext();
        this.defaultTheme = (String)context.get("cssTheme");
        this.engine = (IThemeEngine)context.get(IThemeEngine.class);
    }

    public boolean performOk() {
        boolean colorsAndFontsThemeChanged;
        ITheme theme = this.getSelectedTheme();
        if (theme != null) {
            this.engine.setTheme(this.getSelectedTheme(), true);
        }
        boolean themeChanged = theme != null && !theme.equals(this.currentTheme);
        boolean bl = colorsAndFontsThemeChanged = !PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getId().equals(this.currentColorsAndFontsTheme.getId());
        if (themeChanged || colorsAndFontsThemeChanged) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)WorkbenchMessages.ThemeChangeWarningTitle, (String)WorkbenchMessages.ThemeChangeWarningText);
        }
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        apiStore.setValue("ENABLE_ANIMATIONS", this.enableAnimations.getSelection());
        apiStore.setValue("USE_COLORED_LABELS", this.useColoredLabels.getSelection());
        ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).performOK();
        return super.performOk();
    }

    private void setColorsAndFontsTheme(ColorsAndFontsTheme theme) {
        org.eclipse.ui.themes.ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        if (theme != null && !currentTheme.getId().equals(theme.getId())) {
            PlatformUI.getWorkbench().getThemeManager().setCurrentTheme(theme.getId());
        }
    }

    protected void performDefaults() {
        this.setColorsAndFontsTheme(this.currentColorsAndFontsTheme);
        ((PreferencePageEnhancer)Tweaklets.get(PreferencePageEnhancer.KEY)).performDefaults();
        this.engine.setTheme(this.defaultTheme, true);
        if (this.engine.getActiveTheme() != null) {
            this.themeIdCombo.setSelection((ISelection)new StructuredSelection((Object)this.engine.getActiveTheme()));
        }
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.enableAnimations.setSelection(apiStore.getDefaultBoolean("ENABLE_ANIMATIONS"));
        this.useColoredLabels.setSelection(apiStore.getDefaultBoolean("USE_COLORED_LABELS"));
        super.performDefaults();
    }

    public boolean performCancel() {
        this.setColorsAndFontsTheme(this.currentColorsAndFontsTheme);
        if (this.currentTheme != null) {
            this.engine.setTheme(this.currentTheme, false);
        }
        return super.performCancel();
    }

    protected void performApply() {
        ColorsAndFontsTheme colorsAndFontsTheme;
        super.performApply();
        ITheme theme = this.getSelectedTheme();
        if (theme != null) {
            this.currentTheme = theme;
        }
        if ((colorsAndFontsTheme = this.getSelectedColorsAndFontsTheme()) != null) {
            this.currentColorsAndFontsTheme = colorsAndFontsTheme;
        }
    }

    private void createColorsAndFontsThemeCombo(Composite composite) {
        new Label(composite, 0).setText(WorkbenchMessages.ViewsPreference_currentTheme);
        this.colorsAndFontsThemeCombo = new ComboViewer(composite, 8);
        this.colorsAndFontsThemeCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.colorsAndFontsThemeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ColorsAndFontsTheme)element).getLabel();
            }
        });
        this.colorsAndFontsThemeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.colorsAndFontsThemeCombo.setInput(this.getColorsAndFontsThemes());
        this.colorsAndFontsThemeCombo.getControl().setLayoutData((Object)new GridData(768));
        this.colorsAndFontsThemeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ColorsAndFontsTheme colorsAndFontsTheme = ViewsPreferencePage.this.getSelectedColorsAndFontsTheme();
                ViewsPreferencePage.this.refreshColorsAndFontsThemeDescriptionText(colorsAndFontsTheme);
                ViewsPreferencePage.this.setColorsAndFontsTheme(colorsAndFontsTheme);
            }
        });
    }

    private void createColorsAndFontsThemeDescriptionText(Composite parent) {
        new Label(parent, 0).setText(WorkbenchMessages.ViewsPreference_currentThemeDescription);
        this.colorsAndFontsThemeDescriptionText = new Text(parent, 2888);
        GridData layoutData = new GridData(4, 4, true, true);
        GC gc = new GC((Drawable)parent);
        layoutData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)2);
        gc.dispose();
        this.colorsAndFontsThemeDescriptionText.setLayoutData((Object)layoutData);
    }

    private void selectColorsAndFontsTheme(String colorAndFontThemeId) {
        if (colorAndFontThemeId == null) {
            colorAndFontThemeId = this.currentColorsAndFontsTheme.getId();
        }
        List colorsAndFontsThemes = (List)this.colorsAndFontsThemeCombo.getInput();
        int i = 0;
        while (i < colorsAndFontsThemes.size()) {
            if (((ColorsAndFontsTheme)colorsAndFontsThemes.get(i)).getId().equals(colorAndFontThemeId)) {
                StructuredSelection selection = new StructuredSelection(colorsAndFontsThemes.get(i));
                this.colorsAndFontsThemeCombo.setSelection((ISelection)selection);
                break;
            }
            ++i;
        }
    }

    private String getColorAndFontThemeIdByThemeId(String themeId) {
        String result;
        if (this.themeAssociations == null) {
            this.themeAssociations = this.createThemeAssociations();
        }
        if ((result = this.themeAssociations.get(themeId)) == null) {
            for (Map.Entry<String, String> entry : this.themeAssociations.entrySet()) {
                if (!themeId.startsWith(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return result;
    }

    private Map<String, String> createThemeAssociations() {
        HashMap<String, String> result = new HashMap<String, String>();
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(E4_THEME_EXTENSION_POINT);
        IExtension[] iExtensionArray = extPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension e = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if (ce.getName().equals("themeAssociation")) {
                    String themeId = ce.getAttribute("themeId");
                    String osVersion = ce.getAttribute("os_version");
                    result.put(osVersion != null ? String.valueOf(themeId) + osVersion : themeId, ce.getAttribute("colorAndFontId"));
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private List<ColorsAndFontsTheme> getColorsAndFontsThemes() {
        ArrayList<ColorsAndFontsTheme> result = new ArrayList<ColorsAndFontsTheme>();
        org.eclipse.ui.themes.ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        IThemeDescriptor[] descs = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes();
        String defaultThemeString = PlatformUI.getWorkbench().getThemeManager().getTheme("org.eclipse.ui.defaultTheme").getLabel();
        if (currentTheme.getId().equals("org.eclipse.ui.defaultTheme")) {
            defaultThemeString = NLS.bind((String)WorkbenchMessages.ViewsPreference_currentThemeFormat, (Object[])new Object[]{defaultThemeString});
        }
        result.add(new ColorsAndFontsTheme("org.eclipse.ui.defaultTheme", defaultThemeString));
        int i = 0;
        while (i < descs.length) {
            String themeString = descs[i].getName();
            if (descs[i].getId().equals(currentTheme.getId())) {
                themeString = NLS.bind((String)WorkbenchMessages.ViewsPreference_currentThemeFormat, (Object[])new Object[]{themeString});
            }
            result.add(new ColorsAndFontsTheme(descs[i].getId(), themeString));
            ++i;
        }
        return result;
    }

    private void refreshColorsAndFontsThemeDescriptionText(ColorsAndFontsTheme theme) {
        String description = "";
        IThemeDescriptor[] descs = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes();
        int i = 0;
        while (theme != null && description == null && i < descs.length) {
            if (descs[i].getId().equals(theme.getId())) {
                description = descs[i].getDescription();
            }
            ++i;
        }
        this.colorsAndFontsThemeDescriptionText.setText(description);
    }

    private ColorsAndFontsTheme getSelectedColorsAndFontsTheme() {
        return (ColorsAndFontsTheme)((IStructuredSelection)this.colorsAndFontsThemeCombo.getSelection()).getFirstElement();
    }

    private ColorsAndFontsTheme getCurrentColorsAndFontsTheme() {
        org.eclipse.ui.themes.ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        return new ColorsAndFontsTheme(theme.getId(), theme.getLabel());
    }

    private static class ColorsAndFontsTheme {
        private String label;
        private String id;

        public ColorsAndFontsTheme(String id, String label) {
            this.id = id;
            this.label = label;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

