/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.navigator.CommonViewer;

public class OpenFolderAsProjectAction
extends Action {
    private IFolder folder;
    private CommonViewer viewer;

    public OpenFolderAsProjectAction(IFolder folder, CommonViewer viewer) {
        super(WorkbenchNavigatorMessages.OpenProjectAction_OpenExistingProject);
        this.folder = folder;
        this.viewer = viewer;
        this.setDescription(WorkbenchNavigatorMessages.OpenProjectAction_OpenExistingProject_desc);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT"));
    }

    public void run() {
        try {
            ProjectDescription desc = new ProjectDescriptionReader().read(this.folder.getLocation().append(".project"));
            desc.setLocation(this.folder.getLocation());
            CreateProjectOperation operation = new CreateProjectOperation((IProjectDescription)desc, desc.getName());
            IStatus status = OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)operation, null, null);
            if (status.isOK()) {
                this.viewer.setSelection((ISelection)new StructuredSelection(operation.getAffectedObjects()));
            } else {
                WorkbenchNavigatorPlugin.getDefault().getLog().log(status);
            }
        }
        catch (Exception ex) {
            WorkbenchNavigatorPlugin.getDefault().getLog().log((IStatus)new Status(4, WorkbenchNavigatorPlugin.getDefault().getBundle().getSymbolicName(), ex.getMessage()));
        }
    }
}

