/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.E4PartWrapper;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;

public class SelectionService
implements ISelectionChangedListener,
ISelectionService {
    @Inject
    private IEclipseContext context;
    @Inject
    private MApplication application;
    private ESelectionService selectionService;
    @Inject
    @Optional
    @Named(value="org.eclipse.ui.IWorkbenchPage")
    private WorkbenchPage page;
    private IWorkbenchPart activePart;
    private ListenerList listeners = new ListenerList();
    private ListenerList postSelectionListeners = new ListenerList();
    private Map<String, Set<ISelectionListener>> targetedListeners = new HashMap<String, Set<ISelectionListener>>();
    private Map<String, Set<ISelectionListener>> targetedPostSelectionListeners = new HashMap<String, Set<ISelectionListener>>();
    private org.eclipse.e4.ui.workbench.modeling.ISelectionListener listener = new org.eclipse.e4.ui.workbench.modeling.ISelectionListener(){

        public void selectionChanged(MPart part, Object selection) {
            Object client;
            selection = SelectionService.createCompatibilitySelection(selection);
            SelectionService.this.context.set("selection", selection);
            IEclipseContext applicationContext = SelectionService.this.application.getContext();
            if (applicationContext.getActiveChild() == SelectionService.this.context) {
                SelectionService.this.application.getContext().set("selection", selection);
            }
            if ((client = part.getObject()) instanceof CompatibilityPart) {
                IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
                SelectionService.this.notifyListeners(part.getElementId(), workbenchPart, (ISelection)selection);
            }
        }
    };
    private org.eclipse.e4.ui.workbench.modeling.ISelectionListener postListener = new org.eclipse.e4.ui.workbench.modeling.ISelectionListener(){

        public void selectionChanged(MPart part, Object selection) {
            selection = SelectionService.createCompatibilitySelection(selection);
            Object client = part.getObject();
            if (client instanceof CompatibilityPart) {
                IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
                SelectionService.this.notifyPostSelectionListeners(part.getElementId(), workbenchPart, (ISelection)selection);
            }
        }
    };

    private static ISelection createCompatibilitySelection(Object selection) {
        if (selection instanceof ISelection) {
            return (ISelection)selection;
        }
        return selection == null ? StructuredSelection.EMPTY : new StructuredSelection(selection);
    }

    public void updateSelection(IWorkbenchPart activePart) {
        ISelectionProvider selectionProvider;
        if (activePart != null && (selectionProvider = activePart.getSite().getSelectionProvider()) != null) {
            ISelection selection = selectionProvider.getSelection();
            this.context.set("selection", (Object)selection);
            IEclipseContext applicationContext = this.application.getContext();
            if (applicationContext.getActiveChild() == this.context) {
                this.application.getContext().set("selection", (Object)selection);
            }
            this.notifyListeners(activePart.getSite().getId(), activePart, selection);
            this.notifyPostSelectionListeners(activePart.getSite().getId(), activePart, selection);
        }
    }

    @Inject
    void setPart(@Optional @Named(value="e4ActivePart") MPart part) {
        this.activePart = null;
        if (part != null) {
            Object client = part.getObject();
            if (client instanceof CompatibilityPart) {
                IWorkbenchPart workbenchPart;
                this.activePart = workbenchPart = ((CompatibilityPart)client).getPart();
            } else if (client != null && part.getTransientData().get("e4Wrapper") instanceof E4PartWrapper) {
                this.activePart = (IWorkbenchPart)part.getTransientData().get("e4Wrapper");
            }
        }
    }

    @Inject
    void setSelectionService(@Optional ESelectionService selectionService) {
        if (this.selectionService != null) {
            this.selectionService.removeSelectionListener(this.listener);
            this.selectionService.removePostSelectionListener(this.postListener);
        }
        if (selectionService != null) {
            selectionService.addSelectionListener(this.listener);
            selectionService.addPostSelectionListener(this.postListener);
            this.selectionService = selectionService;
        }
    }

    private void notifyListeners(String id, IWorkbenchPart workbenchPart, ISelection selection) {
        Set<ISelectionListener> listeners;
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (selection != null || listener instanceof INullSelectionListener) {
                ((ISelectionListener)listener).selectionChanged(workbenchPart, selection);
            }
            ++n2;
        }
        if (id != null && (listeners = this.targetedListeners.get(id)) != null) {
            for (ISelectionListener listener : listeners) {
                if (selection == null && !(listener instanceof INullSelectionListener)) continue;
                listener.selectionChanged(workbenchPart, selection);
            }
        }
    }

    private void notifyPostSelectionListeners(String id, IWorkbenchPart workbenchPart, ISelection selection) {
        Set<ISelectionListener> listeners;
        Object[] objectArray = this.postSelectionListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (selection != null || listener instanceof INullSelectionListener) {
                ((ISelectionListener)listener).selectionChanged(workbenchPart, selection);
            }
            ++n2;
        }
        if (id != null && (listeners = this.targetedPostSelectionListeners.get(id)) != null) {
            for (ISelectionListener listener : listeners) {
                if (selection == null && !(listener instanceof INullSelectionListener)) continue;
                listener.selectionChanged(workbenchPart, selection);
            }
        }
    }

    @Override
    public void addSelectionListener(ISelectionListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void addSelectionListener(String partId, ISelectionListener listener) {
        Set<ISelectionListener> listeners = this.targetedListeners.get(partId);
        if (listeners == null) {
            listeners = new HashSet<ISelectionListener>();
            this.targetedListeners.put(partId, listeners);
        }
        listeners.add(listener);
    }

    @Override
    public void addPostSelectionListener(ISelectionListener listener) {
        this.postSelectionListeners.add((Object)listener);
    }

    @Override
    public void addPostSelectionListener(String partId, ISelectionListener listener) {
        Set<ISelectionListener> listeners = this.targetedPostSelectionListeners.get(partId);
        if (listeners == null) {
            listeners = new HashSet<ISelectionListener>();
            this.targetedPostSelectionListeners.put(partId, listeners);
        }
        listeners.add(listener);
    }

    @Override
    public ISelection getSelection() {
        if (this.activePart != null) {
            ISelectionProvider selectionProvider = this.activePart.getSite().getSelectionProvider();
            return selectionProvider == null ? null : selectionProvider.getSelection();
        }
        Object selection = this.selectionService.getSelection();
        if (selection == null || selection instanceof ISelection) {
            return (ISelection)selection;
        }
        return new StructuredSelection(selection);
    }

    @Override
    public ISelection getSelection(String partId) {
        Object selection = this.selectionService.getSelection(partId);
        if (selection == null || selection instanceof ISelection) {
            return (ISelection)selection;
        }
        return new StructuredSelection(selection);
    }

    @Override
    public void removeSelectionListener(ISelectionListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void removeSelectionListener(String partId, ISelectionListener listener) {
        Set<ISelectionListener> listeners = this.targetedListeners.get(partId);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    @Override
    public void removePostSelectionListener(ISelectionListener listener) {
        this.postSelectionListeners.remove((Object)listener);
    }

    @Override
    public void removePostSelectionListener(String partId, ISelectionListener listener) {
        Set<ISelectionListener> listeners = this.targetedPostSelectionListeners.get(partId);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public void selectionChanged(SelectionChangedEvent e) {
        MPart part = this.page.findPart(this.activePart);
        ESelectionService selectionService = (ESelectionService)part.getContext().get(ESelectionService.class.getName());
        selectionService.setSelection((Object)e.getSelection());
    }
}

