/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.ui.wizards.ILocationGroup;
import org.eclipse.dltk.ui.wizards.IProjectWizard;
import org.eclipse.dltk.ui.wizards.ProjectCreator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.koneki.ldt.wizards.Messages;

public class LuaProjectCreator
extends ProjectCreator {
    private ILocationGroup locationGroup;

    public LuaProjectCreator(IProjectWizard owner, ILocationGroup locationGroup) {
        super(owner, locationGroup);
        this.locationGroup = locationGroup;
        this.addStep("finish", 0, (ProjectCreator.IProjectCreateStep)new CreateDefaultSourceFolderProjectCreateStep(), (IWizardPage)locationGroup);
    }

    protected List<IBuildpathEntry> getDefaultBuildpathEntries() {
        ArrayList<IBuildpathEntry> buildPath = new ArrayList<IBuildpathEntry>();
        if (!this.locationGroup.isExistingLocation()) {
            IFolder sourcefolder = this.getProject().getFolder("src");
            IBuildpathEntry newSourceEntry = DLTKCore.newSourceEntry((IPath)sourcefolder.getFullPath());
            buildPath.add(newSourceEntry);
        }
        return buildPath;
    }

    protected IBuildpathEntry[] initBuildpath(IProgressMonitor monitor) throws CoreException {
        ArrayList<IBuildpathEntry> entries = new ArrayList<IBuildpathEntry>(this.getDefaultBuildpathEntries());
        monitor.done();
        return entries.toArray(new IBuildpathEntry[entries.size()]);
    }

    private class CreateDefaultSourceFolderProjectCreateStep
    extends ProjectCreator.ProjectCreateStep {
        private CreateDefaultSourceFolderProjectCreateStep() {
        }

        public void execute(IProject project, IProgressMonitor monitor) throws CoreException, InterruptedException {
            monitor.beginTask(Messages.LuaProjectCreatorInitializingSourceFolder, 1);
            IFolder sourcefolder = project.getFolder("src");
            if (sourcefolder.exists() && !LuaProjectCreator.this.locationGroup.isExistingLocation()) {
                byte[] bytes = "local function main()\n\nend\nmain()\n".getBytes();
                IFile mainFile = sourcefolder.getFile("main.lua");
                mainFile.create((InputStream)new ByteArrayInputStream(bytes), false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            monitor.done();
        }
    }
}

