/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.MultipleInputDialog;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class StringVariablePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer variableTable;
    protected Button envAddButton;
    protected Button envEditButton;
    protected Button envRemoveButton;
    protected SimpleVariableContentProvider variableContentProvider = new SimpleVariableContentProvider();
    protected static final String NAME_LABEL = DebugPreferencesMessages.SimpleVariablePreferencePage_10;
    protected static final String VALUE_LABEL = DebugPreferencesMessages.SimpleVariablePreferencePage_11;
    protected static final String DESCRIPTION_LABEL = DebugPreferencesMessages.SimpleVariablePreferencePage_12;
    protected static final String STRING_VARIABLE_PREFERENCE_KEY = "StringVariablePreferencePage";
    protected static String[] variableTableColumnProperties = new String[]{"variable", "value", "description"};
    protected String[] variableTableColumnHeaders = new String[]{DebugPreferencesMessages.SimpleVariablePreferencePage_3, DebugPreferencesMessages.SimpleVariablePreferencePage_4, DebugPreferencesMessages.SimpleVariablePreferencePage_5, DebugPreferencesMessages.StringVariablePreferencePage_27};
    protected ColumnLayoutData[] variableTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(30), new ColumnWeightData(25), new ColumnWeightData(25), new ColumnWeightData(20)};

    public StringVariablePreferencePage() {
        this.setDescription(DebugPreferencesMessages.SimpleVariablePreferencePage_6);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.debug.ui.simple_variable_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setFont(font);
        this.createTable(composite);
        this.createButtons(composite);
        return composite;
    }

    private void createTable(Composite parent) {
        Font font = parent.getFont();
        Composite tableComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.widthHint = 400;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)gridData);
        tableComposite.setFont(font);
        this.variableTable = new TableViewer(tableComposite, 68354);
        Table table = this.variableTable.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(font);
        gridData = new GridData(1808);
        this.variableTable.getControl().setLayoutData((Object)gridData);
        this.variableTable.setContentProvider((IContentProvider)this.variableContentProvider);
        this.variableTable.setColumnProperties(variableTableColumnProperties);
        this.variableTable.addFilter((ViewerFilter)new VariableFilter());
        this.variableTable.setComparator(new ViewerComparator(){

            public int compare(Viewer iViewer, Object e1, Object e2) {
                if (e1 == null) {
                    return -1;
                }
                if (e2 == null) {
                    return 1;
                }
                return ((VariableWrapper)e1).getName().compareToIgnoreCase(((VariableWrapper)e2).getName());
            }
        });
        this.variableTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StringVariablePreferencePage.this.handleTableSelectionChanged(event);
            }
        });
        this.variableTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!StringVariablePreferencePage.this.variableTable.getSelection().isEmpty()) {
                    StringVariablePreferencePage.this.handleEditButtonPressed();
                }
            }
        });
        this.variableTable.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    StringVariablePreferencePage.this.handleRemoveButtonPressed();
                }
            }
        });
        int i = 0;
        while (i < this.variableTableColumnHeaders.length) {
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(this.variableTableColumnLayouts[i].resizable);
            tc.setText(this.variableTableColumnHeaders[i]);
            ++i;
        }
        if (!this.restoreColumnWidths()) {
            this.restoreDefaultColumnWidths();
        }
        this.variableTable.setInput((Object)this.getVariableManager());
        this.variableTable.setLabelProvider((IBaseLabelProvider)new SimpleVariableLabelProvider());
    }

    private void createButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.numColumns = 1;
        GridData gdata = new GridData(2);
        buttonComposite.setLayout((Layout)glayout);
        buttonComposite.setLayoutData((Object)gdata);
        buttonComposite.setFont(parent.getFont());
        this.envAddButton = SWTFactory.createPushButton(buttonComposite, DebugPreferencesMessages.SimpleVariablePreferencePage_7, null);
        this.envAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StringVariablePreferencePage.this.handleAddButtonPressed();
            }
        });
        this.envEditButton = SWTFactory.createPushButton(buttonComposite, DebugPreferencesMessages.SimpleVariablePreferencePage_8, null);
        this.envEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StringVariablePreferencePage.this.handleEditButtonPressed();
            }
        });
        this.envEditButton.setEnabled(false);
        this.envRemoveButton = SWTFactory.createPushButton(buttonComposite, DebugPreferencesMessages.SimpleVariablePreferencePage_9, null);
        this.envRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StringVariablePreferencePage.this.handleRemoveButtonPressed();
            }
        });
        this.envRemoveButton.setEnabled(false);
    }

    private void handleAddButtonPressed() {
        boolean done = false;
        String name = null;
        String description = null;
        String value = null;
        while (!done) {
            MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), DebugPreferencesMessages.SimpleVariablePreferencePage_13);
            dialog.addTextField(NAME_LABEL, name, false);
            dialog.addBrowseField(VALUE_LABEL, value, true);
            dialog.addTextField(DESCRIPTION_LABEL, description, true);
            if (dialog.open() != 0) {
                done = true;
                continue;
            }
            name = dialog.getStringValue(NAME_LABEL).trim();
            value = dialog.getStringValue(VALUE_LABEL);
            description = dialog.getStringValue(DESCRIPTION_LABEL);
            done = this.addVariable(name, description, value);
        }
    }

    private boolean addVariable(String name, String description, String value) {
        if (name == null || name.length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)DebugPreferencesMessages.StringVariablePreferencePage_21, (String)DebugPreferencesMessages.StringVariablePreferencePage_20);
            return false;
        }
        List editedVariables = this.variableContentProvider.getWorkingSetVariables();
        Iterator iter = editedVariables.iterator();
        while (iter.hasNext()) {
            String currentName;
            VariableWrapper currentVariable = (VariableWrapper)iter.next();
            if (currentVariable.isRemoved() || !(currentName = currentVariable.getName()).equals(name)) continue;
            if (currentVariable.isReadOnly()) {
                MessageDialog.openError((Shell)this.getShell(), (String)DebugPreferencesMessages.StringVariablePreferencePage_23, (String)MessageFormat.format((String)DebugPreferencesMessages.StringVariablePreferencePage_22, (Object[])new String[]{name}));
                return false;
            }
            MessageDialog dialog = new MessageDialog(this.getShell(), DebugPreferencesMessages.SimpleVariablePreferencePage_15, null, MessageFormat.format((String)DebugPreferencesMessages.SimpleVariablePreferencePage_16, (Object[])new String[]{name}), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            int overWrite = dialog.open();
            if (overWrite == 0) {
                currentVariable.setValue(value);
                currentVariable.setDescription(description);
                this.variableTable.update((Object)currentVariable, null);
                return true;
            }
            return overWrite != 1;
        }
        VariableWrapper newVariable = new VariableWrapper(name, description, value);
        this.variableContentProvider.addVariable(newVariable);
        this.variableTable.refresh();
        return true;
    }

    private void handleEditButtonPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.variableTable.getSelection();
        VariableWrapper variable = (VariableWrapper)selection.getFirstElement();
        if (variable == null || variable.isReadOnly()) {
            return;
        }
        String value = variable.getValue();
        String description = variable.getDescription();
        String name = variable.getName();
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), MessageFormat.format((String)DebugPreferencesMessages.SimpleVariablePreferencePage_14, (Object[])new String[]{name}));
        dialog.addBrowseField(VALUE_LABEL, value, true);
        dialog.addTextField(DESCRIPTION_LABEL, description, true);
        if (dialog.open() == 0) {
            value = dialog.getStringValue(VALUE_LABEL);
            description = dialog.getStringValue(DESCRIPTION_LABEL);
            if (value != null) {
                variable.setValue(value);
            }
            if (description != null) {
                variable.setDescription(description);
            }
            this.variableTable.update((Object)variable, null);
        }
    }

    private void handleRemoveButtonPressed() {
        boolean remove;
        IStructuredSelection selection = (IStructuredSelection)this.variableTable.getSelection();
        List variablesToRemove = selection.toList();
        StringBuffer contributedVariablesToRemove = new StringBuffer();
        Iterator iter = variablesToRemove.iterator();
        while (iter.hasNext()) {
            VariableWrapper variable = (VariableWrapper)iter.next();
            if (!variable.isContributed()) continue;
            contributedVariablesToRemove.append('\t').append(variable.getName()).append('\n');
        }
        if (contributedVariablesToRemove.length() > 0 && !(remove = MessageDialog.openQuestion((Shell)this.getShell(), (String)DebugPreferencesMessages.SimpleLaunchVariablePreferencePage_21, (String)MessageFormat.format((String)DebugPreferencesMessages.SimpleLaunchVariablePreferencePage_22, (Object[])new String[]{contributedVariablesToRemove.toString()})))) {
            return;
        }
        VariableWrapper[] variables = variablesToRemove.toArray(new VariableWrapper[0]);
        int i = 0;
        while (i < variables.length) {
            variables[i].setRemoved(true);
            ++i;
        }
        this.variableTable.refresh();
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        VariableWrapper variable = (VariableWrapper)selection.getFirstElement();
        if (variable == null || variable.isReadOnly()) {
            this.envEditButton.setEnabled(false);
            this.envRemoveButton.setEnabled(false);
        } else {
            this.envEditButton.setEnabled(selection.size() == 1);
            this.envRemoveButton.setEnabled(selection.size() > 0);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.variableContentProvider.init();
        this.variableTable.refresh();
        super.performDefaults();
    }

    public boolean performOk() {
        this.variableContentProvider.saveChanges();
        this.saveColumnWidths();
        return super.performOk();
    }

    private IStringVariableManager getVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }

    public void saveColumnWidths() {
        StringBuffer widthPreference = new StringBuffer();
        int i = 0;
        while (i < this.variableTable.getTable().getColumnCount()) {
            widthPreference.append(this.variableTable.getTable().getColumn(i).getWidth());
            widthPreference.append(',');
            ++i;
        }
        if (widthPreference.length() > 0) {
            DebugUIPlugin.getDefault().getPreferenceStore().setValue(STRING_VARIABLE_PREFERENCE_KEY, widthPreference.toString());
        }
    }

    private boolean restoreColumnWidths() {
        int columnCount;
        String[] columnWidthStrings = DebugUIPlugin.getDefault().getPreferenceStore().getString(STRING_VARIABLE_PREFERENCE_KEY).split(",");
        if (columnWidthStrings.length != (columnCount = this.variableTable.getTable().getColumnCount())) {
            return false;
        }
        int i = 0;
        while (i < columnCount) {
            try {
                int columnWidth = Integer.parseInt(columnWidthStrings[i]);
                this.variableTable.getTable().getColumn(i).setWidth(columnWidth);
            }
            catch (NumberFormatException e) {
                DebugUIPlugin.log(new Throwable("Problem loading persisted column sizes for StringVariablePreferencesPage", e));
            }
            ++i;
        }
        return true;
    }

    private void restoreDefaultColumnWidths() {
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < this.variableTableColumnLayouts.length) {
            layout.addColumnData(this.variableTableColumnLayouts[i]);
            ++i;
        }
        this.variableTable.getTable().setLayout((Layout)layout);
    }

    private class SimpleVariableContentProvider
    implements IStructuredContentProvider {
        private List fWorkingSet = new ArrayList();

        private SimpleVariableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.fWorkingSet.toArray();
        }

        public void addVariable(VariableWrapper variable) {
            this.fWorkingSet.add(variable);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null || !(newInput instanceof IStringVariableManager)) {
                return;
            }
            this.init();
        }

        public void saveChanges() {
            IStringVariableManager manager = StringVariablePreferencePage.this.getVariableManager();
            Iterator iterator = this.fWorkingSet.iterator();
            ArrayList<IValueVariable> remove = new ArrayList<IValueVariable>();
            ArrayList<IValueVariable> add = new ArrayList<IValueVariable>();
            while (iterator.hasNext()) {
                VariableWrapper variable = (VariableWrapper)iterator.next();
                if (variable.isReadOnly()) continue;
                IValueVariable underlyingVariable = variable.getUnderlyingVariable();
                if (variable.isRemoved()) {
                    if (underlyingVariable == null) continue;
                    remove.add(underlyingVariable);
                    continue;
                }
                if (variable.isAdded()) {
                    IValueVariable vv = manager.newValueVariable(variable.getName(), variable.getDescription());
                    vv.setValue(variable.getValue());
                    add.add(vv);
                    continue;
                }
                if (!variable.isChanged()) continue;
                underlyingVariable.setValue(variable.getValue());
                underlyingVariable.setDescription(variable.getDescription());
            }
            if (!remove.isEmpty()) {
                manager.removeVariables(remove.toArray(new IValueVariable[remove.size()]));
            }
            if (!add.isEmpty()) {
                try {
                    manager.addVariables(add.toArray(new IValueVariable[add.size()]));
                }
                catch (CoreException e) {
                    DebugUIPlugin.errorDialog(StringVariablePreferencePage.this.getShell(), DebugPreferencesMessages.StringVariablePreferencePage_24, DebugPreferencesMessages.StringVariablePreferencePage_25, e.getStatus());
                }
            }
        }

        public void init() {
            this.fWorkingSet.clear();
            IStringVariableManager manager = StringVariablePreferencePage.this.getVariableManager();
            IValueVariable[] variables = manager.getValueVariables();
            int i = 0;
            while (i < variables.length) {
                this.fWorkingSet.add(new VariableWrapper(variables[i]));
                ++i;
            }
        }

        public List getWorkingSetVariables() {
            return this.fWorkingSet;
        }
    }

    private class SimpleVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private SimpleVariableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof VariableWrapper) {
                VariableWrapper variable = (VariableWrapper)element;
                switch (columnIndex) {
                    case 0: {
                        StringBuffer name = new StringBuffer();
                        name.append(variable.getName());
                        if (variable.isReadOnly()) {
                            name.append(DebugPreferencesMessages.StringVariablePreferencePage_26);
                        }
                        return name.toString();
                    }
                    case 1: {
                        String value = variable.getValue();
                        if (value == null) {
                            value = "";
                        }
                        return value;
                    }
                    case 2: {
                        String description = variable.getDescription();
                        if (description == null) {
                            description = "";
                        }
                        return description;
                    }
                    case 3: {
                        String contribution = "";
                        if (variable.isContributed()) {
                            String pluginId = StringVariablePreferencePage.this.getVariableManager().getContributingPluginId((IStringVariable)variable.getUnderlyingVariable());
                            contribution = pluginId != null ? pluginId : DebugPreferencesMessages.SimpleLaunchVariablePreferencePage_23;
                        }
                        return contribution;
                    }
                }
            }
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            if (element instanceof VariableWrapper && ((VariableWrapper)element).isReadOnly()) {
                Display display = Display.getCurrent();
                return display.getSystemColor(29);
            }
            return null;
        }
    }

    class VariableFilter
    extends ViewerFilter {
        VariableFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !((VariableWrapper)element).isRemoved();
        }
    }

    class VariableWrapper {
        protected IValueVariable fVariable;
        protected String fNewName = null;
        protected String fNewDesc = null;
        protected String fNewValue = null;
        boolean fRemoved = false;
        boolean fAdded = false;

        public VariableWrapper(IValueVariable variable) {
            this.fVariable = variable;
        }

        public VariableWrapper(String name, String desc, String value) {
            this.fNewName = name;
            this.fNewDesc = desc;
            this.fNewValue = value;
            this.fAdded = true;
        }

        public boolean isAdded() {
            return this.fAdded;
        }

        public String getName() {
            if (this.fNewName == null) {
                return this.fVariable.getName();
            }
            return this.fNewName;
        }

        public void setName(String name) {
            this.fNewName = name;
        }

        public String getDescription() {
            if (this.fNewDesc == null) {
                return this.fVariable.getDescription();
            }
            return this.fNewDesc;
        }

        public String getValue() {
            if (this.fNewValue == null) {
                return this.fVariable.getValue();
            }
            return this.fNewValue;
        }

        public void setValue(String value) {
            this.fNewValue = value;
        }

        public void setDescription(String desc) {
            this.fNewDesc = desc;
        }

        public boolean isChanged() {
            return !this.fAdded && !this.fRemoved && (this.fNewValue != null || this.fNewDesc != null);
        }

        public boolean isReadOnly() {
            if (this.fVariable == null) {
                return false;
            }
            return this.fVariable.isReadOnly();
        }

        public boolean isContributed() {
            if (this.fVariable == null) {
                return false;
            }
            return this.fVariable.isContributed();
        }

        public IValueVariable getUnderlyingVariable() {
            return this.fVariable;
        }

        public boolean isRemoved() {
            return this.fRemoved;
        }

        public void setRemoved(boolean removed) {
            this.fRemoved = removed;
        }
    }
}

