/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.expression;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.actions.expressions.PasteWatchExpressionsAction;
import org.eclipse.debug.internal.ui.actions.variables.ChangeVariableValueAction;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.expression.ExpressionDropAdapter;
import org.eclipse.debug.internal.ui.views.variables.AvailableLogicalStructuresAction;
import org.eclipse.debug.internal.ui.views.variables.SelectionDragAdapter;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages;
import org.eclipse.debug.internal.ui.views.variables.details.AvailableDetailPanesAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ExpressionView
extends VariablesView {
    private PasteWatchExpressionsAction fPasteAction;

    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.expression_view_context";
    }

    protected void configureToolBar(IToolBarManager tbm) {
        super.configureToolBar(tbm);
        tbm.add((IContributionItem)new Separator("emptyExpressionGroup"));
        tbm.add((IContributionItem)new Separator("expressionGroup"));
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyExpressionGroup"));
        menu.add((IContributionItem)new Separator("expressionGroup"));
        menu.add(this.getAction(VARIABLES_FIND_ELEMENT_ACTION));
        ChangeVariableValueAction changeValueAction = (ChangeVariableValueAction)this.getAction("ChangeVariableValue");
        if (changeValueAction.isApplicable()) {
            menu.add((IAction)changeValueAction);
        }
        menu.add((IContributionItem)new Separator());
        Action action = new AvailableLogicalStructuresAction(this);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
        action = new AvailableDetailPanesAction(this);
        if (this.isDetailPaneVisible() && action.isEnabled()) {
            menu.add((IAction)action);
        }
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void contextActivated(ISelection selection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection == null || selection.isEmpty()) {
            super.contextActivated((ISelection)new StructuredSelection((Object)DebugPlugin.getDefault().getExpressionManager()));
        } else {
            super.contextActivated(selection);
        }
        if (this.isAvailable() && this.isVisible()) {
            this.updateAction("ContentAssist");
        }
    }

    protected void viewerInputUpdateComplete(IViewerInputUpdate update) {
        IStatus status = update.getStatus();
        if ((status == null || status.isOK()) && update.getElement() != null) {
            this.setViewerInput(update.getInputElement());
        } else {
            this.setViewerInput(DebugPlugin.getDefault().getExpressionManager());
        }
        this.updateAction(VARIABLES_FIND_ELEMENT_ACTION);
        this.updateAction(FIND_ACTION);
    }

    protected String getDetailPanePreferenceKey() {
        return "Expressions.detail.orientation";
    }

    protected String getToggleActionLabel() {
        return VariablesViewMessages.ExpressionView_4;
    }

    protected String getPresentationContextId() {
        return "org.eclipse.debug.ui.ExpressionView";
    }

    protected void initDragAndDrop(TreeModelViewer viewer) {
        viewer.addDragSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new SelectionDragAdapter(viewer));
        viewer.addDropSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance()}, (DropTargetListener)new ExpressionDropAdapter(viewer));
    }

    protected void createActions() {
        super.createActions();
        this.fPasteAction = new PasteWatchExpressionsAction(this);
        this.configure((IAction)this.fPasteAction, "org.eclipse.ui.edit.paste", PASTE_ACTION, "IMG_TOOL_PASTE");
    }

    private void configure(IAction action, String defId, String globalId, String imgId) {
        this.setAction(defId, action);
        action.setActionDefinitionId(defId);
        this.getViewSite().getActionBars().setGlobalActionHandler(globalId, action);
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imgId));
    }

    public boolean canPaste() {
        String clipboardText = this.getClipboardText();
        return clipboardText != null && clipboardText.length() > 0;
    }

    public boolean performPaste() {
        String clipboardText = this.getClipboardText();
        if (clipboardText != null && clipboardText.length() > 0) {
            IExpressionManager expressionManager = DebugPlugin.getDefault().getExpressionManager();
            IWatchExpression watchExpression = expressionManager.newWatchExpression(clipboardText);
            expressionManager.addExpression((IExpression)watchExpression);
            watchExpression.setExpressionContext(this.getContext());
            return true;
        }
        return false;
    }

    protected IDebugElement getContext() {
        IAdaptable object = DebugUITools.getDebugContext();
        IDebugElement context = null;
        if (object instanceof IDebugElement) {
            context = (IDebugElement)object;
        } else if (object instanceof ILaunch) {
            context = ((ILaunch)object).getDebugTarget();
        }
        return context;
    }

    protected String getClipboardText() {
        Clipboard clipboard = new Clipboard(Display.getDefault());
        try {
            TextTransfer textTransfer = TextTransfer.getInstance();
            String string = (String)clipboard.getContents((Transfer)textTransfer);
            return string;
        }
        finally {
            clipboard.dispose();
        }
    }
}

