/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.editor.internal.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.koneki.ldt.editor.Activator;
import org.eclipse.koneki.ldt.editor.internal.completion.Messages;
import org.eclipse.koneki.ldt.editor.internal.navigation.LuaLocalDeclarationVisitor;
import org.eclipse.koneki.ldt.parser.LuaASTUtils;
import org.eclipse.koneki.ldt.parser.LuaSelectionEngine;
import org.eclipse.koneki.ldt.parser.ast.declarations.FunctionDeclaration;
import org.eclipse.koneki.ldt.parser.ast.declarations.ModuleReference;

public class LuaCompletionEngine
extends ScriptCompletionEngine {
    public void complete(IModuleSource module, int position, int k) {
        block8: {
            try {
                IModelElement modelElement = module.getModelElement();
                if (!(modelElement instanceof ISourceModule)) {
                    Activator.logWarning(Messages.LuaCompletionEngineBadModelElement);
                    return;
                }
                ISourceModule sourceModule = (ISourceModule)modelElement;
                try {
                    String start = this.getWordStarting(module.getSourceContents(), position).toLowerCase();
                    this.actualCompletionPosition = position;
                    this.offset = this.actualCompletionPosition - start.length();
                    this.requestor.beginReporting();
                    if (start.contains(".")) {
                        List<String> ids = this.getExpressionIdentifiers(start);
                        this.addModuleFields(sourceModule, ids);
                        break block8;
                    }
                    this.addGlobalDeclarations(sourceModule, start);
                    this.addKeywords(start);
                }
                catch (ModelException e) {
                    Activator.logError(Messages.LuaCompletionEngineIniTialization, e);
                }
            }
            finally {
                this.requestor.endReporting();
            }
        }
    }

    private void addGlobalDeclarations(ISourceModule sourceModule, final String start) throws ModelException {
        IProjectFragment[] allProjectFragments;
        IScriptProject project = sourceModule.getScriptProject();
        IProjectFragment[] iProjectFragmentArray = allProjectFragments = project.getAllProjectFragments();
        int n = allProjectFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectFragment iProjectFragment = iProjectFragmentArray[n2];
            iProjectFragment.accept(new IModelElementVisitor(){

                public boolean visit(IModelElement element) {
                    if (element instanceof IMember) {
                        IMember member = (IMember)element;
                        try {
                            if (Flags.isPublic((int)member.getFlags()) && !LuaASTUtils.isModule((IMember)member)) {
                                boolean goodStart = element.getElementName().toLowerCase().startsWith(start.toLowerCase());
                                boolean nostart = start.isEmpty();
                                if (goodStart || nostart) {
                                    LuaCompletionEngine.this.createProposal(element.getElementName(), element);
                                }
                            }
                        }
                        catch (ModelException e) {
                            Activator.logWarning("unable to acces to " + member + " to feed autocompletion.", e);
                        }
                        return false;
                    }
                    return true;
                }
            });
            ++n2;
        }
    }

    private void addKeywords(String start) {
        String[] keywords = new String[]{"and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while"};
        int j = 0;
        while (j < keywords.length) {
            if (start.isEmpty() || keywords[j].startsWith(start)) {
                this.createProposal(keywords[j], null);
            }
            ++j;
        }
    }

    private void addLocalDeclarations(ISourceModule sourceModule, String start) {
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        if (moduleDeclaration != null) {
            try {
                ASTNode nodeInScope = LuaASTUtils.getClosestScope((ModuleDeclaration)moduleDeclaration, (int)this.offset);
                LuaLocalDeclarationVisitor visitor = new LuaLocalDeclarationVisitor(nodeInScope);
                moduleDeclaration.traverse((ASTVisitor)visitor);
                Declaration[] declarationArray = visitor.getDeclarations();
                int n = declarationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Declaration declaration = declarationArray[n2];
                    this.createProposal(declaration);
                    ++n2;
                }
            }
            catch (Exception e) {
                Activator.logWarning(Messages.LuaCompletionEngineDuringLocalProposalProcessing, e);
            }
        }
    }

    private void addModuleFields(ISourceModule sourceModule, List<String> ids) {
        if (ids.size() != 2) {
            return;
        }
        String identifierName = ids.get(0);
        ModuleDeclaration ast = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        ModuleReference moduleref = LuaASTUtils.getModuleReferenceFromName((ModuleDeclaration)ast, (String)identifierName);
        try {
            IModelElement definition = LuaSelectionEngine.findDefinition((ASTNode)moduleref, (ISourceModule)sourceModule);
            if (definition instanceof ISourceModule) {
                Map moduleFields = LuaASTUtils.getModuleFields((ISourceModule)((ISourceModule)definition));
                String fieldName = ids.get(1);
                this.offset = this.actualCompletionPosition - fieldName.length();
                for (Map.Entry entry : moduleFields.entrySet()) {
                    IModelElement element = ((ISourceModule)definition).getElementAt(((Declaration)entry.getValue()).sourceStart());
                    boolean goodStart = element.getElementName().toLowerCase().startsWith(fieldName.toLowerCase());
                    boolean nostart = fieldName.isEmpty();
                    if (!goodStart && !nostart) continue;
                    this.createProposal(element.getElementName(), element);
                }
            }
        }
        catch (ModelException e) {
            Activator.logWarning("Unable to get model element.", e);
        }
    }

    private void createProposal(Declaration declaration) {
        CompletionProposal proposal;
        switch (declaration.getKind()) {
            case 3002: {
                proposal = this.createProposal(5, this.actualCompletionPosition);
                List parameters = ((FunctionDeclaration)declaration).getArguments();
                ArrayList<String> list = new ArrayList<String>(parameters.size());
                for (Object o : parameters) {
                    if (!(o instanceof Argument)) continue;
                    list.add(((Argument)o).getName());
                }
                proposal.setParameterNames(list.toArray(new String[list.size()]));
                break;
            }
            case 3001: {
                proposal = this.createProposal(7, this.actualCompletionPosition);
                break;
            }
            default: {
                proposal = this.createProposal(4, this.actualCompletionPosition);
            }
        }
        String name = declaration.getName();
        proposal.setFlags(declaration.getModifiers() & 0x10);
        proposal.setName(name);
        proposal.setCompletion(name);
        proposal.setReplaceRange(this.offset, this.offset + name.length());
        proposal.setRelevance(3);
        this.requestor.accept(proposal);
    }

    private void createProposal(String name, IModelElement element) {
        CompletionProposal proposal = null;
        int relevance = 2;
        try {
            if (element == null) {
                relevance = 1;
                proposal = this.createProposal(2, this.actualCompletionPosition);
            } else {
                IMember member = (IMember)element;
                switch (member.getElementType()) {
                    case 9: {
                        proposal = this.createProposal(5, this.actualCompletionPosition);
                        IMethod method = (IMethod)member;
                        proposal.setParameterNames(method.getParameterNames());
                        break;
                    }
                    case 8: {
                        proposal = this.createProposal(1, this.actualCompletionPosition);
                        proposal.setFlags(member.getFlags());
                        break;
                    }
                    case 7: {
                        proposal = this.createProposal(7, this.actualCompletionPosition);
                        proposal.setFlags(((IType)element).getFlags());
                        break;
                    }
                    default: {
                        return;
                    }
                }
                proposal.setFlags(member.getFlags());
                proposal.setModelElement((IModelElement)member);
            }
            proposal.setName(name);
            proposal.setCompletion(name);
            proposal.setReplaceRange(this.offset, this.actualCompletionPosition);
            proposal.setRelevance(relevance);
            this.requestor.accept(proposal);
        }
        catch (ModelException e) {
            Activator.logWarning(Messages.LuaCompletionEngineProblemProcessingGlobals, e);
        }
    }

    private String getWordStarting(String content, int position) {
        if (position <= 0 || position > content.length()) {
            return "";
        }
        int currentPosition = position;
        int lastValidPosition = position;
        boolean finish = false;
        do {
            boolean isIdentifierPart;
            char currentChar;
            boolean isOperator = (currentChar = content.charAt(--currentPosition)) == '.';
            boolean bl = isIdentifierPart = Character.isLetterOrDigit(currentChar) || currentChar == '_';
            if (isOperator || isIdentifierPart) {
                lastValidPosition = currentPosition;
                continue;
            }
            finish = true;
        } while (!finish);
        if (lastValidPosition >= position) {
            return "";
        }
        return content.substring(lastValidPosition, position);
    }

    private List<String> getExpressionIdentifiers(String composedId) {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(composedId.split("\\.")));
        if (composedId.endsWith(".")) {
            result.add("");
        }
        return result;
    }
}

