/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.parser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.koneki.ldt.core.LuaUtils;
import org.eclipse.koneki.ldt.parser.ast.LuaSourceRoot;
import org.eclipse.koneki.ldt.parser.ast.declarations.LuaModuleDeclaration;
import org.eclipse.koneki.ldt.parser.ast.declarations.ModuleReference;
import org.eclipse.koneki.ldt.parser.ast.visitor.ModuleReferenceVisitor;
import org.eclipse.koneki.ldt.parser.ast.visitor.ScopeVisitor;

public final class LuaASTUtils {
    private LuaASTUtils() {
    }

    private static boolean isModule(int flags) {
        return (flags & 0x400) != 0;
    }

    public static boolean isModule(IMember member) throws ModelException {
        return member instanceof IType && LuaASTUtils.isModule(member.getFlags());
    }

    public static boolean isModuleFunction(IMember member) throws ModelException {
        return member instanceof IMethod && LuaASTUtils.isModule(member.getFlags());
    }

    public static boolean isGlobalTable(IMember member) throws ModelException {
        return member instanceof IType && Flags.isPublic((int)member.getFlags());
    }

    public static boolean isLocalTable(IMember member) throws ModelException {
        return member instanceof IType && Flags.isPrivate((int)member.getFlags());
    }

    public static ASTNode getClosestScope(ModuleDeclaration ast, int sourcePosition) throws Exception {
        ScopeVisitor visitor = new ScopeVisitor(sourcePosition);
        ast.traverse((ASTVisitor)visitor);
        return visitor.getScope();
    }

    public static ModuleReference getModuleReferenceFromName(ModuleDeclaration ast, String lhsName) {
        ModuleReferenceVisitor visitor = new ModuleReferenceVisitor(lhsName);
        try {
            ast.traverse((ASTVisitor)visitor);
            return visitor.getModuleReference();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Map<String, Declaration> getModuleFields(ISourceModule module) throws ModelException {
        LuaModuleDeclaration luaModuleDeclaration;
        HashMap<String, Declaration> result = new HashMap<String, Declaration>();
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module);
        if (moduleDeclaration instanceof LuaSourceRoot && (luaModuleDeclaration = ((LuaSourceRoot)moduleDeclaration).getDeclarationsContainer().getLuaModuleDeclaration()) != null) {
            MethodDeclaration[] methodDeclarationArray = luaModuleDeclaration.getMethods();
            int n = methodDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodDeclaration declaration = methodDeclarationArray[n2];
                result.put(declaration.getName(), (Declaration)declaration);
                ++n2;
            }
        }
        return result;
    }

    public static Map<String, Declaration> getModuleFields(String name, IScriptProject project) throws ModelException {
        IModuleSource moduleSource = LuaUtils.getModuleSource((String)name, (IScriptProject)project);
        if (moduleSource instanceof ISourceModule) {
            return LuaASTUtils.getModuleFields((ISourceModule)moduleSource);
        }
        return new HashMap<String, Declaration>();
    }

    public static boolean isAncestor(IModelElement element, IModelElement ancestor) {
        return ancestor != null && element != null && (ancestor.equals(element.getParent()) || LuaASTUtils.isAncestor(element.getParent(), ancestor));
    }
}

