/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.parser;

import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.koneki.ldt.core.LuaUtils;
import org.eclipse.koneki.ldt.parser.Activator;
import org.eclipse.koneki.ldt.parser.LuaASTUtils;
import org.eclipse.koneki.ldt.parser.ast.declarations.ModuleReference;
import org.eclipse.koneki.ldt.parser.ast.expressions.Identifier;
import org.eclipse.koneki.ldt.parser.ast.expressions.Index;
import org.eclipse.koneki.ldt.parser.ast.visitor.MatchNodeVisitor;

public class LuaSelectionEngine
extends ScriptSelectionEngine {
    public IModelElement[] select(IModuleSource module, int start, int end) {
        ASTNode node;
        if (!(module instanceof ISourceModule)) {
            return new IModelElement[0];
        }
        ISourceModule sourceModule = (ISourceModule)module;
        IModelElement result = null;
        ModuleDeclaration ast = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        if (ast != null && (node = LuaSelectionEngine.findNodeAt(ast, start, end)) != null) {
            try {
                result = LuaSelectionEngine.findDefinition(node, sourceModule);
            }
            catch (ModelException e) {
                Activator.logWarning("Unable to find definition for node:" + node, e);
            }
        }
        if (result == null) {
            return null;
        }
        return new IModelElement[]{result};
    }

    public static Declaration findMinimalDeclaration(ModuleDeclaration ast, int start, int end) {
        MatchNodeVisitor visitor = new MatchNodeVisitor(start, end + 1);
        try {
            ast.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Activator.logWarning("Problem occured while seeking for minimal node.", e);
        }
        ASTNode node = visitor.getNode();
        if (node instanceof Identifier) {
            Identifier id = (Identifier)node;
            if (id.hasDeclaration()) {
                return id.getDeclaration();
            }
        } else if (node instanceof Declaration) {
            return (Declaration)node;
        }
        return null;
    }

    public static ASTNode findNodeAt(ModuleDeclaration ast, int start, int end) {
        MatchNodeVisitor visitor = new MatchNodeVisitor(start, end + 1);
        try {
            ast.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Activator.logWarning("Problem occured while seeking for minimal node.", e);
        }
        ASTNode node = visitor.getNode();
        return node;
    }

    public static IModelElement findDefinition(ASTNode node, ISourceModule module) throws ModelException {
        Map<String, Declaration> moduleFields;
        Declaration declaration;
        String moduleNameReference;
        ISourceModule sourceModule;
        Index index;
        Expression root;
        ASTNode rootlocaldefinition;
        ASTNode localDefinition = LuaSelectionEngine.findLocalDefinition(node);
        if (localDefinition != null) {
            String moduleNameReference2;
            ISourceModule sourceModule2;
            if (localDefinition instanceof ModuleReference && (sourceModule2 = LuaUtils.getSourceModule((String)(moduleNameReference2 = ((ModuleReference)localDefinition).getModuleNameReference()), (IScriptProject)module.getScriptProject())) != null) {
                return sourceModule2;
            }
            try {
                return module.getElementAt(localDefinition.sourceStart());
            }
            catch (ModelException e) {
                Activator.logWarning("Unable to get model element.", e);
            }
        }
        if (localDefinition == null && node instanceof Index && (rootlocaldefinition = LuaSelectionEngine.findLocalDefinition((ASTNode)(root = (index = (Index)node).getRoot()))) instanceof ModuleReference && (sourceModule = LuaUtils.getSourceModule((String)(moduleNameReference = ((ModuleReference)rootlocaldefinition).getModuleNameReference()), (IScriptProject)module.getScriptProject())) != null && (declaration = (moduleFields = LuaASTUtils.getModuleFields(sourceModule)).get(index.getName())) != null) {
            try {
                return sourceModule.getElementAt(declaration.sourceStart());
            }
            catch (ModelException e) {
                Activator.logWarning("Unable to get model element.", e);
            }
        }
        return null;
    }

    public static ASTNode findLocalDefinition(ASTNode node) {
        Identifier identifier;
        if (node instanceof Declaration) {
            return node;
        }
        if (node instanceof Identifier && (identifier = (Identifier)node).hasDeclaration()) {
            return identifier.getDeclaration();
        }
        return null;
    }
}

