/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.parser.ast.declarations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.koneki.ldt.parser.ast.declarations.FunctionDeclaration;
import org.eclipse.koneki.ldt.parser.ast.declarations.LuaModuleDeclaration;

public class DeclarationsContainer
extends Statement {
    private LuaModuleDeclaration module;
    private List<Declaration> declarations = new ArrayList<Declaration>();

    public List<Declaration> getDeclarations() {
        return this.declarations;
    }

    public List<FunctionDeclaration> getGlobalFunctions() {
        ArrayList<FunctionDeclaration> results = new ArrayList<FunctionDeclaration>();
        for (Declaration declaration : this.declarations) {
            if (!(declaration instanceof FunctionDeclaration)) continue;
            FunctionDeclaration function = (FunctionDeclaration)declaration;
            if (!((FunctionDeclaration)declaration).isGlobal()) continue;
            results.add(function);
        }
        return Collections.unmodifiableList(results);
    }

    public void setLuaModuleDeclaration(LuaModuleDeclaration luamodule) {
        this.module = luamodule;
    }

    public LuaModuleDeclaration getLuaModuleDeclaration() {
        return this.module;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Statement)this)) {
            if (this.module != null) {
                this.module.traverse(visitor);
            }
            for (Declaration declaration : this.declarations) {
                declaration.traverse(visitor);
            }
            visitor.endvisit((Statement)this);
        }
    }

    public int getKind() {
        return 0;
    }
}

