/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTButton;
import org.eclipse.swt.internal.cocoa.SWTButtonCell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    String text;
    Image image;
    boolean grayed;
    static final int EXTRA_HEIGHT = 2;
    static final int EXTRA_WIDTH = 6;
    static final int IMAGE_GAP = 2;

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    NSSize cellSize(long id2, long sel) {
        NSSize size = super.cellSize(id2, sel);
        if (this.image != null && (this.style & 0x30) != 0) {
            NSSize imageSize = this.image.handle.size();
            size.width += imageSize.width + 2.0;
            size.height = Math.max(size.height, imageSize.height);
        }
        return size;
    }

    static int checkStyle(int style) {
        if (((style = Button.checkBits(style, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x30) != 0) {
            return Button.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Button.checkBits(style |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    void click() {
        this.sendSelectionEvent(13);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int width = wHint != -1 ? wHint : 14;
            int height = hHint != -1 ? hHint : 14;
            return new Point(width, height);
        }
        NSSize size = ((NSButton)this.view).cell().cellSize();
        int width = (int)Math.ceil(size.width);
        int height = (int)Math.ceil(size.height);
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        if ((this.style & 0xA) != 0 && (this.style & 0x800000) == 0) {
            if (this.display.smallFonts) {
                height += 2;
            }
            width += 6;
        }
        return new Point(width, height);
    }

    NSAttributedString createString() {
        NSAttributedString attribStr = this.createString(this.text, null, this.foreground, this.style, false, true, true);
        attribStr.autorelease();
        return attribStr;
    }

    void createHandle() {
        if ((this.style & 8) == 0) {
            this.state |= 0x800;
        }
        NSButton widget = (NSButton)new SWTButton().alloc();
        widget.init();
        NSButtonCell cell = (NSButtonCell)new SWTButtonCell().alloc().init();
        widget.setCell(cell);
        cell.release();
        int type = 0;
        if ((this.style & 8) != 0) {
            boolean flat;
            boolean bl = flat = (this.style & 0x800000) != 0;
            if (!flat) {
                NSView superview = widget.superview();
                while (superview != null) {
                    if (superview.isKindOfClass(OS.class_NSTableView)) {
                        flat = true;
                        break;
                    }
                    superview = superview.superview();
                }
            }
            if (flat) {
                widget.setBezelStyle(6L);
            } else {
                widget.setBezelStyle(1L);
            }
        } else if ((this.style & 0x20) != 0) {
            type = 3;
        } else if ((this.style & 0x10) != 0) {
            type = 4;
        } else if ((this.style & 2) != 0) {
            type = 1;
            if ((this.style & 0x800000) != 0) {
                widget.setBezelStyle(6L);
            } else {
                widget.setBezelStyle(1L);
            }
        } else if ((this.style & 4) != 0) {
            widget.setBezelStyle(6L);
        }
        widget.setButtonType(type);
        widget.setTitle(NSString.string());
        widget.setImagePosition(2L);
        widget.setTarget(widget);
        widget.setAction(OS.sel_sendSelection);
        this.view = widget;
        this._setAlignment(this.style);
    }

    void createWidget() {
        this.text = "";
        super.createWidget();
    }

    NSFont defaultNSFont() {
        return this.display.buttonFont;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(((NSControl)this.view).cell());
    }

    boolean dragDetect(int x, int y, boolean filter, boolean[] consume) {
        boolean dragging;
        consume[0] = dragging = super.dragDetect(x, y, filter, consume);
        return dragging;
    }

    boolean drawsBackground() {
        return this.background != null || this.backgroundImage != null;
    }

    void drawImageWithFrameInView(long id2, long sel, long image, NSRect rect, long view) {
        if (this.display.smallFonts && (this.style & 0xA) != 0 && (this.style & 0x800000) == 0) {
            rect.y += 1.0;
            rect.height += 2.0;
        }
        this.callSuper(id2, sel, image, rect, view);
    }

    void drawInteriorWithFrame_inView(long id2, long sel, NSRect cellRect, long viewid) {
        if ((this.style & 0x30) != 0 && this.backgroundImage != null) {
            this.fillBackground(new NSView(viewid), NSGraphicsContext.currentContext(), cellRect, -1);
        }
        super.drawInteriorWithFrame_inView(id2, sel, cellRect, viewid);
        if (this.image != null && (this.style & 0x30) != 0) {
            NSSize imageSize = this.image.handle.size();
            NSCell nsCell = new NSCell(id2);
            double x = 0.0;
            double y = (imageSize.height - cellRect.height) / 2.0;
            NSRect imageRect = nsCell.imageRectForBounds(cellRect);
            NSSize stringSize = ((NSButton)this.view).attributedTitle().size();
            switch (this.style & 0x1024000) {
                case 16384: {
                    x = imageRect.x + imageRect.width + 2.0;
                    break;
                }
                case 0x1000000: {
                    x = cellRect.x + imageRect.x + imageRect.width + (cellRect.width - stringSize.width) / 2.0 - imageSize.width - 2.0;
                    break;
                }
                case 131072: {
                    x = cellRect.x + cellRect.width - stringSize.width - imageSize.width - 2.0;
                }
            }
            NSRect destRect = new NSRect();
            destRect.x = x;
            destRect.y = y;
            destRect.width = imageSize.width;
            destRect.height = imageSize.height;
            NSGraphicsContext.static_saveGraphicsState();
            NSAffineTransform transform = NSAffineTransform.transform();
            transform.scaleXBy(1.0, -1.0);
            transform.translateXBy(0.0, -imageSize.height);
            transform.concat();
            this.image.handle.drawInRect(destRect, new NSRect(), 2L, 1.0);
            NSGraphicsContext.static_restoreGraphicsState();
        }
    }

    void drawWidget(long id2, NSGraphicsContext context, NSRect rect) {
        if ((this.style & 4) != 0) {
            NSRect frame = this.view.frame();
            int arrowSize = Math.min((int)frame.height, (int)frame.width) / 2;
            context.saveGraphicsState();
            NSPoint p1 = new NSPoint();
            p1.x = -arrowSize / 2;
            p1.y = -arrowSize / 2;
            NSPoint p2 = new NSPoint();
            p2.x = arrowSize / 2;
            p2.y = p1.y;
            NSPoint p3 = new NSPoint();
            p3.y = arrowSize / 2;
            NSBezierPath path = NSBezierPath.bezierPath();
            path.moveToPoint(p1);
            path.lineToPoint(p2);
            path.lineToPoint(p3);
            path.closePath();
            NSAffineTransform transform = NSAffineTransform.transform();
            if ((this.style & 0x4000) != 0) {
                transform.rotateByDegrees(90.0);
            } else if ((this.style & 0x80) != 0) {
                transform.rotateByDegrees(180.0);
            } else if ((this.style & 0x20000) != 0) {
                transform.rotateByDegrees(-90.0);
            }
            path.transformUsingAffineTransform(transform);
            transform = NSAffineTransform.transform();
            transform.translateXBy(frame.width / 2.0, frame.height / 2.0);
            path.transformUsingAffineTransform(transform);
            NSColor color = this.isEnabled() ? NSColor.blackColor() : NSColor.disabledControlTextColor();
            color.set();
            path.fill();
            context.restoreGraphicsState();
        }
        super.drawWidget(id2, context, rect);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        if ((this.style & 0x20) != 0 && this.grayed) {
            return ((NSButton)this.view).state() == -1L;
        }
        return ((NSButton)this.view).state() == 1L;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    boolean isDescribedByLabel() {
        return false;
    }

    long nextState(long id2, long sel) {
        if ((this.style & 0x20) != 0 && this.grayed) {
            return ((NSButton)this.view).state() == -1L ? 0 : -1;
        }
        return super.nextState(id2, sel);
    }

    void register() {
        super.register();
        this.display.addWidget(((NSControl)this.view).cell(), this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        Control[] children = this.parent._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (this != child) {
                child.setRadioSelection(false);
            }
            ++i;
        }
        this.setSelection(true);
    }

    void sendSelection() {
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        if ((this.style & 0x20) != 0) {
            if (this.grayed && ((NSButton)this.view).state() == 1L) {
                ((NSButton)this.view).setState(0L);
            }
            if (!this.grayed && ((NSButton)this.view).state() == -1L) {
                ((NSButton)this.view).setState(1L);
            }
        }
        this.sendSelectionEvent(13);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        this._setAlignment(alignment);
        this.redraw();
    }

    void _setAlignment(int alignment) {
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= alignment & 0x24480;
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        if (this.text != null) {
            ((NSButton)this.view).setAttributedTitle(this.createString());
        }
    }

    void setBackgroundColor(NSColor nsColor) {
        Control control = this.findBackgroundControl();
        if (control == null || control.backgroundImage == null) {
            NSButtonCell cell = new NSButtonCell(((NSButton)this.view).cell());
            cell.setBackgroundColor(nsColor);
        }
    }

    void setBackgroundImage(NSImage image) {
        if (image != null) {
            NSButtonCell cell = new NSButtonCell(((NSButton)this.view).cell());
            cell.setBackgroundColor(null);
        }
    }

    void setFont(NSFont font) {
        if (this.text != null) {
            ((NSButton)this.view).setAttributedTitle(this.createString());
        }
    }

    void setForeground(double[] color) {
        ((NSButton)this.view).setAttributedTitle(this.createString());
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        boolean checked = this.getSelection();
        this.grayed = grayed;
        ((NSButton)this.view).setAllowsMixedState(grayed);
        if (checked) {
            if (grayed) {
                ((NSButton)this.view).setState(-1L);
            } else {
                ((NSButton)this.view).setState(1L);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.image = image;
        if ((this.style & 0x30) == 0) {
            ((NSButton)this.view).setImage(image != null ? image.handle : null);
            this.view.setNeedsDisplay(true);
        } else {
            ((NSButton)this.view).setAttributedTitle(this.createString());
        }
        this.updateAlignment();
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        if (this.grayed) {
            ((NSButton)this.view).setState(selected ? -1 : 0);
        } else {
            ((NSButton)this.view).setState(selected ? 1 : 0);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        ((NSButton)this.view).setAttributedTitle(this.createString());
        this.updateAlignment();
    }

    NSRect titleRectForBounds(long id2, long sel, NSRect cellFrame) {
        NSRect rect = super.titleRectForBounds(id2, sel, cellFrame);
        if (this.image != null && (this.style & 0x30) != 0) {
            NSSize imageSize = this.image.handle.size();
            rect.x += imageSize.width + 2.0;
            rect.width -= imageSize.width + 2.0;
            rect.width = Math.max(0.0, rect.width);
        }
        return rect;
    }

    int traversalCode(int key, NSEvent theEvent) {
        int code = super.traversalCode(key, theEvent);
        if ((this.style & 4) != 0) {
            code &= 0xFFFFFFE7;
        }
        if ((this.style & 0x10) != 0) {
            code |= 0x60;
        }
        return code;
    }

    void updateAlignment() {
        NSButton widget = (NSButton)this.view;
        if ((this.style & 0xA) != 0) {
            if (this.text.length() != 0 && this.image != null) {
                widget.setImagePosition(2L);
            } else {
                widget.setImagePosition(this.text.length() != 0 ? 0 : 1);
            }
        }
    }
}

