/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.ArrayList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.base.scope.EnablementScope;
import org.eclipse.help.internal.base.scope.FilterScope;
import org.eclipse.help.internal.base.scope.IntersectionScope;
import org.eclipse.help.internal.base.scope.ScopeRegistry;
import org.eclipse.help.internal.base.scope.UniversalScope;
import org.eclipse.help.internal.base.scope.WorkingSetScope;
import org.eclipse.help.internal.util.ProductPreferences;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.CookieUtil;
import org.eclipse.help.internal.webapp.servlet.WebappWorkingSetManager;
import org.eclipse.help.internal.workingset.IHelpWorkingSetManager;
import org.osgi.service.prefs.BackingStoreException;

public class RequestScope {
    private static final String SCOPE_PARAMETER_NAME = "scope";
    private static final String SCOPE_COOKIE_NAME = "filter";

    public static AbstractHelpScope getScope(HttpServletRequest req, HttpServletResponse resp, boolean isSearchFilter) {
        AbstractHelpScope[] scopeArray = RequestScope.getActiveScopes(req, resp, isSearchFilter);
        switch (scopeArray.length) {
            case 0: {
                return new UniversalScope();
            }
            case 1: {
                return scopeArray[0];
            }
        }
        return new IntersectionScope(scopeArray);
    }

    public static AbstractHelpScope[] getActiveScopes(HttpServletRequest req, HttpServletResponse resp, boolean isSearchFilter) {
        AbstractHelpScope scope;
        String scopeString;
        ArrayList<Object> scopes = new ArrayList<Object>();
        if (ProductPreferences.useEnablementFilters()) {
            scopes.add(new FilterScope());
        }
        if ((scopeString = RequestScope.getScopeString(req)) != null && (scope = ScopeRegistry.getInstance().parseScopePhrase(scopeString)) != null) {
            scopes.add(scope);
        }
        if (!HelpSystem.isShared() && HelpBasePlugin.getActivitySupport().isFilteringEnabled()) {
            scopes.add(new EnablementScope());
        }
        boolean isHelpViewTopic = "/ntopic".equals(req.getServletPath());
        if (!isSearchFilter && !isHelpViewTopic) {
            try {
                WebappWorkingSetManager manager = new WebappWorkingSetManager(req, resp, UrlUtil.getLocale(req, resp));
                String wset = manager.getCurrentWorkingSet();
                if (wset != null && wset.length() > 0) {
                    WorkingSetScope workingSetScope = new WorkingSetScope(wset, (IHelpWorkingSetManager)manager, HelpBaseResources.SearchScopeFilterName);
                    scopes.add(workingSetScope);
                }
            }
            catch (Exception exception) {}
        }
        AbstractHelpScope[] scopeArray = scopes.toArray(new AbstractHelpScope[scopes.size()]);
        return scopeArray;
    }

    private static String getScopeString(HttpServletRequest req) {
        String scopeString;
        if (HelpSystem.isShared()) {
            scopeString = RequestScope.getScopeFromCookies(req);
        } else {
            scopeString = RequestScope.getScopeFromPreferences();
            if (scopeString == null) {
                scopeString = "org.eclipse.help.enablement";
            }
        }
        return scopeString;
    }

    public static void setScopeFromRequest(HttpServletRequest request, HttpServletResponse response) {
        String[] phrases = request.getParameterValues(SCOPE_PARAMETER_NAME);
        String scopeStr = "";
        if (phrases != null) {
            int p = 0;
            while (p < phrases.length) {
                if (!phrases[p].startsWith("(") || phrases[p].startsWith("(")) {
                    phrases[p] = String.valueOf('(') + phrases[p] + ')';
                }
                scopeStr = String.valueOf(scopeStr) + phrases[p];
                if (p < phrases.length - 1) {
                    scopeStr = String.valueOf(scopeStr) + "^";
                }
                ++p;
            }
        }
        CookieUtil.deleteObsoleteCookies(request, response);
        RequestScope.saveScope(scopeStr, request, response);
    }

    public static void saveScope(String scope, HttpServletRequest request, HttpServletResponse response) {
        if (HelpSystem.isShared()) {
            if (response != null) {
                CookieUtil.setCookieValue(SCOPE_COOKIE_NAME, URLCoder.compactEncode((String)scope), request, response);
            }
        } else {
            InstanceScope instanceScope = new InstanceScope();
            IEclipsePreferences pref = instanceScope.getNode("org.eclipse.help.base");
            pref.put(SCOPE_PARAMETER_NAME, scope);
            try {
                pref.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    private static String getScopeFromCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            int c = 0;
            while (c < cookies.length) {
                if (SCOPE_COOKIE_NAME.equals(cookies[c].getName())) {
                    return URLCoder.decode((String)cookies[c].getValue());
                }
                ++c;
            }
        }
        return null;
    }

    private static String getScopeFromPreferences() {
        String scope = Platform.getPreferencesService().getString("org.eclipse.help.base", SCOPE_PARAMETER_NAME, null, null);
        return scope;
    }

    public static boolean filterBySearchScope(HttpServletRequest request) {
        return true;
    }
}

