/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

class ConjunctionScorer
extends Scorer {
    private LinkedList scorers = new LinkedList();
    private boolean firstTime = true;
    private boolean more = true;
    private float coord;

    public ConjunctionScorer(Similarity similarity) {
        super(similarity);
    }

    final void add(Scorer scorer) {
        this.scorers.addLast(scorer);
    }

    private Scorer first() {
        return (Scorer)this.scorers.getFirst();
    }

    private Scorer last() {
        return (Scorer)this.scorers.getLast();
    }

    public int doc() {
        return this.first().doc();
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            this.init(true);
        } else if (this.more) {
            this.more = this.last().next();
        }
        return this.doNext();
    }

    private boolean doNext() throws IOException {
        while (this.more && this.first().doc() < this.last().doc()) {
            this.more = this.first().skipTo(this.last().doc());
            this.scorers.addLast(this.scorers.removeFirst());
        }
        return this.more;
    }

    public boolean skipTo(int target) throws IOException {
        if (this.firstTime) {
            this.init(false);
        }
        Iterator i = this.scorers.iterator();
        while (this.more && i.hasNext()) {
            this.more = ((Scorer)i.next()).skipTo(target);
        }
        if (this.more) {
            this.sortScorers();
        }
        return this.doNext();
    }

    public float score() throws IOException {
        float score = 0.0f;
        Iterator i = this.scorers.iterator();
        while (i.hasNext()) {
            score += ((Scorer)i.next()).score();
        }
        return score *= this.coord;
    }

    private void init(boolean initScorers) throws IOException {
        this.coord = this.getSimilarity().coord(this.scorers.size(), this.scorers.size());
        boolean bl = this.more = this.scorers.size() > 0;
        if (initScorers) {
            Iterator i = this.scorers.iterator();
            while (this.more && i.hasNext()) {
                this.more = ((Scorer)i.next()).next();
            }
            if (this.more) {
                this.sortScorers();
            }
        }
        this.firstTime = false;
    }

    private void sortScorers() {
        Scorer[] array = this.scorers.toArray(new Scorer[this.scorers.size()]);
        this.scorers.clear();
        Arrays.sort(array, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Scorer)o1).doc() - ((Scorer)o2).doc();
            }
        });
        for (int i = 0; i < array.length; ++i) {
            this.scorers.addLast(array[i]);
        }
    }

    public Explanation explain(int doc) {
        throw new UnsupportedOperationException();
    }
}

