/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.dltk.debug.ui.actions.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class ToggleWatchPointAction
extends Action
implements IUpdate {
    private IWorkbenchPart fPart;
    private IDocument fDocument;
    private IVerticalRulerInfo fRulerInfo;

    public ToggleWatchPointAction(IWorkbenchPart part, IDocument document, IVerticalRulerInfo rulerInfo) {
        super(Messages.ToggleWatchPointAction_toggleWatchpoint);
        this.fPart = part;
        this.fDocument = document;
        this.fRulerInfo = rulerInfo;
    }

    public void run() {
        IAdapterManager manager;
        IDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        IToggleBreakpointsTarget adapter = (IToggleBreakpointsTarget)this.fPart.getAdapter(IToggleBreakpointsTarget.class);
        if (adapter == null && (manager = Platform.getAdapterManager()).hasAdapter((Object)this.fPart, IToggleBreakpointsTarget.class.getName())) {
            adapter = (IToggleBreakpointsTarget)manager.loadAdapter((Object)this.fPart, IToggleBreakpointsTarget.class.getName());
        }
        if (adapter == null) {
            return;
        }
        int line = this.fRulerInfo.getLineOfLastMouseButtonActivity();
        if (line == -1) {
            return;
        }
        if (line >= document.getNumberOfLines()) {
            return;
        }
        try {
            IRegion region = document.getLineInformation(line);
            TextSelection selection = new TextSelection(document, region.getOffset(), 0);
            if (adapter.canToggleLineBreakpoints(this.fPart, (ISelection)selection) && adapter.canToggleWatchpoints(this.fPart, (ISelection)selection)) {
                adapter.toggleWatchpoints(this.fPart, (ISelection)selection);
            }
        }
        catch (BadLocationException e) {
            this.reportException((Exception)((Object)e));
        }
        catch (CoreException e) {
            this.reportException((Exception)((Object)e));
        }
    }

    private void reportException(Exception e) {
        DebugUIPlugin.errorDialog((Shell)this.fPart.getSite().getShell(), (String)Messages.ToggleWatchPointAction_error, (String)Messages.ToggleWatchPointAction_error, (Throwable)e);
    }

    public void dispose() {
        this.fDocument = null;
        this.fPart = null;
        this.fRulerInfo = null;
    }

    private IDocument getDocument() {
        ITextEditor editor;
        IDocumentProvider provider;
        if (this.fDocument != null) {
            return this.fDocument;
        }
        if (this.fPart instanceof ITextEditor && (provider = (editor = (ITextEditor)this.fPart).getDocumentProvider()) != null) {
            return provider.getDocument((Object)editor.getEditorInput());
        }
        IDocument doc = (IDocument)this.fPart.getAdapter(IDocument.class);
        if (doc != null) {
            return doc;
        }
        return null;
    }

    public void update() {
        IDocument document = this.getDocument();
        if (document != null) {
            int line;
            IAdapterManager manager;
            IToggleBreakpointsTarget adapter = (IToggleBreakpointsTarget)this.fPart.getAdapter(IToggleBreakpointsTarget.class);
            if (adapter == null && (manager = Platform.getAdapterManager()).hasAdapter((Object)this.fPart, IToggleBreakpointsTarget.class.getName())) {
                adapter = (IToggleBreakpointsTarget)manager.loadAdapter((Object)this.fPart, IToggleBreakpointsTarget.class.getName());
            }
            if (adapter != null && (line = this.fRulerInfo.getLineOfLastMouseButtonActivity()) > -1 & line < document.getNumberOfLines()) {
                try {
                    IRegion region = document.getLineInformation(line);
                    TextSelection selection = new TextSelection(document, region.getOffset(), 0);
                    if (adapter.canToggleWatchpoints(this.fPart, (ISelection)selection)) {
                        this.setEnabled(true);
                        return;
                    }
                }
                catch (BadLocationException e) {
                    this.reportException((Exception)((Object)e));
                }
            }
        }
        this.setEnabled(false);
    }
}

