/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.koneki.ldt.Activator;

public final class LuaUtils {
    private LuaUtils() {
    }

    public static String getModuleFullName(IModuleSource module) {
        IModelElement modelElement = module.getModelElement();
        if (modelElement instanceof ISourceModule) {
            return LuaUtils.getModuleFullName((ISourceModule)modelElement);
        }
        return module.getFileName();
    }

    public static String getModuleFullName(ISourceModule module) {
        String moduleName = module.getElementName();
        if (moduleName.endsWith(".lua")) {
            moduleName = moduleName.replaceFirst("\\.lua$", "");
        }
        String prefix = null;
        if (module.getParent() instanceof IScriptFolder) {
            prefix = LuaUtils.getFolderFullName((IScriptFolder)module.getParent());
        }
        if (prefix != null) {
            if ("init".equalsIgnoreCase(moduleName)) {
                return prefix;
            }
            return String.valueOf(prefix) + "." + moduleName;
        }
        return moduleName;
    }

    private static String getFolderFullName(IScriptFolder folder) {
        if (!folder.isRootFolder()) {
            String folderName = folder.getElementName().replace("/", ".");
            IModelElement parent = folder.getParent();
            String prefix = null;
            if (parent instanceof IScriptFolder) {
                prefix = String.valueOf(LuaUtils.getFolderFullName((IScriptFolder)parent)) + ".";
            }
            if (prefix != null) {
                return String.valueOf(prefix) + "." + folderName;
            }
            return folderName;
        }
        return null;
    }

    public static IModuleSource getModuleSource(String name, IScriptProject project) {
        if (project == null && name == null || name.isEmpty()) {
            return null;
        }
        try {
            IProjectFragment[] allProjectFragments;
            IProjectFragment[] iProjectFragmentArray = allProjectFragments = project.getAllProjectFragments();
            int n = allProjectFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectFragment projectFragment = iProjectFragmentArray[n2];
                IModuleSource moduleSource = LuaUtils.getModuleSource(name, (IParent)projectFragment);
                if (moduleSource != null) {
                    return moduleSource;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            Activator.logError("unable to find module :" + name, e);
            return null;
        }
        return null;
    }

    private static IModuleSource getModuleSource(String name, IParent parent) throws ModelException {
        IModelElement[] children;
        IModelElement[] iModelElementArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleSource moduleSource;
            IModelElement child = iModelElementArray[n2];
            if (child instanceof IModuleSource) {
                if (name.equals(LuaUtils.getModuleFullName((IModuleSource)child))) {
                    return (IModuleSource)child;
                }
            } else if (child instanceof IParent && (moduleSource = LuaUtils.getModuleSource(name, (IParent)child)) != null) {
                return moduleSource;
            }
            ++n2;
        }
        return null;
    }

    public static ISourceModule getSourceModule(String name, IScriptProject project) {
        IModuleSource moduleSource = LuaUtils.getModuleSource(name, project);
        if (moduleSource instanceof ISourceModule) {
            return (ISourceModule)moduleSource;
        }
        return null;
    }

    public static IModuleSource getModuleSourceFromAbsoluteURI(URI absolutepath, IScriptProject project) {
        if (project == null || absolutepath == null) {
            return null;
        }
        ISourceModule sourceModule = LuaUtils.getSourceModuleFromAbsoluteURI(absolutepath, project);
        if (sourceModule instanceof IModuleSource) {
            return (IModuleSource)sourceModule;
        }
        return null;
    }

    public static ISourceModule getSourceModuleFromAbsoluteURI(URI absolutepath, IScriptProject project) {
        if (project == null || absolutepath == null) {
            return null;
        }
        try {
            IProjectFragment[] allProjectFragments;
            IProjectFragment[] iProjectFragmentArray = allProjectFragments = project.getAllProjectFragments();
            int n = allProjectFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectFragment projectFragment = iProjectFragmentArray[n2];
                ISourceModule moduleSource = LuaUtils.getSourceModuleFromAbsolutePath(absolutepath, (IParent)projectFragment);
                if (moduleSource != null) {
                    return moduleSource;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            Activator.logError("unable to find module :" + absolutepath, e);
            return null;
        }
        return null;
    }

    private static ISourceModule getSourceModuleFromAbsolutePath(URI absolutepath, IParent parent) throws ModelException {
        IModelElement[] children;
        IModelElement[] iModelElementArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceModule moduleSource;
            IModelElement child = iModelElementArray[n2];
            if (child instanceof ISourceModule) {
                if (URIUtil.sameURI((URI)absolutepath, (URI)LuaUtils.getModuleAbsolutePath((ISourceModule)child))) {
                    return (ISourceModule)child;
                }
            } else if (child instanceof IParent && (moduleSource = LuaUtils.getSourceModuleFromAbsolutePath(absolutepath, (IParent)child)) != null) {
                return moduleSource;
            }
            ++n2;
        }
        return null;
    }

    public static URI getModuleAbsolutePath(ISourceModule module) {
        if (module instanceof IExternalSourceModule) {
            String path = EnvironmentPathUtils.getLocalPath((IPath)module.getPath()).toString();
            if (path.length() != 0 && path.charAt(0) != '/') {
                path = String.valueOf('/') + path;
            }
            try {
                return new URI("file", "", path, null);
            }
            catch (URISyntaxException e) {
                Activator.logWarning("Unable to get file uri for external module : " + module.getPath(), e);
            }
        } else if (module.getResource() != null) {
            return module.getResource().getLocationURI();
        }
        return null;
    }
}

