/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.parser.ast;

import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.DefaultProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.koneki.ldt.parser.ast.declarations.DeclarationsContainer;

public class LuaSourceRoot
extends ModuleDeclaration {
    private DefaultProblem problem = null;
    private String documentation;
    private Map<String, String> memberDocumentation;
    private DeclarationsContainer declarationscontainer = new DeclarationsContainer();
    private boolean error;

    public LuaSourceRoot(int sourceLength) {
        super(sourceLength);
        this.addStatement((ASTNode)this.declarationscontainer);
    }

    public LuaSourceRoot(int length, boolean rebuild) {
        super(length, rebuild);
        this.addStatement((ASTNode)this.declarationscontainer);
    }

    public void setProblem(int line, int column, int offset, String message) {
        IProblemIdentifier id = DefaultProblemIdentifier.decode((int)offset);
        this.problem = new DefaultProblem("", message, id, new String[0], ProblemSeverity.ERROR, offset, -1, line, column);
        this.setError(true);
    }

    public boolean hasError() {
        return this.error;
    }

    public DefaultProblem getProblem() {
        return this.problem;
    }

    public void printNode(CorePrinter output) {
        FieldDeclaration[] fields;
        int n;
        MethodDeclaration[] functions = this.getFunctions();
        if (functions.length > 0) {
            output.print("functions: ");
            MethodDeclaration[] methodDeclarationArray = functions;
            n = functions.length;
            int n2 = 0;
            while (n2 < n) {
                MethodDeclaration function = methodDeclarationArray[n2];
                output.print(function.getName());
                output.print(' ');
                ++n2;
            }
            output.println();
        }
        if ((fields = this.getVariables()).length > 0) {
            output.print("fields: ");
            FieldDeclaration[] fieldDeclarationArray = fields;
            int n3 = fields.length;
            n = 0;
            while (n < n3) {
                FieldDeclaration field = fieldDeclarationArray[n];
                output.print(field.getName());
                output.print(' ');
                ++n;
            }
            output.println();
        }
        TypeDeclaration[] types = this.getTypes();
        if (fields.length > 0) {
            output.print("types: ");
            TypeDeclaration[] typeDeclarationArray = types;
            int n4 = types.length;
            int n5 = 0;
            while (n5 < n4) {
                TypeDeclaration type = typeDeclarationArray[n5];
                output.print(type.getName());
                output.print(' ');
                ++n5;
            }
            output.println();
        }
        output.indent();
        for (Object o : this.getStatements()) {
            if (!(o instanceof Statement)) continue;
            ((Statement)o).printNode(output);
        }
        output.dedent();
    }

    public void setGlobalDocumentation(String doc) {
        this.documentation = doc;
    }

    public String getGlobalDocumentation() {
        return this.documentation;
    }

    public void setMembersDocumentation(Map<String, String> doc) {
        this.memberDocumentation = doc;
    }

    public String getMemberDocumentation(String memberIdentifier) {
        if (this.memberDocumentation != null) {
            return this.memberDocumentation.get(memberIdentifier);
        }
        return null;
    }

    public DeclarationsContainer getDeclarationsContainer() {
        return this.declarationscontainer;
    }

    public void setError(boolean status) {
        this.error = status;
    }
}

