/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.parser.ast.declarations;

import java.util.ArrayList;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.koneki.ldt.internal.parser.INavigableNode;
import org.eclipse.koneki.ldt.internal.parser.IOccurrenceHolder;
import org.eclipse.koneki.ldt.parser.ast.expressions.Identifier;
import org.eclipse.koneki.ldt.parser.ast.statements.Chunk;

public class FunctionDeclaration
extends MethodDeclaration
implements IOccurrenceHolder,
INavigableNode {
    private ArrayList<ASTNode> occurrences = new ArrayList();
    private ASTNode parentNode;

    public FunctionDeclaration(String name, int nameStart, int nameEnd, int start, int end) {
        super(name, nameStart, nameEnd, start, end);
    }

    public FunctionDeclaration(SimpleReference name, int start, int end) {
        this(name.getName(), name.sourceStart(), name.sourceEnd(), start, end);
    }

    public void acceptArguments(Chunk params) {
        for (Object o : params.getChilds()) {
            Argument arg;
            if (o instanceof Identifier) {
                Identifier id = (Identifier)o;
                arg = new Argument((SimpleReference)id, id.sourceStart(), id.sourceEnd(), null, this.getModifiers());
            } else {
                Statement statement = (Statement)o;
                SimpleReference dots = new SimpleReference(statement.sourceStart(), statement.sourceEnd(), "...");
                arg = new Argument(dots, dots.sourceStart(), null, this.getModifiers());
            }
            this.addArgument(arg);
        }
    }

    @Override
    public void addOccurrence(ASTNode node) {
        this.occurrences.add(node);
    }

    @Override
    public ASTNode[] getOccurrences() {
        return this.occurrences.toArray(new ASTNode[this.occurrences.size()]);
    }

    @Override
    public ASTNode getParent() {
        return this.parentNode;
    }

    @Override
    public void setParent(ASTNode parent) {
        this.parentNode = parent;
    }

    public boolean isGlobal() {
        return this.isPublic();
    }

    public boolean isLocal() {
        return this.isPrivate();
    }
}

