/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.parser.ast.expressions;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.Literal;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.koneki.ldt.parser.LuaExpressionConstants;
import org.eclipse.koneki.ldt.parser.ast.expressions.Identifier;

public class Index
extends Identifier
implements LuaExpressionConstants {
    private long id;
    private Expression container;

    public Index(Expression key, Declaration value) {
        this(key, (Statement)value);
    }

    public Index(Expression key, Expression value) {
        this(key, (Statement)value);
    }

    private Index(Expression key, Statement value) {
        super(value.sourceStart(), value.sourceEnd(), Index.statementToString(value));
        this.container = key;
    }

    private static String statementToString(Statement statement) {
        if (statement instanceof Declaration) {
            return ((Declaration)statement).getName();
        }
        if (statement instanceof Literal) {
            return ((Literal)statement).getValue();
        }
        return statement.toString();
    }

    public Expression getContainer() {
        return this.container;
    }

    public long getID() {
        return this.id;
    }

    public int getKind() {
        return 1049;
    }

    public void setID(long id) {
        this.id = id;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            super.traverse(visitor);
            this.container.traverse(visitor);
            visitor.endvisit((Expression)this);
        }
    }

    public Expression getRoot() {
        Expression left = this.getContainer();
        if (left instanceof Index) {
            return ((Index)left).getRoot();
        }
        return left;
    }
}

