/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.parser.ast.expressions;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.koneki.ldt.internal.parser.INavigableNode;
import org.eclipse.koneki.ldt.parser.ast.expressions.BinaryExpression;

public class UnaryExpression
extends Expression
implements INavigableNode {
    private int kind;
    private Statement expression;
    private ASTNode parentNode;

    public UnaryExpression(int start, int end, int kind, Statement e) {
        super(start, end);
        this.expression = e;
        this.kind = kind;
    }

    public UnaryExpression(int start, int end, String operatorName, Statement e) {
        this(start, end, BinaryExpression.operatorNameToKind(operatorName), e);
    }

    public Statement getExpression() {
        return this.expression;
    }

    public int getKind() {
        return this.kind;
    }

    public String getOperator() {
        switch (this.getKind()) {
            case 38002: {
                return "#";
            }
            case 38004: {
                return "-";
            }
            case 1027: {
                return " not ";
            }
        }
        return super.getOperator();
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Expression)this)) {
            super.traverse(pVisitor);
            if (this.getExpression() != null) {
                this.getExpression().traverse(pVisitor);
            }
            pVisitor.endvisit((Expression)this);
        }
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn(String.valueOf(this.getOperator()) + this.getExpression().toString());
    }

    @Override
    public ASTNode getParent() {
        return this.parentNode;
    }

    @Override
    public void setParent(ASTNode parent) {
        this.parentNode = parent;
    }
}

